/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare.xml_compare_tool;

import com.bmc.toolbox.ToolBoxCLIEntity;
import com.bmc.toolbox.compare.xml_compare.XMLChangesCsvWriter;
import com.bmc.toolbox.compare.xml_compare.XmlCompare;
import com.bmc.toolbox.compare.xml_compare.xml_compare_tool.ArgsHandler;
import com.bmc.toolbox.compare.xml_compare.xml_compare_tool.StatisticHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XMLCompareTool
implements ToolBoxCLIEntity {
    private int RC = -1;
    private List<String> errorMessage;
    private XmlCompare comperator;
    private File file1;
    private File file2;
    private ArgsHandler argsHandler;

    public XMLCompareTool(String[] args, XmlCompare comparator) {
        this.argsHandler = new ArgsHandler(args);
        this.comperator = comparator;
        this.file1 = this.argsHandler.getFirstFile();
        this.file2 = this.argsHandler.getSecondFile();
        this.errorMessage = new ArrayList<String>();
        if (!this.argsHandler.isValidArgs()) {
            this.errorMessage.add(this.argsHandler.getErrorMessage());
        }
    }

    @Override
    public void execute(String ... args) {
        if (this.argsHandler.isValidArgs()) {
            try (XMLChangesCsvWriter changesWriter = new XMLChangesCsvWriter(this.argsHandler.getOutPutFile());){
                this.comperator.compare(this.file1, this.file2);
                this.comperator.forEachChange(changesWriter);
                this.RC = 0;
            }
            catch (SAXException e) {
                System.err.println(e.getMessage());
                this.errorMessage.add(e.getMessage());
                this.RC = 1;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                this.errorMessage.add(e.getMessage());
                this.RC = 1;
            }
            catch (ParserConfigurationException e) {
                System.err.println(e.getMessage());
                this.errorMessage.add(e.getMessage());
                this.RC = 1;
            }
        }
    }

    @Override
    public boolean validate(String ... args) {
        return this.argsHandler.isValidArgs();
    }

    @Override
    public String getUsage() {
        return "XML_COMPARE USAGE :\n\tXML_COMPARE <XML_FILE1> <XML_FILE2>";
    }

    @Override
    public String getOutput() {
        File outPutFile = this.argsHandler.getOutPutFile();
        StatisticHandler statisticHandler = new StatisticHandler();
        this.comperator.forEachChange(statisticHandler);
        StringBuilder output = new StringBuilder("XML Compare Tool ended successfully\n");
        output.append("Results:\n" + statisticHandler.toString() + "\n");
        if (statisticHandler.isThereAnyChange()) {
            output.append("Results output can be located under: " + outPutFile.getAbsolutePath());
        }
        return output.toString();
    }

    @Override
    public int getRC() {
        return this.RC;
    }

    @Override
    public String getValidationErrors() {
        StringBuilder sb = new StringBuilder();
        for (String message : this.errorMessage) {
            sb.append(message).append("\n");
        }
        return sb.toString();
    }
}

