/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare.xml_compare_tool;

import java.io.File;

public class ArgsHandler {
    public static final String CHANGES_CSV = "changes.csv";
    private String[] args;
    private String errorMessage;
    private File firstFile = new File("");
    private File secondFile = new File("");
    private File outputFile = new File("");
    private boolean isValid;

    public ArgsHandler(String[] args) {
        this.args = args;
        this.initFiles();
        this.validateArgs();
    }

    private void initFiles() {
        if (this.args != null) {
            if (this.args.length > 0) {
                this.firstFile = new File(this.args[0]);
            }
            if (this.args.length > 1) {
                this.secondFile = new File(this.args[1]);
            }
            this.initOutputFile();
        }
    }

    private void initOutputFile() {
        this.outputFile = this.args.length > 2 ? new File(this.args[2]) : new File(CHANGES_CSV);
    }

    private void validateArgs() {
        this.isValid = false;
        if (this.args == null) {
            return;
        }
        if (!this.verifyIsFileAndExists(this.firstFile) || !this.verifyIsFileAndExists(this.secondFile)) {
            this.errorMessage = "specified file cannot be found";
            return;
        }
        if (this.outputFile.exists() && !this.outputFile.canWrite()) {
            this.errorMessage = "cannot open file  " + this.outputFile.getAbsolutePath();
            return;
        }
        this.isValid = true;
    }

    private boolean verifyIsFileAndExists(File file) {
        return file.exists() && !file.isDirectory();
    }

    public File getFirstFile() {
        return this.firstFile;
    }

    public File getSecondFile() {
        return this.secondFile;
    }

    public boolean isValidArgs() {
        return this.isValid;
    }

    public File getOutPutFile() {
        return this.outputFile;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

