/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare.changes;

import com.bmc.toolbox.compare.xml_compare.XmlElement;
import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AttributeChange
extends XmlChange {
    private String attributeName;
    private String attributeValue;
    private XmlElement element;

    public AttributeChange(XmlElement element1, XmlElement element2, String attributeName, String attributeValue) {
        super(element1, element2);
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.element = element1;
    }

    @Override
    public String getPath() {
        return this.element.getXPath();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    public XmlChange.Type getChaneType() {
        return XmlChange.Type.ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.attributeName;
    }

    @Override
    public List<String> getParentPathList() {
        List<String> parentPath = ((Stream)this.element.getElementsPath().stream().sequential()).map(elementParent -> elementParent.getID()).collect(Collectors.toList());
        Collections.reverse(parentPath);
        return parentPath;
    }

    @Override
    public String getIdentifier() {
        return this.getAttributeValue();
    }
}

