/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare;

import com.bmc.toolbox.compare.xml_compare.AttributeNameIgnoreHandler;
import com.bmc.toolbox.compare.xml_compare.AttributesComperator;
import com.bmc.toolbox.compare.xml_compare.IgnoreHandler;
import com.bmc.toolbox.compare.xml_compare.Logger;
import com.bmc.toolbox.compare.xml_compare.XMLAttributeChange;
import com.bmc.toolbox.compare.xml_compare.XmlElement;
import com.bmc.toolbox.compare.xml_compare.XmlLoader;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeAddChange;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeRemovedChange;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeValueChanged;
import com.bmc.toolbox.compare.xml_compare.changes.ElementAddChange;
import com.bmc.toolbox.compare.xml_compare.changes.ElementRemovedChange;
import com.bmc.toolbox.compare.xml_compare.changes.ElementUnorderedChange;
import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class XmlCompare {
    private LinkedHashMap<String, String> elementIdentifiersMap;
    private List<XmlChange> changeList = new ArrayList<XmlChange>();
    private List<String> orderdTags;
    private IgnoreHandler ignoreHandler;

    public XmlCompare() {
        this.elementIdentifiersMap = new LinkedHashMap();
        this.ignoreHandler = new AttributeNameIgnoreHandler();
        this.orderdTags = new ArrayList<String>();
    }

    public void putAllOrderdTags(ArrayList<String> orderdTags) {
        this.orderdTags.addAll(orderdTags);
    }

    public void addOrderdTag(String orderdTagName) {
        this.orderdTags.add(orderdTagName);
    }

    public void putAllElementIdentifiers(Map<String, String> elementIdentifiersMap) {
        this.elementIdentifiersMap.putAll(elementIdentifiersMap);
    }

    public void setIgnoreHandler(IgnoreHandler ignoreHandler) {
        this.ignoreHandler = ignoreHandler;
    }

    public void compare(File file1, File file2) throws SAXException, IOException, ParserConfigurationException {
        try (FileInputStream inputstream1 = new FileInputStream(file1);
             FileInputStream inputstream2 = new FileInputStream(file2);){
            this.compare(inputstream1, inputstream2);
        }
    }

    public void compare(InputStream inputStream1, InputStream inputStream2) throws SAXException, IOException, ParserConfigurationException {
        XmlElement draft1 = this.getRootElement(inputStream1);
        XmlElement draft2 = this.getRootElement(inputStream2);
        this.compare2xmlElements(draft1, draft2);
    }

    private XmlElement getRootElement(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        XmlLoader loader = new XmlLoader(this.elementIdentifiersMap);
        loader.loadFile(inputStream);
        return loader.getElement();
    }

    public void forEachChange(ChangeHandelr handler) {
        for (XmlChange xmlChange : this.changeList) {
            handler.handleChange(xmlChange);
        }
    }

    private void compare2xmlElements(XmlElement element1, XmlElement element2) {
        if (element1 == null || element2 == null) {
            Logger.instance().add("undefined element");
            return;
        }
        if (!this.hasSameTagName(element1, element2)) {
            Logger.instance().add("cannot  comapre   2 diffrent elements :   " + element1.getTagName() + " and  " + element2.getTagName() + " in path : ");
        }
        Logger.instance().add("compare " + element1.getTagName() + ":" + element1.getIdentifier());
        this.compareAttributes(element1, element2);
        this.compareChildren(element1, element2);
    }

    private boolean hasSameTagName(XmlElement element1, XmlElement element2) {
        return element1.getTagName().equals(element2.getTagName());
    }

    private void compareAttributes(XmlElement element1, XmlElement element2) {
        String attributeValue;
        String attributeName;
        if (!this.hasSameTagName(element1, element2)) {
            return;
        }
        AttributesComperator attributesComperator = new AttributesComperator(element1.getAttributesValues(), element2.getAttributesValues());
        Map<String, String> onlyOn1attributes = attributesComperator.getOnlyOn1();
        Map<String, String> onlyOn2attributes = attributesComperator.getOnlyOn2();
        for (Map.Entry<String, String> attribute : onlyOn1attributes.entrySet()) {
            attributeName = attribute.getKey();
            attributeValue = attribute.getValue();
            AttributeRemovedChange attributeRemoved = new AttributeRemovedChange(element1, element2, attributeName, attributeValue);
            this.insertChange(attributeRemoved);
        }
        for (Map.Entry<String, String> attribute : onlyOn2attributes.entrySet()) {
            attributeName = attribute.getKey();
            attributeValue = attribute.getValue();
            AttributeAddChange attributeAdd = new AttributeAddChange(element1, element2, attributeName, attributeValue);
            this.insertChange(attributeAdd);
        }
        List<XMLAttributeChange> changes = attributesComperator.getAttributeChanges();
        for (XMLAttributeChange attributeChange : changes) {
            String attributeName2 = attributeChange.getAttributeName();
            String attributeValue1 = attributeChange.getFirstValue();
            String attributeValue2 = attributeChange.getSecondValue();
            AttributeValueChanged attributeChanged = new AttributeValueChanged(element1, element2, attributeName2, attributeValue1, attributeValue2);
            this.insertChange(attributeChanged);
        }
    }

    private void insertChange(XmlChange change) {
        boolean isIgnore = this.ignoreHandler.isChangeNeedToBeIgnored(change);
        if (!isIgnore) {
            this.changeList.add(change);
        }
    }

    private void compareChildren(XmlElement element1, XmlElement element2) {
        Logger.instance().add("CompareChilds ");
        HashSet<String> unionTags = new HashSet<String>();
        unionTags.addAll(element1.getChildsTags());
        unionTags.addAll(element2.getChildsTags());
        List<XmlElement> childList1 = element1.getAllDirectchildsElement();
        List<XmlElement> childList2 = element2.getAllDirectchildsElement();
        for (String tagName : unionTags) {
            Object xmlElement2;
            List<XmlElement> orederdChildList1 = ((Stream)childList1.stream().sequential()).filter(element -> element.getTagName().equals(tagName)).collect(Collectors.toList());
            List<XmlElement> orederdChildList2 = ((Stream)childList2.stream().sequential()).filter(element -> element.getTagName().equals(tagName)).collect(Collectors.toList());
            LinkedHashMap<XmlElement, XmlElement> corespondedElementsMap = this.findCorespondedElements(orederdChildList1, orederdChildList2);
            Logger.instance().add("corespondedElementsMap");
            Logger.instance().add("Childs : " + corespondedElementsMap.size());
            List onlyOn1 = orederdChildList1.stream().filter(element -> !corespondedElementsMap.containsKey(element)).collect(Collectors.toList());
            for (Object xmlElement2 : onlyOn1) {
                ElementRemovedChange removedChange = new ElementRemovedChange(element1, element2, (XmlElement)xmlElement2);
                this.insertChange(removedChange);
            }
            List onlyOn2 = ((Stream)orederdChildList2.stream().sequential()).filter(element -> !corespondedElementsMap.values().contains(element)).collect(Collectors.toList());
            xmlElement2 = onlyOn2.iterator();
            while (xmlElement2.hasNext()) {
                XmlElement xmlElement3 = (XmlElement)xmlElement2.next();
                ElementAddChange addedChange = new ElementAddChange(element1, element2, xmlElement3);
                this.insertChange(addedChange);
            }
            ArrayList<XmlElement> unOrdererdElementList = this.getUnorderedElements(corespondedElementsMap, orederdChildList2);
            if (this.isNeedToBeOrdered(tagName)) {
                for (XmlElement xmlElement4 : unOrdererdElementList) {
                    ElementUnorderedChange unOrederedChange = new ElementUnorderedChange(element1, element2, xmlElement4);
                    this.insertChange(unOrederedChange);
                }
            }
            for (XmlElement xmlElement4 : corespondedElementsMap.keySet()) {
                if (xmlElement4 == null) continue;
                this.compare2xmlElements(xmlElement4, corespondedElementsMap.get(xmlElement4));
            }
        }
    }

    private ArrayList<XmlElement> getUnorderedElements(LinkedHashMap<XmlElement, XmlElement> corespondedElementsMap, List<XmlElement> orederdChildList2) {
        int lastIndexInSecondList = -2;
        ArrayList<XmlElement> unOrdererdElementList = new ArrayList<XmlElement>();
        for (XmlElement xmlElement : corespondedElementsMap.keySet()) {
            XmlElement correspondeddElement = corespondedElementsMap.get(xmlElement);
            int indexInSecondList = orederdChildList2.indexOf(correspondeddElement);
            if (lastIndexInSecondList == -2) {
                lastIndexInSecondList = indexInSecondList;
                continue;
            }
            if (indexInSecondList < lastIndexInSecondList) {
                unOrdererdElementList.add(correspondeddElement);
            }
            lastIndexInSecondList = indexInSecondList;
        }
        return unOrdererdElementList;
    }

    private boolean isNeedToBeOrdered(String tagName) {
        if (this.orderdTags == null) {
            return false;
        }
        return this.orderdTags.contains(tagName);
    }

    private LinkedHashMap<XmlElement, XmlElement> findCorespondedElements(List<XmlElement> orederdChildList1, List<XmlElement> orederdChildList2) {
        ArrayList<XmlElement> tmplist = new ArrayList<XmlElement>();
        tmplist.addAll(orederdChildList2);
        LinkedHashMap<XmlElement, XmlElement> ret = new LinkedHashMap<XmlElement, XmlElement>();
        ((Stream)orederdChildList1.stream().sequential()).forEach(element -> {
            XmlElement correspondElmenet = this.findCorespondedElement((XmlElement)element, (List<XmlElement>)tmplist);
            if (correspondElmenet != null) {
                tmplist.remove(correspondElmenet);
                ret.put((XmlElement)element, correspondElmenet);
            }
        });
        return ret;
    }

    private XmlElement findCorespondedElement(XmlElement seekelement, List<XmlElement> list) {
        Optional<XmlElement> res = ((Stream)list.stream().sequential()).filter(element -> this.isCorrespond((XmlElement)element, seekelement)).findFirst();
        return res.orElse(null);
    }

    private boolean isCorrespond(XmlElement element1, XmlElement element2) {
        String tag1 = element1.getTagName();
        if (!tag1.equals(element2.getTagName())) {
            return false;
        }
        String element1Identity = element1.getIdentifier();
        String element2Identity = element2.getIdentifier();
        if (element1Identity != null && element2Identity != null) {
            return element1Identity.equals(element2Identity);
        }
        LinkedHashMap<String, String> element1AttributesList = element1.getAttributesValues();
        LinkedHashMap<String, String> element2AttributesList = element2.getAttributesValues();
        return element1AttributesList.equals(element2AttributesList);
    }

    public void addIdentifier(String tagName, String attributeName) {
        this.elementIdentifiersMap.put(tagName, attributeName);
    }

    public static interface ChangeHandelr {
        public void handleChange(XmlChange var1);
    }
}

