/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.xml_compare;

import com.bmc.toolbox.compare.xml_compare.IgnoreHandler;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeAddChange;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeRemovedChange;
import com.bmc.toolbox.compare.xml_compare.changes.AttributeValueChanged;
import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import java.util.ArrayList;
import java.util.List;

public class AttributeNameIgnoreHandler
implements IgnoreHandler {
    private List<String> ignoreAttributes = new ArrayList<String>();

    private boolean isAttributeChangeNeedToBeIgnored(String attributeName) {
        return this.ignoreAttributes.contains(attributeName);
    }

    public void ignoreAttribute(String attributeName) {
        this.ignoreAttributes.add(attributeName);
    }

    @Override
    public boolean isChangeNeedToBeIgnored(XmlChange change) {
        if (change instanceof AttributeValueChanged) {
            AttributeValueChanged valueChanged = (AttributeValueChanged)change;
            String attributeName = valueChanged.getAttributeName();
            return this.isAttributeChangeNeedToBeIgnored(attributeName);
        }
        if (change instanceof AttributeAddChange) {
            AttributeAddChange valueAdded = (AttributeAddChange)change;
            String attributeName = valueAdded.getAttributeName();
            return this.isAttributeChangeNeedToBeIgnored(attributeName);
        }
        if (change instanceof AttributeRemovedChange) {
            AttributeRemovedChange valueRemoved = (AttributeRemovedChange)change;
            String attributeName = valueRemoved.getAttributeName();
            return this.isAttributeChangeNeedToBeIgnored(attributeName);
        }
        return false;
    }
}

