/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import com.bmc.toolbox.compare.csv_compare.ComparedTable;
import com.bmc.toolbox.compare.csv_compare.CsvChange;
import com.bmc.toolbox.compare.csv_compare.CsvChangeList;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class CsvComparator {
    private ComparedTable oldTable;
    private ComparedTable newTable;
    private HashSet<String> ignoredColumns;
    private HashSet<String> keyColumns;
    private boolean orderSignificant;
    private CsvChangeList changes;

    public CsvComparator(CsvReader oldCsvReader, CsvReader newCsvReader) throws IOException {
        this.oldTable = new ComparedTable(oldCsvReader);
        this.newTable = new ComparedTable(newCsvReader);
        this.ignoredColumns = new HashSet();
        this.keyColumns = new HashSet();
        this.changes = new CsvChangeList();
    }

    public void addIgnoredColumn(String colName) {
        this.ignoredColumns.add(colName);
        this.newTable.addIgnoredColumn(colName);
        this.oldTable.addIgnoredColumn(colName);
    }

    public void addKeyColumn(String colName) {
        this.keyColumns.add(colName);
        this.newTable.addKey(colName);
        this.oldTable.addKey(colName);
    }

    public void setOrderSignificant(boolean siginificant) {
        this.orderSignificant = siginificant;
    }

    public int compare() {
        try {
            this.compareHeaders();
            this.oldTable.loadTable();
            this.newTable.loadTable();
            if (this.orderSignificant) {
                this.compareContentOrdered();
            } else {
                this.compareContentUnordered();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        return this.changes.size();
    }

    private void compareContentOrdered() {
        if (this.keyColumns.isEmpty()) {
            this.compareOrderedNoKeys();
        } else {
            this.compareContentOrderedWithKeys();
        }
    }

    private void compareContentOrderedWithKeys() {
        int lastMatchedNewIdx = -1;
        for (int oldIdx = 0; oldIdx < this.oldTable.getRecordCount(); ++oldIdx) {
            HashMap<String, String> oldRecord = this.oldTable.getRecordByIndex(oldIdx);
            HashSet<String> keysToSet = this.oldTable.keysToSet(oldRecord);
            int newIndexMatched = this.newTable.getRecordIndexByKey(keysToSet);
            if (newIndexMatched < 0 || newIndexMatched < lastMatchedNewIdx) {
                CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, oldIdx, null);
                change.setOldValue(oldRecord.toString());
                this.changes.add(change);
                continue;
            }
            this.reportAddedByIndexRange(lastMatchedNewIdx, newIndexMatched);
            this.compareRecords(oldIdx, newIndexMatched);
            lastMatchedNewIdx = newIndexMatched;
        }
        this.reportAddedByIndexRange(lastMatchedNewIdx, this.newTable.getRecordCount());
    }

    private void compareOrderedNoKeys() {
        int lastMatchedNewIdx = -1;
        for (int oldIdx = 0; oldIdx < this.oldTable.getRecordCount(); ++oldIdx) {
            int nextMatchIndex = this.newTable.findIdenticalRecordIndexStartingFrom(this.oldTable.getRecordByIndex(oldIdx), lastMatchedNewIdx + 1);
            if (nextMatchIndex < 0) {
                CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, oldIdx, null);
                change.setOldValue(this.oldTable.getRecordByIndex(oldIdx).toString());
                this.changes.add(change);
                continue;
            }
            this.reportAddedByIndexRange(lastMatchedNewIdx, nextMatchIndex);
            lastMatchedNewIdx = nextMatchIndex;
        }
    }

    private void reportAddedByIndexRange(int startIndex, int endIndex) {
        for (int addedRecordIndex = startIndex + 1; addedRecordIndex < endIndex && addedRecordIndex < this.newTable.getRecordCount(); ++addedRecordIndex) {
            CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, null, addedRecordIndex);
            change.setNewValue(this.newTable.getRecordByIndex(addedRecordIndex).toString());
            this.changes.add(change);
        }
    }

    private void compareContentUnordered() {
        if (this.keyColumns.isEmpty()) {
            this.compareUnorderedNoKeys();
        } else {
            this.compareContentUnorderedWithKeys();
        }
    }

    private void compareUnorderedNoKeys() {
        ArrayList<Integer> newListMatched = new ArrayList<Integer>();
        int newTableStartIdx = 0;
        for (int oldIdx = 0; oldIdx < this.oldTable.getRecordCount(); ++oldIdx) {
            HashMap<String, String> oldTableRecordByIndex = this.oldTable.getRecordByIndex(oldIdx);
            Integer newTableIdx = this.newTable.findIdenticalRecordIndexStartingFrom(oldTableRecordByIndex, newTableStartIdx);
            if (newTableIdx >= 0) {
                if (!newListMatched.contains(newTableIdx)) {
                    newListMatched.add(newTableIdx);
                    newTableStartIdx = 0;
                    continue;
                }
                newTableStartIdx = newTableIdx + 1;
                --oldIdx;
                continue;
            }
            CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, oldIdx, null);
            change.setOldValue(this.oldTable.getRecordByIndex(oldIdx).toString());
            this.changes.add(change);
            newTableStartIdx = 0;
        }
        this.reportNewRecords(newListMatched);
    }

    private void compareContentUnorderedWithKeys() {
        ArrayList<Integer> newListMatched = new ArrayList<Integer>();
        for (int oldIdx = 0; oldIdx < this.oldTable.getRecordCount(); ++oldIdx) {
            HashMap<String, String> oldRecord = this.oldTable.getRecordByIndex(oldIdx);
            Integer newTableIdx = this.newTable.getRecordIndexByKey(this.oldTable.keysToSet(oldRecord));
            while (newListMatched.contains(newTableIdx) && newTableIdx >= 0) {
                newTableIdx = this.newTable.getRecordIndexByKeyWithMin(this.oldTable.keysToSet(oldRecord), newTableIdx + 1);
            }
            if (newTableIdx >= 0) {
                newListMatched.add(newTableIdx);
                this.compareRecords(oldIdx, newTableIdx);
                continue;
            }
            CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, oldIdx, null);
            change.setOldValue(this.oldTable.getRecordByIndex(oldIdx).toString());
            this.changes.add(change);
        }
        this.reportNewRecords(newListMatched);
    }

    private void reportNewRecords(List<Integer> matchedIndices) {
        Integer newIdx = 0;
        while (newIdx < this.newTable.getRecordCount()) {
            if (!matchedIndices.contains(newIdx)) {
                CsvChange change = new CsvChange(CsvChange.ChangeType.ROW, null, newIdx);
                change.setNewValue(this.newTable.getRecordByIndex(newIdx).toString());
                this.changes.add(change);
            }
            Integer n = newIdx;
            newIdx = newIdx + 1;
        }
    }

    private void compareRecords(int oldRecordIdx, int newRecordIdx) {
        HashMap<String, String> newRecord = this.newTable.getRecordByIndex(newRecordIdx);
        HashMap<String, String> oldRecord = this.oldTable.getRecordByIndex(oldRecordIdx);
        for (String column : oldRecord.keySet()) {
            if (oldRecord.get(column).equals(newRecord.get(column))) continue;
            CsvChange change = new CsvChange(CsvChange.ChangeType.IN_VALUE, oldRecordIdx, newRecordIdx);
            change.setNewValue(column + "=" + newRecord.get(column));
            change.setOldValue(column + "=" + oldRecord.get(column));
            this.changes.add(change);
        }
    }

    private void compareHeaders() {
        CsvChange change;
        ArrayList<String> oldHeader = this.oldTable.getHeader();
        ArrayList<String> newHeader = this.newTable.getHeader();
        for (String oldColumn : oldHeader) {
            if (newHeader.contains(oldColumn) || this.isIgnored(oldColumn)) continue;
            this.addIgnoredColumn(oldColumn);
            change = new CsvChange(CsvChange.ChangeType.COLUMN, null, null);
            change.setOldValue(oldColumn);
            this.changes.add(change);
        }
        for (String newColumn : newHeader) {
            if (oldHeader.contains(newColumn) || this.isIgnored(newColumn)) continue;
            this.addIgnoredColumn(newColumn);
            change = new CsvChange(CsvChange.ChangeType.COLUMN, null, null);
            change.setNewValue(newColumn);
            this.changes.add(change);
        }
    }

    private boolean isIgnored(String column) {
        return this.ignoredColumns.contains(column);
    }

    public CsvChangeList getChangeList() {
        return this.changes;
    }
}

