/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import com.bmc.toolbox.compare.csv_compare.CsvChange;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;

public class CsvChangeList
extends ArrayList<CsvChange> {
    private static final long serialVersionUID = 2799863120347412017L;
    public static final String[] header = new String[]{"change type", "record index", "value"};

    public void writeToFile(CsvWriter target) throws IOException {
        target.writeRecord(header);
        for (CsvChange chng : this) {
            target.writeRecord(this.changeToArr(chng));
        }
        target.close();
    }

    private String[] changeToArr(CsvChange chng) {
        String[] record = new String[]{this.getChangeType(chng), this.indiciesToString(chng), this.getChangeValue(chng)};
        return record;
    }

    private String getChangeValue(CsvChange chng) {
        String toRet = null;
        switch (chng.getChangeType()) {
            case COLUMN: 
            case ROW: {
                toRet = this.isAdded(chng) ? chng.getNewValue() : chng.getOldValue();
                break;
            }
            case IN_VALUE: {
                toRet = String.format("%s --> %s", chng.getOldValue().split("=")[1], chng.getNewValue().split("=")[1]);
                break;
            }
        }
        return toRet;
    }

    private String getChangeType(CsvChange chng) {
        String toRet = null;
        switch (chng.getChangeType()) {
            case COLUMN: 
            case ROW: {
                toRet = String.format("%s %s", this.isAdded(chng) ? "Added" : "Removed", chng.getChangeType().toString().toLowerCase());
                break;
            }
            case IN_VALUE: {
                toRet = String.format("Changed %s", chng.getKeyForTypeChange());
                break;
            }
        }
        return toRet;
    }

    private String indiciesToString(CsvChange chng) {
        Integer newIdx = chng.getNewRowIndex();
        Integer oldIdx = chng.getOldRowIndex();
        Object toRet = "";
        if (chng.getChangeType() == CsvChange.ChangeType.COLUMN) {
            toRet = "N/A";
        } else {
            if (oldIdx != null) {
                toRet = (String)toRet + Integer.toString(oldIdx);
            }
            if (chng.getChangeType() == CsvChange.ChangeType.IN_VALUE) {
                toRet = (String)toRet + " -- ";
            }
            if (newIdx != null) {
                toRet = (String)toRet + Integer.toString(newIdx);
            }
        }
        return toRet;
    }

    private boolean isAdded(CsvChange chng) {
        return chng.getOldRowIndex() == null;
    }
}

