/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.csv_compare;

import com.bmc.toolbox.ToolBoxCLIEntity;
import com.bmc.toolbox.compare.csv_compare.ArgsHandler;
import com.bmc.toolbox.compare.csv_compare.CsvChangeList;
import com.bmc.toolbox.compare.csv_compare.CsvComparator;
import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CSVComparisonExecutor
implements ToolBoxCLIEntity {
    private int rc = 0;
    private ArrayList<String> validationMessages = new ArrayList();
    private ArrayList<String> StdOut = new ArrayList();
    private static final String usage = "Usage:\nCompare two CSV files, and output results to a 3rd CSV file.\n\tcsv_compare -old <file> -new <file> [-out_file <file>] [-keys <column name> [column name...]] [-ignore <column name> [column name...]] [-ordered {Y|N}]\n\t\t-old, -new: existing CSVs to be compared\n\t\t-out: CSV file to hold comparison results. File contents will be overwritten.\n\t\t\tDefault: create a temporary file\n\t\t-keys: a space separated list of column names to be used as row IDs.\n\t\t\tTwo rows will be tested against each other if and only if all values in key columns are identical\n\t\t\tDefault: Empty - Changes within a row will be detected as new/removed line\n\t\t-ignore: a space separated list of column names. Values in these columns will be ignored when comparaing two lines\n\t\t\tDefault: Empty - All columns will be regarded.\n\t\t-ordered: Is row order siginifcant\n\t\t\tDefault: N - Row order is not significant\n";
    private static final int INVALID_INPUT_RC = 17;
    private static final int FAILED_TO_COMPARE_RC = 11;

    @Override
    public boolean validate(String ... args) {
        boolean isValid;
        HashMap<String, List<String>> argsMap = ArgsHandler.mapArgs(args);
        this.validationMessages.addAll(ArgsHandler.getValidationErrs(argsMap));
        boolean bl = isValid = this.validationMessages.size() == 0;
        if (!isValid) {
            this.rc = 17;
        }
        return isValid;
    }

    @Override
    public String getUsage() {
        return usage;
    }

    @Override
    public void execute(String ... args) {
        if (this.validate(args)) {
            HashMap<String, List<String>> argsMap = ArgsHandler.mapArgs(args);
            String oldFile = argsMap.get("-old").get(0);
            String newFile = argsMap.get("-new").get(0);
            CsvComparator comparator = null;
            try {
                comparator = new CsvComparator(new CsvReader(oldFile), new CsvReader(newFile));
                if (argsMap.containsKey("-ordered")) {
                    comparator.setOrderSignificant(argsMap.get("-ordered").get(0).equalsIgnoreCase("y"));
                }
                if (argsMap.containsKey("-keys")) {
                    for (String key : argsMap.get("-keys")) {
                        comparator.addKeyColumn(key);
                    }
                }
                if (argsMap.containsKey("-ignore")) {
                    for (String colname : argsMap.get("-ignore")) {
                        comparator.addIgnoredColumn(colname);
                    }
                }
                comparator.compare();
                String outFileStr = null;
                if (argsMap.get("-out") != null && argsMap.get("-out").get(0) != null) {
                    outFileStr = argsMap.get("-out").get(0);
                }
                this.handleOutput(comparator, outFileStr, new File(newFile).getParentFile());
                this.rc = 0;
            }
            catch (IOException e) {
                this.rc = 11;
                this.StdOut.add(String.format("Failed to compare: %s. Stack trace:\n*********************************\n%s", e.getMessage(), Arrays.toString(e.getStackTrace())));
            }
        }
    }

    private void handleOutput(CsvComparator comparator, String outFileName, File defaultDir) throws IOException {
        CsvChangeList changes = comparator.getChangeList();
        this.StdOut.add(String.format("Done comparing, (%d) changes found", changes.size()));
        if (changes.size() > 0) {
            File outFile = this.resolveToFile(outFileName, defaultDir);
            changes.writeToFile(new CsvWriter(outFile.toString()));
            this.StdOut.add(String.format("Changes written to %s", outFile.getPath()));
        }
    }

    private File resolveToFile(String outFile, File defaultDir) throws IOException {
        File toRet = null;
        toRet = outFile == null || outFile.isEmpty() ? File.createTempFile("CSV_COMP_", ".csv", defaultDir) : new File(outFile);
        return toRet;
    }

    @Override
    public int getRC() {
        return this.rc;
    }

    private String ListToString(List<String> strList) {
        StringBuilder toRet = new StringBuilder();
        if (strList != null) {
            for (String str : strList) {
                toRet.append(str).append('\n');
            }
        }
        return toRet.toString();
    }

    @Override
    public String getOutput() {
        return this.ListToString(this.StdOut);
    }

    @Override
    public String getValidationErrors() {
        return this.ListToString(this.validationMessages);
    }
}

