/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.gui;

import com.bmc.toolbox.compare.condition_compare.DependencyChanghHandler;
import com.bmc.toolbox.compare.condition_compare.entitites.Dependency;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;

public class DependencyGuiHandler
implements DependencyChanghHandler {
    private JTextArea textArea;
    private List<Dependency> onlyOnFirst;
    private List<Dependency> onlyOnSecond;

    public DependencyGuiHandler(JTextArea textArea) {
        this.textArea = textArea;
        this.onlyOnFirst = new ArrayList<Dependency>();
        this.onlyOnSecond = new ArrayList<Dependency>();
    }

    @Override
    public void addExistOnlyInFirstEvent(Dependency dependency) {
        this.onlyOnFirst.add(dependency);
    }

    @Override
    public void addExistOnlyInSecondEvent(Dependency dependency) {
        this.onlyOnSecond.add(dependency);
    }

    public void printResults() {
        if (!this.hasChanges()) {
            return;
        }
        this.appendSepartorToTextArea();
        this.textArea.append("Dependencies differences:\n");
        this.printFirstChanges();
        this.printSecondChanges();
        this.appendSepartorToTextArea();
    }

    private void printFirstChanges() {
        if (this.onlyOnFirst.size() == 0) {
            return;
        }
        this.textArea.append("Only in draft A:\n");
        for (Dependency dependency : this.onlyOnFirst) {
            this.textArea.append(dependency.toString() + "\n");
        }
    }

    private void printSecondChanges() {
        if (this.onlyOnSecond.size() == 0) {
            return;
        }
        this.textArea.append("Only in draft B:\n");
        for (Dependency dependency : this.onlyOnSecond) {
            this.textArea.append(dependency.toString() + "\n");
        }
    }

    public boolean hasChanges() {
        return this.onlyOnFirst.size() != 0 || this.onlyOnSecond.size() != 0;
    }

    private void appendSepartorToTextArea() {
        this.textArea.append("******************************************************************************************************************************\n");
    }
}

