/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.gui;

import com.bmc.toolbox.compare.condition_compare.gui.ComaperAction;
import com.bmc.toolbox.compare.condition_compare.gui.JTextFieldStreamUtils;
import com.bmc.toolbox.compare.xml_compare.DraftComparator;
import com.bmc.toolbox.compare.xml_compare.XMLChangesCsvWriter;
import com.bmc.toolbox.compare.xml_compare.XmlCompare;
import com.bmc.toolbox.compare.xml_compare.changes.XmlChange;
import com.bmc.toolbox.compare.xml_compare.xml_compare_tool.StatisticHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CompareAllToCsvAction
implements ComaperAction {
    private JTextArea textArea;
    private JTextField draftInputA;
    private JTextField draftInputB;
    private JTextField csvOutput;

    public CompareAllToCsvAction(JTextArea textArea, JTextField draftInputA, JTextField draftInputB, JTextField csvOutput) {
        this.textArea = textArea;
        this.draftInputA = draftInputA;
        this.draftInputB = draftInputB;
        this.csvOutput = csvOutput;
    }

    @Override
    public void compare() {
        this.textArea.setText("compare to csv...\n");
        try {
            InputStream draftA = JTextFieldStreamUtils.getStream(this.draftInputA);
            InputStream draftB = JTextFieldStreamUtils.getStream(this.draftInputB);
            DraftComparator comperator = new DraftComparator();
            comperator.compare(draftA, draftB);
            FileWriter writer = new FileWriter(this.csvOutput.getText());
            final StatisticHandler statisticHandler = new StatisticHandler();
            final XMLChangesCsvWriter changesWriter = new XMLChangesCsvWriter(writer);
            XmlCompare.ChangeHandelr t = new XmlCompare.ChangeHandelr(){

                @Override
                public void handleChange(XmlChange change) {
                    statisticHandler.handleChange(change);
                    changesWriter.handleChange(change);
                }
            };
            comperator.forEachChange(t);
            changesWriter.close();
            this.textArea.append("Results:\n" + statisticHandler.toString() + "\n");
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.textArea.setText(e.toString());
        }
    }
}

