/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderFactory;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.draftReader.SchedEntitesHandler;
import com.bmc.toolbox.compare.condition_compare.draftReader.SubEntityReader;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.SmartFolder;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfSmartFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfSmartPredicate;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class SmartFolderReader {
    private SchedEntitesHandler handlerUpper;
    private EntitesCreator entitesCreator;

    public SmartFolderReader(SchedEntitesHandler handlerUpper2) {
        this.handlerUpper = handlerUpper2;
        this.entitesCreator = new EntitesCreator();
    }

    public void readSmartFolder(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent smartEvent = eventReader.nextEvent();
        if (this.isStartOfSmartEvent(smartEvent)) {
            List<MyAttribute> newAttributes = ReaderUtils.getEventAttributes(smartEvent);
            String smartFolderName = this.getName(newAttributes);
            DraftPath smartFolderPath = new DraftPath(smartFolderName);
            SmartFolder smartTable = this.entitesCreator.createSmartFolder(smartEvent, smartFolderPath);
            this.handlerUpper.handleSmartFolder(smartTable);
            ReaderFactory factory = new ReaderFactory();
            List<DraftEntitiesReader> readers = factory.getReaders(smartTable);
            while (eventReader.hasNext()) {
                for (DraftEntitiesReader reader : readers) {
                    reader.read(eventReader);
                }
                XMLEvent event = eventReader.peek();
                SubEntityReader subEntityHandler = this.getSubEntityReader(smartFolderPath);
                if (subEntityHandler.isSubEntry(event)) {
                    subEntityHandler.readSubEntity(event, eventReader);
                }
                if (!this.isEndOfSmartEvent(event = eventReader.nextEvent())) continue;
                break;
            }
        }
    }

    protected SubEntityReader getSubEntityReader(DraftPath folderPath) {
        return new SubEntityReader(this.handlerUpper, folderPath);
    }

    private boolean isEndOfSmartEvent(XMLEvent event) {
        EndOfSmartFolderPredicate endOfSmartPredicate = new EndOfSmartFolderPredicate();
        return endOfSmartPredicate.test(event);
    }

    private boolean isStartOfSmartEvent(XMLEvent event) {
        StartOfSmartPredicate startOfSmartPredicate = new StartOfSmartPredicate();
        return startOfSmartPredicate.test(event);
    }

    private String getName(List<MyAttribute> myAttributes) {
        ValueGetter nameGetter = new ValueGetter("FOLDER_NAME");
        String smartFolderName = nameGetter.fromList(myAttributes);
        return smartFolderName;
    }
}

