/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderUtils;
import com.bmc.toolbox.compare.condition_compare.entitites.DoCond;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.On;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfElementPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfElementPredicate;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OnDoReader
implements DraftEntitiesReader {
    private OnDoHandler onDoHandler;

    public OnDoReader(OnDoHandler ondoAdder) {
        this.onDoHandler = ondoAdder;
    }

    @Override
    public void read(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent optionalOnEvent = eventReader.peek();
        if (this.isStartOfOnDoEvent(optionalOnEvent)) {
            XMLEvent optionalDoCondEvent;
            XMLEvent onEvent = eventReader.nextEvent();
            List<MyAttribute> onAttributes = ReaderUtils.getEventAttributes(onEvent);
            String onCode = this.getXmlTagValue(onAttributes, "CODE");
            while (eventReader.hasNext() && !this.isEndOfOnDoEvent(optionalDoCondEvent = eventReader.peek())) {
                if (this.isDoCondEvent(optionalDoCondEvent)) {
                    this.readDoCond(onCode, eventReader, this.onDoHandler);
                }
                eventReader.next();
            }
            this.readEndOfOnElement(eventReader);
        }
    }

    private void readDoCond(String onCode, XMLEventReader eventReader, OnDoHandler onDoHandler) throws XMLStreamException {
        XMLEvent doCondEvent = eventReader.nextEvent();
        List<MyAttribute> doCondAttributes = ReaderUtils.getEventAttributes(doCondEvent);
        String doCondName = this.getXmlTagValue(doCondAttributes, "NAME");
        String doCondOdate = this.getXmlTagValue(doCondAttributes, "ODATE");
        String doCondSign = this.getXmlTagValue(doCondAttributes, "SIGN");
        onDoHandler.addOnDo(new On(onCode), new DoCond(doCondName, doCondOdate, doCondSign));
        this.readEndOfDoCondElement(eventReader);
    }

    private boolean isDoCondEvent(XMLEvent doCondEvent) {
        String tagName = "DOCOND";
        StartOfElementPredicate startOfElementPredicate = new StartOfElementPredicate(tagName);
        return startOfElementPredicate.test(doCondEvent);
    }

    private void readEndOfOnElement(XMLEventReader eventReader) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.peek();
            if (this.isEndOfOnDoEvent(event)) {
                return;
            }
            eventReader.nextEvent();
        }
    }

    private void readEndOfDoCondElement(XMLEventReader eventReader) throws XMLStreamException {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.peek();
            if (this.isEndOfDoCondEvent(event)) {
                return;
            }
            eventReader.nextEvent();
        }
    }

    private boolean isEndOfOnDoEvent(XMLEvent event) {
        String tagName = "ON";
        EndOfElementPredicate endOfElementPredicate = new EndOfElementPredicate(tagName);
        return endOfElementPredicate.test(event);
    }

    private boolean isEndOfDoCondEvent(XMLEvent event) {
        String tagName = "DOCOND";
        EndOfElementPredicate endOfElementPredicate = new EndOfElementPredicate(tagName);
        return endOfElementPredicate.test(event);
    }

    private boolean isStartOfOnDoEvent(XMLEvent event) {
        String tagName = "ON";
        StartOfElementPredicate startOfElementPredicate = new StartOfElementPredicate(tagName);
        return startOfElementPredicate.test(event);
    }

    private String getXmlTagValue(List<MyAttribute> myAttributes, String tagName) {
        ValueGetter nameGetter = new ValueGetter(tagName);
        String value = nameGetter.fromList(myAttributes);
        return value;
    }

    public static interface OnDoHandler {
        public void addOnDo(On var1, DoCond var2);
    }
}

