/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare.draftReader;

import com.bmc.toolbox.compare.condition_compare.AttributeUtlis;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderFactory;
import com.bmc.toolbox.compare.condition_compare.draftReader.SchedEntitesHandler;
import com.bmc.toolbox.compare.condition_compare.entitites.Job;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfJobPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfJobPredicate;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class JobReader {
    private SchedEntitesHandler handler;
    private DraftPath parent;
    private EntitesCreator entitesCreator;

    public JobReader(SchedEntitesHandler handler2, DraftPath parent) {
        this.handler = handler2;
        this.parent = parent;
        this.entitesCreator = new EntitesCreator();
    }

    public void readJob(XMLEventReader eventReader) throws XMLStreamException {
        XMLEvent event = eventReader.peek();
        if (this.isStartOfJob(event)) {
            XMLEvent jobEvent = eventReader.nextEvent();
            StartElement startElement = jobEvent.asStartElement();
            Iterator<Attribute> attributes = startElement.getAttributes();
            List<MyAttribute> myAttributes = AttributeUtlis.convertAttributes(attributes);
            String jobName = this.getName(myAttributes);
            DraftPath jobPath = new DraftPath(jobName, this.parent);
            Job job = this.entitesCreator.createJob(jobEvent, jobPath);
            this.handler.handleJob(job);
            ReaderFactory factory = new ReaderFactory();
            List<DraftEntitiesReader> readers = factory.getReaders(job);
            while (eventReader.hasNext()) {
                for (DraftEntitiesReader reader : readers) {
                    reader.read(eventReader);
                }
                XMLEvent endEvent = eventReader.peek();
                if (this.isEndOfJobEvent(endEvent)) break;
                eventReader.nextEvent();
            }
        }
    }

    private boolean isStartOfJob(XMLEvent event) {
        StartOfJobPredicate startOfElementPredicate = new StartOfJobPredicate();
        return startOfElementPredicate.test(event);
    }

    private boolean isEndOfJobEvent(XMLEvent event) {
        EndOfJobPredicate endOfJobPredicate = new EndOfJobPredicate();
        return endOfJobPredicate.test(event);
    }

    public String getName(List<MyAttribute> myAttributes) {
        ValueGetter nameGetter = new ValueGetter("JOBNAME");
        String smartFolderName = nameGetter.fromList(myAttributes);
        if (smartFolderName == null || smartFolderName.isEmpty()) {
            nameGetter = new ValueGetter("MEMNAME");
            smartFolderName = nameGetter.fromList(myAttributes);
        }
        return smartFolderName;
    }
}

