/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare;

import com.bmc.toolbox.compare.condition_compare.DraftId;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class DraftPath
implements DraftId {
    private LinkedList<String> paths = new LinkedList();

    private DraftPath() {
    }

    public DraftPath(DraftPath parnetPath) {
        this();
        this.paths.addAll(parnetPath.paths);
    }

    public DraftPath(String name) {
        this();
        this.paths.add(name);
    }

    public DraftPath(String name, DraftPath parnetPath) {
        this(parnetPath);
        this.paths.add(name);
    }

    public void addSun(String name) {
        this.paths.add(name);
    }

    public String getParentOf(String name2) {
        int sunIndex = this.paths.indexOf(name2);
        String ret = "";
        if (sunIndex != -1) {
            ret = this.paths.get(sunIndex - 1);
        }
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DraftPath other = (DraftPath)obj;
        return !(this.paths == null ? other.paths != null : !this.paths.equals(other.paths));
    }

    public String toString() {
        Object toRet = "path = ";
        for (String path : this.paths) {
            toRet = (String)toRet + path;
            if (this.paths.indexOf(path) == this.paths.size() - 1) continue;
            toRet = (String)toRet + "\\";
        }
        return toRet;
    }

    public boolean hasParent() {
        return this.paths.size() > 1;
    }

    public LinkedList<String> getPaths() {
        return this.paths;
    }

    public String getPath() {
        Object toRet = "";
        for (String path : this.paths) {
            toRet = (String)toRet + path;
            if (this.paths.indexOf(path) == this.paths.size() - 1) continue;
            toRet = (String)toRet + "\\";
        }
        return toRet;
    }

    public int getDepth() {
        return this.paths.size();
    }

    public List<DraftPath> getListOfPredecessors() {
        ArrayList<DraftPath> listOfPredecessors = new ArrayList<DraftPath>();
        DraftPath draftParent = null;
        DraftPath draftPath = null;
        for (String path : this.paths) {
            draftPath = draftParent == null ? new DraftPath(path) : new DraftPath(path, draftParent);
            draftParent = draftPath;
            listOfPredecessors.add(draftPath);
        }
        if (draftPath != null) {
            listOfPredecessors.remove(listOfPredecessors.size() - 1);
        }
        return listOfPredecessors;
    }
}

