/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare;

import com.bmc.toolbox.compare.condition_compare.Condionable;
import com.bmc.toolbox.compare.condition_compare.DraftEntity;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.OnDoable;
import com.bmc.toolbox.compare.condition_compare.Pathable;
import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.entitites.Condition;
import com.bmc.toolbox.compare.condition_compare.entitites.DoCond;
import com.bmc.toolbox.compare.condition_compare.entitites.InCondition;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import com.bmc.toolbox.compare.condition_compare.entitites.On;
import com.bmc.toolbox.compare.condition_compare.entitites.OutCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class DraftEntityImp
implements DraftEntity,
Pathable,
Condionable,
OnDoable {
    protected List<MyAttribute> attributes;
    private DraftPath entityPath;
    private String entityName;
    private List<InCondition> inConditions;
    private List<OutCondition> outConditions;
    private Map<On, List<DoCond>> ondo;
    private Set<String> inConditionsNameGroup;
    private Set<String> outConditionsNameGroup;
    private Set<String> onDoConditionsNameGroup;
    protected List<String> rbc;

    public DraftEntityImp(List<MyAttribute> attributes, DraftPath entityPath, String entityName) {
        this.attributes = attributes;
        this.entityPath = entityPath;
        this.entityName = entityName;
        this.inConditions = new ArrayList<InCondition>();
        this.outConditions = new ArrayList<OutCondition>();
        this.ondo = new HashMap<On, List<DoCond>>();
        this.rbc = new ArrayList<String>();
        this.inConditionsNameGroup = new TreeSet<String>();
        this.outConditionsNameGroup = new TreeSet<String>();
        this.onDoConditionsNameGroup = new TreeSet<String>();
    }

    public Set<String> getInConditionGroupName() {
        return this.inConditionsNameGroup;
    }

    public Set<String> getOutConditionGroupName() {
        return this.outConditionsNameGroup;
    }

    public Set<String> getOnDoConditionGroupName() {
        return this.onDoConditionsNameGroup;
    }

    public String getName() {
        return this.entityName;
    }

    @Override
    public List<MyAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public DraftPath getPath() {
        return this.entityPath;
    }

    public String getAttribueValue(String attribute) {
        ValueGetter nameGetter = new ValueGetter(attribute);
        String smartFolderName = nameGetter.fromList(this.attributes);
        return smartFolderName;
    }

    @Override
    public void addInCondition(InCondition inCondition) {
        this.inConditions.add(inCondition);
        this.inConditionsNameGroup.add(inCondition.getName());
    }

    @Override
    public void addOutCondition(OutCondition outCondition) {
        this.outConditions.add(outCondition);
        this.outConditionsNameGroup.add(outCondition.getName());
    }

    @Override
    public void addOnDo(On on, DoCond doCond) {
        if (this.ondo.containsKey(on)) {
            this.ondo.get(on).add(doCond);
        } else {
            ArrayList<DoCond> addToMap = new ArrayList<DoCond>();
            addToMap.add(doCond);
            this.ondo.put(on, addToMap);
            this.addOnDoConditionsNames(addToMap);
        }
    }

    private void addOnDoConditionsNames(List<DoCond> onDoConditionList) {
        for (DoCond doCond : onDoConditionList) {
            this.onDoConditionsNameGroup.add(doCond.getName());
        }
    }

    public void addRbc(String rbcName) {
        this.rbc.add(rbcName);
    }

    public Set<String> getRbcs() {
        HashSet<String> ret = new HashSet<String>(this.rbc);
        return ret;
    }

    public Map<On, List<DoCond>> getOndo() {
        return this.ondo;
    }

    public List<InCondition> getInConditions() {
        return this.inConditions;
    }

    public List<OutCondition> getOutConditions() {
        return this.outConditions;
    }

    public List<Condition> getInConditionsAsCondition() {
        return new ArrayList<Condition>(this.inConditions);
    }

    public List<Condition> getOutConditionsAsCondition() {
        return new ArrayList<Condition>(this.outConditions);
    }

    public String toString() {
        return "DraftEntityImp [entityPath=" + String.valueOf(this.entityPath) + ", entityName=" + this.entityName + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entityPath == null ? 0 : this.entityPath.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DraftEntityImp other = (DraftEntityImp)obj;
        return !(this.entityPath == null ? other.entityPath != null : !this.entityPath.equals(other.entityPath));
    }
}

