/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.toolbox.compare.condition_compare;

import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.entitites.DoCond;
import com.bmc.toolbox.compare.condition_compare.entitites.InCondition;
import com.bmc.toolbox.compare.condition_compare.entitites.On;
import com.bmc.toolbox.compare.condition_compare.entitites.OutCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DependencyFinder {
    List<DraftEntityImp> entityList;
    Map<DraftPath, List<DraftEntityImp>> dependenciesMap;

    public DependencyFinder(List<DraftEntityImp> entityList) {
        this.entityList = entityList;
        this.dependenciesMap = new HashMap<DraftPath, List<DraftEntityImp>>();
        this.generateDependencies();
    }

    public boolean containes(DraftEntityImp entity) {
        return this.dependenciesMap.containsKey(entity.getPath());
    }

    private void generateDependencies() {
        Map<String, List<DraftEntityImp>> inconditionToEntites = this.createInConditionMap();
        Map<String, List<DraftEntityImp>> outconditionToEntites = this.createOutConditionMap();
        for (String incondintion : inconditionToEntites.keySet()) {
            if (!outconditionToEntites.containsKey(incondintion)) continue;
            List<DraftEntityImp> jobsWithIn = inconditionToEntites.get(incondintion);
            List<DraftEntityImp> jobsWithOut = outconditionToEntites.get(incondintion);
            for (DraftEntityImp jobWithOut : jobsWithOut) {
                for (DraftEntityImp jobWithIn : jobsWithIn) {
                    DraftPath jobWithOutPath = jobWithOut.getPath();
                    if (!this.dependenciesMap.containsKey(jobWithOutPath)) {
                        ArrayList addToMap = new ArrayList();
                        this.dependenciesMap.put(jobWithOutPath, addToMap);
                    }
                    this.dependenciesMap.get(jobWithOutPath).add(jobWithIn);
                }
            }
        }
    }

    public List<DraftEntityImp> getEntityDependencies(DraftPath conditionSenderPath) {
        ArrayList<DraftEntityImp> ret = new ArrayList<DraftEntityImp>();
        if (this.dependenciesMap.containsKey(conditionSenderPath)) {
            List<DraftEntityImp> condtionGetters = this.dependenciesMap.get(conditionSenderPath);
            ret.addAll(condtionGetters);
        }
        return ret;
    }

    private Map<String, List<DraftEntityImp>> createOutConditionMap() {
        HashMap<String, List<DraftEntityImp>> outConditionMap = new HashMap<String, List<DraftEntityImp>>();
        for (DraftEntityImp draftEntityImp : this.entityList) {
            List<OutCondition> outConditionsList = draftEntityImp.getOutConditions();
            for (OutCondition outCondition : outConditionsList) {
                if (outConditionMap.containsKey(outCondition.getName())) {
                    ((List)outConditionMap.get(outCondition.getName())).add(draftEntityImp);
                    continue;
                }
                ArrayList<DraftEntityImp> newList = new ArrayList<DraftEntityImp>();
                newList.add(draftEntityImp);
                outConditionMap.put(outCondition.getName(), newList);
            }
            Map<On, List<DoCond>> ondo = draftEntityImp.getOndo();
            for (On on : ondo.keySet()) {
                List<DoCond> doConds = ondo.get(on);
                for (DoCond doCond : doConds) {
                    if (outConditionMap.containsKey(doCond.getName())) {
                        ((List)outConditionMap.get(doCond.getName())).add(draftEntityImp);
                        continue;
                    }
                    ArrayList<DraftEntityImp> newList = new ArrayList<DraftEntityImp>();
                    newList.add(draftEntityImp);
                    outConditionMap.put(doCond.getName(), newList);
                }
            }
        }
        return outConditionMap;
    }

    private Map<String, List<DraftEntityImp>> createInConditionMap() {
        HashMap<String, List<DraftEntityImp>> inConditionMap = new HashMap<String, List<DraftEntityImp>>();
        for (DraftEntityImp draftEntityImp : this.entityList) {
            List<InCondition> inConditionsList = draftEntityImp.getInConditions();
            for (InCondition inCondition : inConditionsList) {
                if (inConditionMap.containsKey(inCondition.getName())) {
                    ((List)inConditionMap.get(inCondition.getName())).add(draftEntityImp);
                    continue;
                }
                ArrayList<DraftEntityImp> newList = new ArrayList<DraftEntityImp>();
                newList.add(draftEntityImp);
                inConditionMap.put(inCondition.getName(), newList);
            }
        }
        return inConditionMap;
    }

    public String toString() {
        return "DependencyFinder [dependenciesMap=" + String.valueOf(this.dependenciesMap) + "]";
    }
}

