/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.os;

import com.bmc.ctmconvert.base.Base;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BasePasswordField;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DataImportVendor;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.bmcdiscovery.DiscoveryIntegrationException;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.discovery.DiscoveryJob;
import com.bmc.ctmconvert.discovery.ManualFilesDiscovery;
import com.bmc.ctmconvert.os.AutomaticCollectionHandler;
import com.bmc.ctmconvert.os.OsDataImportMethodGetter;
import com.bmc.ctmconvert.os.OsGlobals;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public abstract class DataImportOS
extends DataImportVendor
implements ValidityListener,
ActionListener {
    protected ImportPanels importPanels = ImportPanels.DEFAULT;
    protected BaseSection section;
    protected BaseTextField discoveryMainScriptPath;
    protected ActionListener manualFileListener;
    protected ManualFilesDiscovery manualFilesDiscovery;
    private BaseRadioButton automaticCollection;
    private BaseComboBox serverPlatform;
    private BaseField serverPlatformField;
    private BaseField scriptLocationField;
    private BaseRadioButton defaultLocation;
    private BaseButtonGroup dataCollectionGroup;
    private BaseField defaultLocationField;
    private BaseRadioButton customLocation;
    private BaseField customLocationField;
    private BaseRadioButton manualCollection;
    protected boolean success;
    protected boolean eligibleForNext;
    private AutomaticCollectionHandler automaticCollectionHandler;
    private BaseTextField discoveryHostName;
    private BaseTextField discoveryUserName;
    private BasePasswordField discoveryPassword;
    private BaseRadioButton discoveryCollection;

    public ImportPanels getImportPanels() {
        return this.importPanels;
    }

    public void setImportPanels(ImportPanels importPanels) {
        this.importPanels = importPanels;
    }

    public BaseTextField getDiscoveryMainScriptPath() {
        return this.discoveryMainScriptPath;
    }

    public ManualFilesDiscovery getManualFilesDiscovery() {
        return this.manualFilesDiscovery;
    }

    public void setManualFilesDiscovery(ManualFilesDiscovery manualFilesDiscovery) {
        this.manualFilesDiscovery = manualFilesDiscovery;
    }

    public BaseComboBox getServerPlatform() {
        return this.serverPlatform;
    }

    public BaseRadioButton getDefaultLocation() {
        return this.defaultLocation;
    }

    public BaseRadioButton getCustomLocation() {
        return this.customLocation;
    }

    public void setEligibleForNext(boolean eligibleForNext) {
        this.eligibleForNext = eligibleForNext;
    }

    public DataImportOS() {
        String strImportDataAutomatically = String.format(TextManager.instance().get("CRON_MS_DATA_IMPORT_AUTOMATIC_DESCRIPTION"), "\n", "\n", "\n", "\n", "\n", "\n", "\n", "\n");
        String strImportDataManually = this.getManualDataImportInstructions();
        this.automaticCollectionHandler = new AutomaticCollectionHandler(this);
        this.manualFilesDiscovery = new ManualFilesDiscovery();
        this.importPanel = new BaseContentPanel(new BaseTitlePanel(), new BaseFooterPanel(""));
        this.section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA")){

            @Override
            public boolean isValid() {
                if (DataImportOS.this.automaticCollection.isSelected()) {
                    return DataImportOS.this.serverPlatform.isValid() && (DataImportOS.this.defaultLocation.isSelected() || DataImportOS.this.discoveryMainScriptPath.isValid());
                }
                return true;
            }
        };
        this.dataCollectionGroup = new BaseButtonGroup();
        this.discoveryCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_FROM_DISCOVERY"));
        this.discoveryCollection.addActionListener(this);
        this.discoveryCollection.setSelected(true);
        String strDiscovery = String.format(TextManager.instance().get("CRON_MS_DISCOVERY_DESCRIPTION"), "\n", "\n");
        BaseField field = new BaseField((BaseComponent)this.discoveryCollection, null, strDiscovery);
        this.section.addField(field);
        this.dataCollectionGroup.add(this.discoveryCollection);
        Map<BaseRadioButton, BaseField> customComponentsList = this.getCustomComponents();
        for (BaseRadioButton key : customComponentsList.keySet()) {
            BaseField baseField = customComponentsList.get(key);
            this.section.addField(baseField);
            this.dataCollectionGroup.add(key);
        }
        this.automaticCollection = new BaseRadioButton(TextManager.instance().get("OS_AUTOMATIC_IMPORT_DATA"));
        this.automaticCollection.addActionListener(this);
        this.dataCollectionGroup.add(this.automaticCollection);
        this.section.addField(new BaseField((BaseComponent)this.automaticCollection, null, strImportDataAutomatically));
        this.serverPlatform = new BaseComboBox(new String[]{TextManager.instance().get("DATA_IMPORT_PLATFORM_OPTIONS_WINDOWS"), TextManager.instance().get("DATA_IMPORT_PLATFORM_OPTIONS_UNIX")}, TextManager.instance().get("DATA_IMPORT_PLATFORM_OPTIONS_DEFAULT"));
        this.serverPlatform.addActionListener(this);
        this.serverPlatformField = new BaseField(this.serverPlatform, TextManager.instance().get("DATA_IMPORT_PLATFORM_TITLE"), true, 17, TextManager.instance().get("CRON_MS_SERVER_PLATFORM_DESCRIPTION"));
        this.section.addField(this.serverPlatformField);
        BaseButtonGroup scriptLocationGroup = new BaseButtonGroup();
        this.scriptLocationField = new BaseField(null, TextManager.instance().get("DATA_IMPORT_SCRIPT_PATH"), true, 17);
        this.scriptLocationField.setValid(true);
        this.section.addField(this.scriptLocationField);
        this.defaultLocation = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_DEFAULT_LOCATION"));
        this.defaultLocation.addActionListener(this);
        JLabel defaultLocationLabel = new JLabel(TextManager.instance().get("DATA_IMPORT_DEFAULT_LOCATION_LABEL"));
        this.defaultLocation.setExtraComponent(defaultLocationLabel);
        this.defaultLocation.setSelected(true);
        scriptLocationGroup.add(this.defaultLocation);
        this.defaultLocationField = new BaseField((BaseComponent)this.defaultLocation, 17, TextManager.instance().get("CRON_MS_DEFAULT_LOCATION_DESCRIPTION"));
        this.defaultLocationField.fillFieldSize(true);
        this.section.addField(this.defaultLocationField);
        this.customLocation = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_CUSTOM_LOCATION"));
        this.customLocation.addActionListener(this);
        this.discoveryMainScriptPath = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.discoveryMainScriptPath.addValidityListener(this.section);
        this.discoveryMainScriptPath.disableValidityLook(true);
        this.customLocation.setExtraComponent(this.discoveryMainScriptPath.getComponent());
        scriptLocationGroup.add(this.customLocation);
        this.customLocationField = new BaseField((BaseComponent)this.customLocation, 17, TextManager.instance().get("CRON_MS_CUSTOM_LOCATION_DESCRIPTION"));
        this.customLocationField.fillFieldSize(true);
        this.section.addField(this.customLocationField);
        this.manualCollection = new BaseRadioButton(TextManager.instance().get("DATA_IMPORT_MANUAL"));
        this.manualCollection.addActionListener(this);
        this.dataCollectionGroup.add(this.manualCollection);
        this.section.addField(new BaseField((BaseComponent)this.manualCollection, null, strImportDataManually));
        this.setAutomaticEnabled(true);
        this.importPanel.addSection(this.section);
        this.importPanel.buildContentPanel();
        File tempDataDir = new File(Globs.TEMP_IMPORT_DIR);
        if (tempDataDir.exists()) {
            GlobalFunctions.deleteDir(tempDataDir);
        }
        tempDataDir.mkdirs();
    }

    protected abstract String getManualDataImportInstructions();

    protected abstract Map<BaseRadioButton, BaseField> getCustomComponents();

    protected abstract FlowGlobals.COMPLETION_MODE getHandleDiscoveryCollection(String var1, String var2, String var3, String var4) throws DiscoveryIntegrationException;

    @Override
    public DataImportVendor.ImportPosition getImportPosition() {
        switch (this.importPanels.ordinal()) {
            case 2: 
            case 4: {
                return DataImportVendor.ImportPosition.START;
            }
            case 0: {
                return DataImportVendor.ImportPosition.MIDDLE;
            }
        }
        return DataImportVendor.ImportPosition.END;
    }

    @Override
    public Component getDefaultFocusedComponent() {
        switch (this.importPanels.ordinal()) {
            case 2: {
                return this.discoveryCollection.getComponent();
            }
        }
        return null;
    }

    @Override
    public FlowGlobals.COMPLETION_MODE performDataImport(String destinationFolderPath, BaseProgressBar progressBar) {
        FlowGlobals.COMPLETION_MODE success = FlowGlobals.COMPLETION_MODE.SUCCESS;
        if (progressBar != null) {
            String osVendorName = Params.instance().getVendorName();
            OsDataImportMethodGetter osDataImportMethodGetter = new OsDataImportMethodGetter();
            String title = osDataImportMethodGetter.getDataImportProgressBarTitle(osVendorName);
            progressBar.setLabel(title);
        }
        success = this.dataCollectionGroup.getData().equals(TextManager.instance().get("DATA_IMPORT_FROM_DISCOVERY")) ? this.importDataFromDiscovery(destinationFolderPath) : this.manualFilesDiscovery.copyFilesToDestinationFolder(destinationFolderPath);
        File tmpImpDir = new File(Globs.TEMP_IMPORT_DIR);
        if (tmpImpDir.isDirectory()) {
            File[] tmpFiles = tmpImpDir.listFiles();
            for (int i = 0; i < tmpFiles.length; ++i) {
                File targetPath = new File(ConversionEntitiesService.getCurrentProjectDataDirectory() + tmpFiles[i].getName());
                boolean tmpSuccess = tmpFiles[i].renameTo(targetPath);
                if (!tmpSuccess) {
                    ProcessAlertsManager.instance().addMessage(String.format("Failed to move from [%s] to [%s]", tmpFiles[i], targetPath));
                }
                success = success == FlowGlobals.COMPLETION_MODE.SUCCESS && tmpSuccess ? FlowGlobals.COMPLETION_MODE.SUCCESS : FlowGlobals.COMPLETION_MODE.FAILURE;
            }
        }
        return success;
    }

    private FlowGlobals.COMPLETION_MODE importDataFromDiscovery(String destinationFolderPath) {
        String hostname = this.discoveryHostName.getData().toString();
        String username = this.discoveryUserName.getData().toString();
        String password = this.discoveryPassword.getData().toString();
        try {
            return this.getHandleDiscoveryCollection(destinationFolderPath, hostname, username, password);
        }
        catch (DiscoveryIntegrationException e) {
            ProcessAlertsManager alertManger = ProcessAlertsManager.instance();
            alertManger.addMessage(e.getMessage());
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
        catch (Throwable e) {
            ExceptionHandler.writeToExceptionFile(new Exception(e));
            ProcessAlertsManager alertManger = ProcessAlertsManager.instance();
            alertManger.addMessage("Failed to retrieve data from the BMC Discovery Server. Please contact BMC Support for assistance.");
            return FlowGlobals.COMPLETION_MODE.FAILURE;
        }
    }

    @Override
    public BaseContentPanel getNextPanel() {
        Params properties = Params.instance();
        String sourceName = properties.getProjectProperties().getProperty("NAME");
        LinkedHashMap<String, String> toAdd = new LinkedHashMap<String, String>();
        switch (this.importPanels.ordinal()) {
            case 2: {
                if (this.automaticCollection.isSelected()) {
                    properties.setDataImportMethod(OsGlobals.DataImportMethod.Automatic.getName());
                    BaseContentPanel agentList = this.automaticCollectionHandler.handleAutomaticCollection(sourceName, toAdd);
                    return agentList;
                }
                if (this.discoveryCollection.isSelected()) {
                    properties.setDataImportMethod(OsGlobals.DataImportMethod.FromDiscovery.getName());
                    return this.handleDiscovery(sourceName, toAdd);
                }
                properties.setDataImportMethod(OsGlobals.DataImportMethod.Manually.getName());
                return this.handleManualCollection(sourceName, toAdd);
            }
            case 0: {
                return this.automaticCollectionHandler.handleDiscoveryAgentList();
            }
            case 5: {
                return null;
            }
            case 1: 
            case 3: {
                return null;
            }
        }
        this.importPanels = ImportPanels.DATA_IMPORT;
        if (DiscoveryJob.isAgentExist()) {
            if (!SettingsTable.instance().getProperty(SettingsStringKeys.OS_DATA_COLLECTION_PLATFORM).isEmpty()) {
                this.serverPlatform.setSelectedItem(SettingsTable.instance().getProperty(SettingsStringKeys.OS_DATA_COLLECTION_PLATFORM));
            }
            if (!SettingsTable.instance().getProperty(SettingsStringKeys.OS_DATA_COLLECTION_SCRIPT_LOCATION).isEmpty()) {
                this.customLocation.doClick();
                this.discoveryMainScriptPath.setText(SettingsTable.instance().getProperty(SettingsStringKeys.OS_DATA_COLLECTION_SCRIPT_LOCATION));
            }
        } else {
            this.automaticCollection.setEnabled(false);
            this.automaticCollection.getComponent().setToolTipText(TextManager.instance().get("OS_AUTOMATIC_NO_AGENT_TOOLTIP"));
        }
        this.discoveryCollection.doClick();
        this.eligibleForNext = true;
        return this.importPanel;
    }

    private BaseContentPanel handleManualCollection(String sourceName, LinkedHashMap<String, String> toAdd) {
        this.importPanels = ImportPanels.MANUAL_DATA_IMPORT;
        this.eligibleForNext = true;
        this.manualFilesDiscovery = new ManualFilesDiscovery(true);
        this.manualFilesDiscovery.addValidityListener(this);
        toAdd.put("NAME", sourceName);
        try {
            GlobalFunctions.map2DataSourcePropertiesFile(toAdd, ConversionEntitiesService.getProjectDirectory(sourceName), true);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        this.manualFilesDiscovery.setValid(this.manualFilesDiscovery.isValid());
        return this.manualFilesDiscovery.getContentPanel();
    }

    private BaseContentPanel handleDiscovery(String sourceName, LinkedHashMap<String, String> toAdd) {
        this.importPanels = ImportPanels.IMPORT_FROM_DISCOVERY;
        this.eligibleForNext = true;
        return this.initializeDiscoveryPanel(sourceName, toAdd);
    }

    private BaseContentPanel initializeDiscoveryPanel(String sourceName, LinkedHashMap<String, String> toAdd) {
        BaseContentPanel discoveryPanel = new BaseContentPanel(new BaseTitlePanel(), new BaseFooterPanel(""));
        this.discoveryHostName = new BaseTextField(null, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.discoveryUserName = new BaseTextField(null, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        this.discoveryPassword = new BasePasswordField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
        String discoveryDescription = String.format(TextManager.instance().get("OS_DISCOVERY_DESCRIPTION"), "\n", "\n", "\n", "\n", "\n");
        final BaseField hostNameField = new BaseField(this.discoveryHostName, TextManager.instance().get("DATA_IMPORT_OS_DISCOVERY_LOGIN_FIELD_HOST"), true, 17, discoveryDescription);
        final BaseField userNameField = new BaseField(this.discoveryUserName, TextManager.instance().get("DATA_IMPORT_OS_DISCOVERY_LOGIN_FIELD_USERNAME"), true, 17, discoveryDescription);
        final BaseField passwordField = new BaseField(this.discoveryPassword, TextManager.instance().get("DATA_IMPORT_OS_DISCOVERY_LOGIN_FIELD_PASSWORD"), true, 17, discoveryDescription);
        BaseSection discoverySection = new BaseSection(this, TextManager.instance().get("OS_DISCOVERY_SECTION_IMPORT_DATA")){

            @Override
            public boolean isValid() {
                return hostNameField.isValid() && userNameField.isValid() && passwordField.isValid();
            }
        };
        discoverySection.addField(hostNameField);
        discoverySection.addField(userNameField);
        discoverySection.addField(passwordField);
        discoveryPanel.addSection(discoverySection);
        toAdd.put("NAME", sourceName);
        try {
            GlobalFunctions.map2DataSourcePropertiesFile(toAdd, ConversionEntitiesService.getProjectDirectory(sourceName), true);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        discoveryPanel.addValidityListener(this);
        discoveryPanel.buildContentPanel();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DataImportOS.this.discoveryHostName.setFocus();
            }
        });
        return discoveryPanel;
    }

    @Override
    public BaseContentPanel getPrevPanel() {
        switch (this.importPanels.ordinal()) {
            case 1: {
                return this.automaticCollectionHandler.handleDiscoveryResultList();
            }
            case 0: 
            case 3: {
                if (this.manualFilesDiscovery == null) break;
                this.manualFilesDiscovery.close();
                this.manualFilesDiscovery = null;
            }
        }
        this.importPanels = ImportPanels.DATA_IMPORT;
        return this.importPanel;
    }

    @Override
    public boolean updateData() {
        File tempDataDir = new File(Globs.TEMP_IMPORT_DIR);
        if (tempDataDir.exists()) {
            GlobalFunctions.deleteDir(tempDataDir);
        }
        tempDataDir.mkdirs();
        if (this.importPanels.equals((Object)ImportPanels.DISCOVERY_RESULT_LIST) || this.importPanels.equals((Object)ImportPanels.MANUAL_DATA_IMPORT)) {
            this.importPanels = ImportPanels.MANUAL_DATA_IMPORT;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForChanges() {
        return this.importPanels.equals((Object)ImportPanels.DATA_IMPORT);
    }

    @Override
    public String getHelpTitle() {
        return "";
    }

    @Override
    public String getFieldsData() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.automaticCollection.isSelected()) {
            stringBuilder.append(this.serverPlatform.getComponent().getName() + "=" + this.serverPlatform.getSelectedItem().toString() + "\n");
            if (this.customLocation.isSelected()) {
                stringBuilder.append(this.discoveryMainScriptPath.getComponent().getName() + "=" + this.discoveryMainScriptPath.getText() + "\n");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void cleanPanels() {
        this.manualFilesDiscovery = null;
        this.automaticCollectionHandler.setResultList(null);
    }

    @Override
    public boolean isComplexPanel() {
        return true;
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        switch (this.importPanels.ordinal()) {
            case 0: {
                Base agentList = this.automaticCollectionHandler.getAgentList();
                agentList.setValid((!actionCommand.equals("onlyManual") ? e.getValue() : agentList.isValid()) || this.manualFilesDiscovery.isValid());
                break;
            }
            case 1: {
                BaseContentPanel resultList = this.automaticCollectionHandler.getResultList();
                resultList.setValid((!actionCommand.equals("onlyManual") ? e.getValue() : resultList.isValid()) || this.manualFilesDiscovery.isValid());
                break;
            }
            case 3: {
                this.manualFilesDiscovery.getContentPanel().setValid(e.getValue());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.section.fireValidityEvent(this.section.isValid());
        this.setAutomaticEnabled(this.automaticCollection.isSelected());
    }

    @Override
    public boolean eligibleForNext() {
        return this.eligibleForNext;
    }

    public boolean isEligibleForNext() {
        return this.eligibleForNext;
    }

    private void setAutomaticEnabled(boolean b) {
        this.serverPlatformField.setEnabled(b);
        this.scriptLocationField.setEnabled(b);
        this.defaultLocationField.setEnabled(b);
        this.defaultLocation.getExtraComponent().setEnabled(b && this.defaultLocation.isSelected());
        this.customLocationField.setEnabled(b);
        this.customLocation.getExtraComponent().setEnabled(b && this.customLocation.isSelected());
        this.customLocation.getExtraComponent().setBackground(b && this.customLocation.isSelected() ? FlowGlobals.fieldDefaultBackground : FlowGlobals.fieldReadOnlyBackground);
    }

    public static enum ImportPanels {
        DISCOVERY_AGENTS_LIST,
        DISCOVERY_RESULT_LIST,
        DATA_IMPORT,
        MANUAL_DATA_IMPORT,
        DEFAULT,
        IMPORT_FROM_DISCOVERY;

    }
}

