/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.os;

import com.bmc.ctmconvert.base.Base;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.discovery.DiscoveryResults;
import com.bmc.ctmconvert.discovery.DiscoverySubmitter;
import com.bmc.ctmconvert.discovery.ManualFilesDiscovery;
import com.bmc.ctmconvert.discovery.PrereqTester;
import com.bmc.ctmconvert.os.DataImportOS;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;

public class AutomaticCollectionHandler {
    private String popupMessageFormat = Params.instance().getGUIVersion().equals("7") ? "DATA_IMPORT_AUTOMATIC_CONFIRM_JOBS_SUMITION_POPUP_FORMAT_7" : "DATA_IMPORT_AUTOMATIC_CONFIRM_JOBS_SUMITION_POPUP_FORMAT_8";
    private ManualFilesDiscovery manualFilesDiscovery;
    private DataImportOS dataImportOS;
    private DiscoverySubmitter discoverySubmitter;
    private BaseContentPanel agentList;
    private DiscoveryResults agentListResults;
    private DiscoveryResults dataFilesResults;
    private ActionListener manualFileListener;
    private BaseContentPanel resultList;

    public AutomaticCollectionHandler(DataImportOS dataImportOS) {
        this.dataImportOS = dataImportOS;
        this.manualFilesDiscovery = dataImportOS.getManualFilesDiscovery();
        this.manualFileListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutomaticCollectionHandler.this.manualFilesDiscovery.viewManualFilesDiscoveryEditor();
            }
        };
    }

    public BaseContentPanel handleAutomaticCollection(String sourceName, Map<String, String> toAdd) {
        if (!BaseMessageDialog.showConfirmDialog(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_CONFIRM_POPUP_TITLE"), String.format(TextManager.instance().get(this.popupMessageFormat), "3", "s", "\n", "These jobs", "\n\n"))) {
            this.dataImportOS.setEligibleForNext(false);
            return null;
        }
        this.dataImportOS.setEligibleForNext(true);
        if (this.manualFilesDiscovery == null || this.manualFilesDiscovery.isEmbedded()) {
            this.manualFilesDiscovery = new ManualFilesDiscovery();
            this.manualFilesDiscovery.setCommand("onlyManual");
            this.manualFilesDiscovery.addValidityListener(this.dataImportOS);
        }
        String scriptPath = this.dataImportOS.getDefaultLocation().isSelected() ? "" : this.dataImportOS.getDiscoveryMainScriptPath().getText().trim();
        final BaseProgressBar snakeBar = new BaseProgressBar(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_PREREQ_TESTER_TITLE"));
        snakeBar.setSnakeLook(true);
        snakeBar.setLabel(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_PREREQ_TESTER_TEXT"));
        final PrereqTester prereqTester = new PrereqTester(this.dataImportOS.getServerPlatform().getSelectedItem().toString().equals(TextManager.instance().get("DATA_IMPORT_PLATFORM_OPTIONS_UNIX")), scriptPath);
        ValidityListener prereqTesterValid = new ValidityListener(){

            @Override
            public void validityActionPerformed(ConversionEvent e) {
                if (!prereqTester.getError().isEmpty()) {
                    AutomaticCollectionHandler.this.dataImportOS.setEligibleForNext(false);
                    snakeBar.dispose();
                    BaseMessageDialog.showMessageDialog(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_PREREQ_TESTER_TITLE"), TextManager.instance().get("DATA_IMPORT_AUTOMATIC_PREREQ_TESTER_FAILURE_TEXT"), BaseMessageDialog.TYPE.ERROR_MESSAGE, prereqTester.getError());
                } else {
                    AutomaticCollectionHandler.this.dataImportOS.setEligibleForNext(true);
                    snakeBar.dispose();
                }
            }
        };
        prereqTester.addValidityListener(prereqTesterValid);
        Thread test = new Thread(prereqTester);
        test.start();
        snakeBar.setVisible(true);
        if (snakeBar.isCancelled() || !prereqTester.getError().isEmpty()) {
            if (snakeBar.isCancelled()) {
                this.dataImportOS.setEligibleForNext(false);
                prereqTester.removeValidityListener(prereqTesterValid);
            }
            return new BaseContentPanel();
        }
        SettingsTable.instance().setProperty(SettingsStringKeys.OS_DATA_COLLECTION_PLATFORM, this.dataImportOS.getServerPlatform().getSelectedItem().toString());
        SettingsTable.instance().setProperty(SettingsStringKeys.OS_DATA_COLLECTION_SCRIPT_LOCATION, this.dataImportOS.getCustomLocation().isSelected() ? scriptPath : "");
        this.discoverySubmitter = new DiscoverySubmitter(scriptPath, this.dataImportOS.getServerPlatform().getSelectedItem().toString());
        this.dataImportOS.setImportPanels(DataImportOS.ImportPanels.DISCOVERY_AGENTS_LIST);
        toAdd.put("LAST_USED_PATH", this.dataImportOS.getDefaultLocation().isSelected() ? "" : this.dataImportOS.getDiscoveryMainScriptPath().getText());
        toAdd.put("LAST_USED_PALTFORM", this.dataImportOS.getServerPlatform().getSelectedItem().toString());
        toAdd.put("NAME", sourceName);
        try {
            GlobalFunctions.map2DataSourcePropertiesFile(toAdd, ConversionEntitiesService.getProjectDirectory(sourceName), true);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return this.generateAgentsList();
    }

    public BaseContentPanel generateAgentsList() {
        if (this.agentList == null || this.agentListResults == null) {
            this.agentListResults = this.discoverySubmitter.submitAgentListJob();
            ArrayList<Component> componentList = new ArrayList<Component>();
            componentList.add(ButtonFactory.createButton(ButtonFactory.ButtonType.MANUAL_DISCOVERY, this.manualFileListener));
            this.agentList = new BaseContentPanel(new BaseTitlePanel(), new BaseFooterPanel(componentList));
            this.agentListResults.addValidityListener(this.dataImportOS);
            this.agentList.setContentPanel(this.agentListResults.getComponent());
            this.agentListResults.addNavegationListener(new NavegationListener(){

                @Override
                public void navegationActionPerformed(ConversionEvent e) {
                    if (BaseMessageDialog.showConfirmDialog(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_CONFIRM_POPUP_TITLE"), String.format(TextManager.instance().get(AutomaticCollectionHandler.this.popupMessageFormat), "1", "", "\n", TextManager.instance().get("DATA_IMPORT_OS_DIALOG_MSG_THIS_JOB"), "\n\n"))) {
                        AutomaticCollectionHandler.this.generateAgentsList();
                    }
                }
            });
        } else {
            this.discoverySubmitter.submitAgentListJob(this.agentListResults);
        }
        this.agentList.setValid(false);
        return this.agentList;
    }

    public Base getAgentList() {
        return this.agentList;
    }

    public DiscoveryResults getAgentListResults() {
        return this.agentListResults;
    }

    public BaseContentPanel handleDiscoveryAgentList() {
        int cnt = 0;
        for (int row = 0; row < this.agentListResults.getModel(0).getRowCount(); ++row) {
            if (!((Boolean)this.agentListResults.getModel(0).getValueAt(row, 1)).booleanValue()) continue;
            ++cnt;
        }
        if (cnt > 0 && !BaseMessageDialog.showConfirmDialog(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_CONFIRM_POPUP_TITLE"), String.format(TextManager.instance().get(this.popupMessageFormat), cnt, cnt > 1 ? "s" : "", "\n", cnt > 1 ? TextManager.instance().get("DATA_IMPORT_OS_DIALOG_MSG_THESE_JOBS") : TextManager.instance().get("DATA_IMPORT_OS_DIALOG_MSG_THIS_JOB"), "\n\n"))) {
            this.dataImportOS.setEligibleForNext(false);
            return null;
        }
        this.dataImportOS.setEligibleForNext(true);
        this.dataImportOS.setImportPanels(DataImportOS.ImportPanels.DISCOVERY_RESULT_LIST);
        return this.generateResultList();
    }

    private BaseContentPanel generateResultList() {
        if (this.resultList == null || this.dataFilesResults == null) {
            this.dataFilesResults = this.discoverySubmitter.submitRetrieveDataJob((BaseTableModel)this.agentListResults.getModel(0));
            ArrayList<Component> componentList = new ArrayList<Component>();
            componentList.add(ButtonFactory.createButton(ButtonFactory.ButtonType.MANUAL_DISCOVERY, this.manualFileListener));
            ArrayList<Component> fromEndComponentList = new ArrayList<Component>();
            fromEndComponentList.add(ButtonFactory.createButton(ButtonFactory.ButtonType.STOP_DISCOVERY, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AutomaticCollectionHandler.this.discoverySubmitter.stopMonitoring();
                }
            }));
            this.resultList = new BaseContentPanel(new BaseTitlePanel(), new BaseFooterPanel(null, componentList, fromEndComponentList));
            this.dataFilesResults.addValidityListener(this.dataImportOS);
            this.resultList.setContentPanel(this.dataFilesResults.getComponent());
        } else {
            this.discoverySubmitter.submitRetrieveDataJob((BaseTableModel)this.agentListResults.getModel(0), this.dataFilesResults);
        }
        this.resultList.setValid(this.dataFilesResults.isValid());
        return this.resultList;
    }

    public BaseContentPanel handleDiscoveryResultList() {
        if (!BaseMessageDialog.showConfirmDialog(TextManager.instance().get("DATA_IMPORT_AUTOMATIC_CONFIRM_POPUP_TITLE"), String.format(TextManager.instance().get(this.popupMessageFormat), "1", "", "\n", TextManager.instance().get("DATA_IMPORT_OS_DIALOG_MSG_THIS_JOB"), "\n\n"))) {
            this.dataImportOS.setImportPanels(DataImportOS.ImportPanels.DISCOVERY_RESULT_LIST);
            return this.resultList;
        }
        this.dataImportOS.setImportPanels(DataImportOS.ImportPanels.DISCOVERY_AGENTS_LIST);
        return this.generateAgentsList();
    }

    public BaseContentPanel getResultList() {
        return this.resultList;
    }

    public void setResultList(BaseContentPanel resultList) {
        this.resultList = resultList;
    }
}

