/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.base.Base;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.discovery.DiscoveryJob;
import com.bmc.ctmconvert.discovery.DiscoveryMonitor;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrereqTester
extends Base
implements Runnable {
    private boolean success;
    private String lastError;
    private boolean isUnixServer;
    private Boolean isV8 = null;
    private String scriptLocation;

    public PrereqTester(boolean isUnixServer, String testPath) {
        this.isUnixServer = isUnixServer;
        this.scriptLocation = testPath.isEmpty() ? (isUnixServer ? "$CONTROLM_SERVER" : "../../Control-M Server/ctm_server") : testPath;
        if (!isUnixServer) {
            this.scriptLocation = this.scriptLocation.replaceAll("\\\\$", "");
        }
    }

    @Override
    public void run() {
        ConversionLogger.getLogger().info("Performing tests");
        this.lastError = "";
        this.success = true;
        this.success = this.success && this.testServerComm();
        try {
            if (this.success) {
                boolean bl = this.success = this.success && this.testUtils();
            }
            if (this.success) {
                this.success = this.success && this.testScriptExistence();
            }
        }
        catch (ConvertorException e) {
            this.success = false;
            this.lastError = e.getMessage();
        }
        if (this.success) {
            this.lastError = "";
        }
        this.fireValidityEvent(this.success);
    }

    private Boolean isV8Server() {
        if (this.isV8 == null) {
            File verTestFile = null;
            try {
                verTestFile = File.createTempFile("verTest", null, new File(Globs.TEMP_DIR));
                ConversionLogger.getLogger().info("verTestFile: " + verTestFile.getAbsolutePath());
                ExternalCommand exCmd = new ExternalCommand.Builder("ctmpsm.exe", "-listgroup", "NOT_AN_APP", "NOT_A_GROUP", "ODAT").isScript(false).waitFor(true).workingDirectory(DiscoveryJob.getAgentExepath()).redirectErrToOut(true).redirectOutputToFile(verTestFile).build();
                exCmd.start();
                this.isV8 = exCmd.getExitValue() == 0 ? (this.file2String(verTestFile).toUpperCase().contains("LISTSUBAPPLICATION") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(true);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().severe("Caught IOException: " + e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
            ConversionLogger.getLogger().info("Determined version=" + (this.isV8 != false ? "V8" : "700"));
        }
        return this.isV8;
    }

    private boolean testScriptExistence() {
        boolean toRet;
        block18: {
            toRet = false;
            ConversionLogger.getLogger().info("Testing scripts existence for " + (this.isUnixServer ? "UNIX Server" : "Windows Server") + "under: " + this.scriptLocation);
            DiscoveryJob scriptTester = new DiscoveryJob("cd " + (this.isUnixServer ? "" : "/d") + " %%PARM1" + (this.isUnixServer ? ";ls " : "&dir "), "Check_script_existence", null, null, false, "check_scripts_existence");
            scriptTester.setAutoedit("PARM1", this.scriptLocation);
            this.lastError = TextManager.instance().get("PRERQ_TESTER_ERROR_UNABLE_FIND_SCRIPT") + ".\n";
            try {
                Properties tmpProps = DiscoveryMonitor.getDiscoJobAttrs();
                String application = tmpProps.getProperty("APPLICATION");
                String group = tmpProps.getProperty("GROUP");
                File tmpOutput = File.createTempFile("CTMPSM_", null, new File(Globs.TEMP_DIR));
                String cmdline = String.format("cmd /c \"\"%s\\ctmpsm\" -%s %s %s ODAT> \"%s\" 2>&1\"", DiscoveryJob.getAgentExepath(), this.isV8Server() != false ? "LISTSUBAPPLICATION" : "listgroup", application, group, tmpOutput.getAbsoluteFile());
                scriptTester.submit();
                ExternalCommand extCmd = new ExternalCommand.Builder("ctmpsm.exe", "-" + (this.isV8Server() != false ? "LISTSUBAPPLICATION" : "listgroup"), application, group, "ODAT").isScript(true).waitFor(true).workingDirectory(DiscoveryJob.getAgentExepath()).redirectErrToOut(true).redirectOutputToFile(tmpOutput).build();
                if (scriptTester.getOid() != null) {
                    Integer jobOid = Integer.valueOf(scriptTester.getOid(), 36);
                    while (true) {
                        extCmd.startThrows();
                        if (extCmd.getExitValue() == 0) {
                            String line;
                            BufferedReader freader = new BufferedReader(new FileReader(tmpOutput));
                            Pattern psmPat = Pattern.compile("^([0-9a-z]+).+?(CMD|JOB)[\\s|]+[0-9]{8}[\\s|]+(.*)");
                            while ((line = freader.readLine()) != null) {
                                Integer lineOid;
                                Matcher psmMatch = psmPat.matcher(line);
                                if (!psmMatch.matches() || !(lineOid = Integer.valueOf(psmMatch.group(1), 36)).equals(jobOid)) continue;
                                String lineStateStat = psmMatch.group(3);
                                if (lineStateStat.toUpperCase().contains("POST PRO")) {
                                    if (lineStateStat.toUpperCase().contains("NOTOK")) {
                                        scriptTester.setNOTOK();
                                    } else {
                                        scriptTester.setOK();
                                    }
                                    ConversionLogger.getLogger().info("Test job ended " + scriptTester.getState());
                                    break;
                                }
                                if (!lineStateStat.toUpperCase().contains("WAIT NOD")) break;
                                this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_AGENT_NOT_AVAILABLE") + "\n";
                                scriptTester.setNOTOK();
                                break;
                            }
                            freader.close();
                            if (line == null) {
                                this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_FAILED_CHECK_FILE_EXISTENCE_TEST_JOB_STATUS");
                                break block18;
                            }
                            if (scriptTester.getState().equals("NOTOK")) {
                                this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_FILE_EXISTENCE_TEST_JOB_ENDED_NOTOK");
                                break block18;
                            }
                            if (scriptTester.getState().equals("OK")) {
                                boolean unixFound = false;
                                boolean windowsFound = false;
                                BufferedReader Joboutput = new BufferedReader(new InputStreamReader(scriptTester.getSysout()));
                                while (!((line = Joboutput.readLine()) == null || unixFound && windowsFound)) {
                                    unixFound = unixFound || line.contains("captureScriptUNIX.txt");
                                    windowsFound = windowsFound || line.contains("captureScriptWindows.txt");
                                }
                                Joboutput.close();
                                if (!windowsFound) {
                                    this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_UNABLE_TO_FIND_UNDER") + "\n", "captureScriptWindows.txt", this.scriptLocation);
                                }
                                if (!unixFound) {
                                    this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_UNABLE_TO_FIND_UNDER") + "\n", "captureScriptUNIX.txt", this.scriptLocation);
                                }
                                toRet = unixFound && windowsFound;
                                break block18;
                            }
                        } else {
                            ConversionLogger.getLogger().info(String.format("Execution of %s failed with rc=%d", cmdline, extCmd.getExitValue()));
                            this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_EXECUTION_OF_FAILED_WITH_RC"), cmdline, extCmd.getExitValue());
                            break block18;
                        }
                        Thread.sleep(1000L);
                    }
                }
                this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_FAILD_SUBMIT_FILE_EXISTENCE_TEST_JOB");
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info("Caught IOException: " + e.getMessage());
                this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_CAUGHT_IOEXCEPTION"), e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
            catch (InterruptedException e) {
                ConversionLogger.getLogger().info("Caught InterruptedException: " + e.getMessage());
                this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_CAUGHT_INTERRUPTED_EXCEPTION"), e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
            catch (ConvertorException e) {
                this.lastError = this.lastError + String.format(TextManager.instance().get("PRERQ_TESTER_ERROR_INVALID_VALUE_FOR_DISCOVERY_JOBS"), e.getMessage());
            }
        }
        return toRet;
    }

    private boolean testUtils() throws ConvertorException {
        boolean createResult;
        boolean psmResult;
        ConversionLogger.getLogger().info("Testing Agent utilities");
        ExternalCommand psmExtCmd = new ExternalCommand.Builder("ctmpsm", "-listcal", "convrsion_psm_test", "2000").workingDirectory(DiscoveryJob.getAgentExepath()).waitFor(true).build();
        psmExtCmd.start();
        boolean bl = psmResult = psmExtCmd.getExitValue() == 0;
        if (!psmResult) {
            this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_FAILED_EXECUTE_CTMPSM") + ".\n";
        }
        String application = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_APPLICATION : SettingsStringKeys.MS_DISCOVERY_JOBS_APPLICATION);
        String group = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_SUB_APPLICATION : SettingsStringKeys.MS_DISCOVERY_JOBS_SUB_APPLICATION);
        String table = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_FOLDER_NAME : SettingsStringKeys.MS_DISCOVERY_JOBS_FOLDER_NAME);
        ExternalCommand createExtCmd = new ExternalCommand.Builder("ctmcreate", "-tasktype", "dummy", "-application", application, "-group", group, "-jobname", "test_ctmcreate", "-table", table).workingDirectory(DiscoveryJob.getAgentExepath()).waitFor(true).build();
        createExtCmd.start();
        boolean bl2 = createResult = createExtCmd.getExitValue() == 0;
        if (!createResult) {
            this.lastError = this.lastError + TextManager.instance().get("PRERQ_TESTER_ERROR_FAILED_EXECUTE_CTMCREATE") + ".\n";
        }
        return createResult && psmResult;
    }

    private boolean testServerComm() {
        boolean toRet;
        ConversionLogger.getLogger().info("Testing server communication with ag_ping");
        ExternalCommand extCmd = new ExternalCommand.Builder("ag_ping").waitFor(true).build();
        extCmd.start();
        boolean bl = toRet = extCmd.getExitValue() == 0;
        if (!toRet) {
            this.lastError = TextManager.instance().get("PRERQ_TESTER_ERROR_FAILED_PING_TO_CTM_SERVER");
        }
        return toRet;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public String getError() {
        return this.lastError;
    }

    private String file2String(File file) throws IOException {
        String tmp;
        BufferedReader freader = new BufferedReader(new FileReader(file));
        StringBuilder contents = new StringBuilder();
        while ((tmp = freader.readLine()) != null) {
            contents.append(tmp).append('\n');
        }
        freader.close();
        return contents.toString();
    }
}

