/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.base.table.BaseTableToolbar;
import com.bmc.ctmconvert.common.DescriptionManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FileFunctions;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.discovery.OsDataHolder;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ManualFilesDiscovery
extends BasePanel {
    private static final String RESULT_DATA_FILE_NAME = "ManualData.txt";
    private static final String RESULT_DATA_NEW_LINE = " @RESULT_DATA_TABLE_NEW_LINE@ ";
    private static final String RESULT_DATA_TABLE_DELIMITER = " @RESULT_DATA_TABLE_DELIMITER@ ";
    private BaseDialog manualFilesTableDialog;
    private BaseDialog addFileDialog;
    private BaseTextField machineName;
    private BaseTextField userName;
    private BaseBrowseTextField filePath;
    private BaseComboBox dateFormat;
    private BaseButton addToTable;
    private BaseButton deleteFromTable;
    private BaseTableModel model;
    private BaseFilterableTable baseFilterableTable;
    private BasePanel addFilePanel;
    private boolean needUser;
    private int MACHINE = 0;
    private int USER = 1;
    private int FILE = 2;
    private int DATE_FORMAT = 2;
    private boolean embedded;
    private PrintStream out;
    private boolean firstTime = true;

    public void viewManualFilesDiscoveryEditor() {
        if (this.manualFilesTableDialog == null) {
            this.manualFilesTableDialog = new BaseDialog(null, TextManager.instance().get("MANUAL_FILES_IMPORT"));
            this.addNavegationListener(new NavegationListener(){

                @Override
                public void navegationActionPerformed(ConversionEvent e) {
                    ManualFilesDiscovery.this.manualFilesTableDialog.dispose();
                }
            });
            this.manualFilesTableDialog.setContent(this);
            this.manualFilesTableDialog.addNavegationListener(this);
        }
        this.manualFilesTableDialog.setVisible(true);
    }

    private void viewAddFileDialog() {
        if (this.addFileDialog == null) {
            this.addFileDialog = new BaseDialog(this.embedded ? null : this.manualFilesTableDialog.getComponent(), TextManager.instance().get("MANUAL_FILES_IMPORT"));
            this.addFileDialog.addNavegationListener(new NavegationListener(){

                @Override
                public void navegationActionPerformed(ConversionEvent e) {
                    ManualFilesDiscovery.this.addFileDialog.dispose();
                }
            });
            this.addFilePanel = new BasePanel();
            final BaseNavigationPanel navigationPanel = new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.APPLY_N_CLOSE, ButtonFactory.ButtonType.CANCEL});
            navigationPanel.setEnabled(ButtonFactory.ButtonType.APPLY_N_CLOSE, false);
            this.addFilePanel.setNavigationPanel(navigationPanel);
            this.addFilePanel.addNavegationListener(this);
            BaseContentPanel addFileContent = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DISCOVERY_ADD_DATA_MANUALLY_DIALOG_FILE_DATA_SECTION_TITLE"), false), new BaseFooterPanel(""));
            BaseSection fieldSection = new BaseSection("");
            this.machineName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
            fieldSection.addField(new BaseField((BaseComponent)this.machineName, TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_MACHINE_NAME_COLUMN"), true, TextManager.instance().get("CRON_MS_MACHINE_NAME_DESCRIPTION")));
            if (this.needUser) {
                this.userName = new BaseTextField(new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY));
                fieldSection.addField(new BaseField((BaseComponent)this.userName, TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_USER_NAME_COLUMN"), true, TextManager.instance().get("CRON_MS_USER_NAME_DESCRIPTION")));
            }
            String[] extentions = new String[]{"TXT"};
            if (Params.instance().getVendorName().equals("MS")) {
                extentions = new String[]{"XML", "CSV"};
            }
            this.filePath = new BaseBrowseTextField(extentions, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH));
            fieldSection.addField(new BaseField((BaseComponent)this.filePath, TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_FILE_PATH_COLUMN"), true, TextManager.instance().get("CRON_MS_FILE_LOCATION_DESCRIPTION")));
            if (!this.needUser) {
                Object[] formatsList = new String[]{"dd/MM/yyyy", "MM/dd/yyyy", "yyyy/MM/dd"};
                this.dateFormat = new BaseComboBox(formatsList);
                this.dateFormat.setEnabled(false);
                fieldSection.addField(new BaseField((BaseComponent)this.dateFormat, TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DATE_FORMAT_COLUMN"), true, TextManager.instance().get("CRON_MS_DATE_FORMAT_DESCRIPTION")));
                this.filePath.addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        ManualFilesDiscovery.this.enableDateFormat();
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        ManualFilesDiscovery.this.enableDateFormat();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        ManualFilesDiscovery.this.enableDateFormat();
                    }
                });
            }
            fieldSection.addValidityListener(new ValidityListener(){

                @Override
                public void validityActionPerformed(ConversionEvent e) {
                    navigationPanel.setEnabled(ButtonFactory.ButtonType.APPLY_N_CLOSE, e.getValue());
                }
            });
            addFileContent.addSection(fieldSection);
            addFileContent.buildContentPanel();
            this.addFilePanel.setContentPanel(addFileContent);
            this.addFileDialog.setContent(this.addFilePanel);
        }
        this.addFileDialog.setVisible(true);
    }

    public ManualFilesDiscovery() {
        this.initialize();
    }

    public ManualFilesDiscovery(boolean embedded) {
        this.embedded = embedded;
        this.initialize();
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    private void initialize() {
        this.needUser = Params.instance().getVendorName().equals("CRON");
        if (!this.needUser) {
            this.FILE = 1;
            this.USER = -1;
        }
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("DATA_IMPORT_MANUAL_TITLE")));
        if (!this.embedded) {
            this.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.CLOSE}));
        }
        this.addToTable = ButtonFactory.createEnterSensitiveButton(ButtonFactory.ButtonType.ADD, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualFilesDiscovery.this.viewAddFileDialog();
            }
        });
        this.addToTable.setEnabled(true);
        String[] columnNames = null;
        columnNames = this.needUser ? new String[]{TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_MACHINE_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_USER_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_FILE_PATH_COLUMN")} : new String[]{TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_MACHINE_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_FILE_PATH_COLUMN"), TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DATE_FORMAT_COLUMN")};
        this.model = new BaseTableModel((Object[][])new Object[0][], columnNames);
        this.baseFilterableTable = new BaseFilterableTable();
        this.baseFilterableTable.setModel(this.model);
        this.baseFilterableTable.addSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManualFilesDiscovery.this.deleteFromTable.setEnabled(ManualFilesDiscovery.this.baseFilterableTable.getSelectedRowIndex() != -1);
            }
        });
        this.deleteFromTable = ButtonFactory.createButton(ButtonFactory.ButtonType.DELETE, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManualFilesDiscovery.this.removeRowFromTable();
            }
        });
        BaseTableToolbar toolbar = new BaseTableToolbar();
        toolbar.add(this.addToTable);
        toolbar.add(Box.createRigidArea(new Dimension(5, 0)));
        toolbar.add(this.deleteFromTable);
        BaseExtendedTable additionalFilesList = new BaseExtendedTable(this.baseFilterableTable, toolbar, null);
        BaseField additionalFilesListField = new BaseField(additionalFilesList);
        additionalFilesListField.setFillAllArea(true);
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout(new BorderLayout());
        dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        dataPanel.add(additionalFilesList.getComponent(), "Center");
        this.baseContentPanel.setContentPanel(dataPanel);
        this.setContentPanel(this.baseContentPanel);
    }

    private void enableDateFormat() {
        this.dateFormat.setEnabled(this.filePath.getText().trim().toLowerCase().endsWith(".csv"));
    }

    private boolean addRowToTable() {
        boolean added = false;
        Object messages = "";
        String machine = this.machineName.getText().trim();
        String user = "";
        String format = "";
        if (this.needUser) {
            user = this.userName.getText().trim();
        } else {
            format = this.filePath.getText().trim().toLowerCase().endsWith(".csv") ? this.dateFormat.getSelectedItem().toString() : "";
        }
        String file = this.filePath.getText().trim();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            if (((String)this.model.getValueAt(i, this.MACHINE)).equalsIgnoreCase(machine) && (!this.needUser || ((String)this.model.getValueAt(i, this.USER)).equalsIgnoreCase(user))) {
                messages = (String)messages + (String)(this.needUser ? user + "%" : "") + machine + " " + TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DIALOG_ALREADY_EXSITS_IN_TABLE") + "\n";
            }
            if (!this.model.getValueAt(i, this.FILE).equals(file)) continue;
            messages = (String)messages + file + " " + TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DIALOG_ALREADY_IN_USE_FOR") + " " + (String)(this.needUser ? user + "%" : "") + machine + "\n";
        }
        if (((String)messages).isEmpty()) {
            Object[] row = null;
            row = this.needUser ? new Object[]{machine, user, file} : new Object[]{machine, file, format};
            this.model.addRow(row);
            if (this.embedded) {
                this.saveRowTofile(row);
            }
            added = true;
        } else {
            BaseMessageDialog.showMessageDialog(TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DIALOG_TITLE"), TextManager.instance().get("DISCOVERY_IMPORT_DATA_MANUALLY_DIALOG_MSG_FAILED_ADDING_TO_TABLE"), BaseMessageDialog.TYPE.WARNING_MESSAGE, (String)messages);
        }
        if (added) {
            this.machineName.setText("");
            this.machineName.setValidityLook(true);
            if (this.needUser) {
                this.userName.setText("");
                this.userName.setValidityLook(true);
            }
            this.filePath.setText("");
            this.filePath.setValidityLook(true);
            this.setValid(true);
        }
        return added;
    }

    private void removeRowFromTable() {
        Object[] selectedRow = this.baseFilterableTable.getSelectedRow();
        if (Params.instance().isImportComplete()) {
            Object fileName = "";
            if (Params.instance().getVendorName().equals("MS")) {
                String fileSuffix = ((String)selectedRow[this.FILE]).trim().toLowerCase().endsWith(".csv") ? ".csv" : ".xml";
                fileName = String.valueOf(selectedRow[this.MACHINE]) + fileSuffix;
            } else {
                fileName = String.format("%s%%%s.txt", selectedRow[this.USER], selectedRow[this.MACHINE]);
            }
            File toRemove = new File(Params.instance().getDatasourcePath() + Globs.DIRSEP + (String)fileName);
            if (toRemove.exists()) {
                toRemove.delete();
            }
        }
        this.baseFilterableTable.removeRow(this.baseFilterableTable.getSelectedRowIndex());
        if (this.out != null) {
            this.out.close();
            this.firstTime = true;
        }
        if (this.baseFilterableTable.getRowCount() == 0) {
            this.setValid(false);
        }
    }

    private void saveRowTofile(Object[] row) {
        try {
            if (this.firstTime) {
                File file = new File(Params.instance().getDatasourcePath() + "OnlyManualData.txt");
                this.out = new PrintStream(new BufferedOutputStream(new FileOutputStream(file, true)));
                if (file.length() == 0L) {
                    for (int column = 0; column < this.model.getColumnCount(); ++column) {
                        this.out.print(this.model.getColumnName(column) + " ### ");
                    }
                    this.out.println();
                }
                this.firstTime = false;
            }
            for (int column = 0; column < this.model.getColumnCount(); ++column) {
                this.out.print(((String)row[column]).replace("\n", RESULT_DATA_NEW_LINE) + RESULT_DATA_TABLE_DELIMITER);
            }
            this.out.println();
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public void close() {
        if (this.out != null) {
            this.out.close();
        }
    }

    public Vector getDataVector() {
        return this.model.getDataVector();
    }

    public FlowGlobals.COMPLETION_MODE copyFilesToDestinationFolder(String destinationFolderPath) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
        ArrayList<OsDataHolder> osDataHolderList = this.buildOsDataHolderList(this.model.getDataVector());
        toRet = ManualFilesDiscovery.staticCopyFilesToDestinationFolder(destinationFolderPath, osDataHolderList);
        return toRet;
    }

    private ArrayList<OsDataHolder> buildOsDataHolderList(Vector manualFilesData) {
        ArrayList<OsDataHolder> osDataHolderList = new ArrayList<OsDataHolder>();
        Enumeration iterator = manualFilesData.elements();
        while (iterator.hasMoreElements()) {
            String dateFormat = "";
            String userName = "";
            Vector row = (Vector)iterator.nextElement();
            String machineName = (String)row.elementAt(this.MACHINE);
            String dataFile = (String)row.elementAt(this.FILE);
            if (Params.instance().getVendorName().equals("MS")) {
                dateFormat = (String)row.elementAt(this.DATE_FORMAT);
            } else {
                userName = (String)row.elementAt(this.USER);
            }
            osDataHolderList.add(new OsDataHolder(machineName, dataFile, dateFormat, userName));
        }
        return osDataHolderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowGlobals.COMPLETION_MODE staticCopyFilesToDestinationFolder(String destinationFolderPath, ArrayList<OsDataHolder> osDataHolderList) {
        FlowGlobals.COMPLETION_MODE toRet = FlowGlobals.COMPLETION_MODE.SUCCESS;
        Properties dateFormatMap = new Properties();
        if (Params.instance().getVendorName().equals("MS")) {
            try {
                dateFormatMap.load(new FileReader(Params.instance().getDatasourcePath() + "dateMap.txt"));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException | IllegalArgumentException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        for (OsDataHolder osDataHolder : osDataHolderList) {
            File customerFile;
            Object fileName = "";
            if (Params.instance().getVendorName().equals("MS")) {
                String fileSuffix = osDataHolder.getDataFile().trim().toLowerCase().endsWith(".csv") ? ".csv" : ".xml";
                fileName = osDataHolder.getMachineName() + fileSuffix;
                dateFormatMap.setProperty(osDataHolder.getMachineName(), osDataHolder.getDateFormat());
            } else {
                fileName = osDataHolder.getUserName() + "%" + osDataHolder.getMachineName() + ".txt";
            }
            File destinationFile = new File(destinationFolderPath + (String)fileName);
            if (destinationFile.exists()) {
                ConversionLogger.getLogger().info(String.format("Overwriting \"%s\".", destinationFile));
            }
            if (!(customerFile = new File(osDataHolder.getDataFile())).exists()) {
                ConversionLogger.getLogger().info(String.format("File \"%s\" not exist.", customerFile));
            }
            try {
                FileFunctions.copyFile(customerFile, destinationFile);
                ConversionLogger.getLogger().info(String.format("Copy \"%s\" ,To: \"%s\".", customerFile, destinationFile));
            }
            catch (IOException e) {
                ConversionLogger.getLogger().info(String.format("Failed to copy %s to %s.", customerFile.toString(), destinationFile.toString()));
                ProcessAlertsManager.instance().addMessage(String.format("Failed to copy %s to %s.", customerFile.toString(), destinationFile.toString()));
                toRet = FlowGlobals.COMPLETION_MODE.FAILURE;
            }
            finally {
                customerFile = null;
                destinationFile = null;
            }
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(Params.instance().getDatasourcePath() + "dateMap.txt"));
                dateFormatMap.store(bufferedWriter, null);
                bufferedWriter.close();
            }
            catch (IOException | ClassCastException | NullPointerException e) {
                ConversionLogger.getLogger().info(e.getMessage());
            }
        }
        return toRet;
    }

    @Override
    public void navegationActionPerformed(ConversionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
            this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
            if (Params.instance().getVendorName().equals("CRON")) {
                DescriptionManager.instance().showDescriptionDialog("LOAD_DATA_CRON_MANUAL_DIALOG");
            } else {
                DescriptionManager.instance().showDescriptionDialog("LOAD_DATA_MS_MANUAL_DIALOG");
            }
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_APPLY_N_CLOSE"))) {
            if (this.addRowToTable()) {
                this.addFileDialog.dispose();
            }
        } else if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR"))) {
            this.addFileDialog.dispose();
        }
    }
}

