/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableToolbar;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.discovery.BussyLoadingPanel;
import com.bmc.ctmconvert.discovery.DiscoveryBaseTable;
import com.bmc.ctmconvert.discovery.DiscoveryBaseTableModel;
import com.bmc.ctmconvert.discovery.FileListTableDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class DiscoveryResults
extends BaseComponent
implements ActionListener {
    private ResultsType resultsType;
    private JPanel jPanel;
    private JPanel dataPanel;
    private JPanel loadingPanel;
    private BaseTabbedPane tabbedPane;
    private BaseTableToolbar agentListToolbar;
    BaseExtendedTable agentsList;
    private static final String TAB_TITLE_COUNTER = "0";
    public static final int AGENTS = 0;
    public static final int RUNNING = 0;
    public static final int SUCCESS = 1;
    public static final int FAILED = 2;
    public static final int BASE = 3;
    public static final String[] tabNames = new String[]{TextManager.instance().get("DISCOVERY_RESULTS_LIST_RUNNING_TAB") + " (0)", TextManager.instance().get("DISCOVERY_RESULTS_LIST_SUCCEEDED_TAB") + " (0)", TextManager.instance().get("DISCOVERY_RESULTS_LIST_FAILED_TAB") + " (0)"};
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_STATUS = 1;
    public static final int COLUMN_AGENT_NAME = 2;
    public static final int COLUMN_USER_NAME = 3;
    public static final int COLUMN_FILE_NAME = 4;
    public static final int COLUMN_GENERAL_DETAILS = 5;
    public static final int COLUMN_DETAILS = 6;
    private String[] columnNames = new String[]{TextManager.instance().get("DISCOVERY_RESULTS_LIST_ID_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_STATUS_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_AGENT_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_USER_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_FILE_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_GENERAL_DETAILS_COLUMN"), TextManager.instance().get("DISCOVERY_RESULTS_LIST_DETAILS_COLUMN")};
    private DefaultTableModel[] modelsArray;
    public static final int AGENT_COLUMN_ID = 0;
    public static final int AGENT_COLUMN_BOOLEAN = 1;
    public static final int AGENT_COLUMN_AGENT_STATUS = 2;
    public static final int AGENT_COLUMN_AGENT_NAME = 3;
    public static final int AGENT_COLUMN_AGENT_PLATFORM = 4;
    public static final int AGENT_COLUMN_OWNER = 5;
    public static final int AGENT_COLUMN_RETRIEVE_STATUS = 6;
    private String[] agentsTableColumn = new String[]{TextManager.instance().get("DISCOVERY_AGENTS_LIST_ID_COLUMN"), "", TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_COLUMN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_NAME_COLUMN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_PLATFORM_COLUMN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_OWNER_COLUMN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_STATUS_COLUMN")};
    public static final String AGENT_RETRIEVE_STATUS_COLLECTED = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_RETRIEVE_STATUS_COLLECTED");
    public static final String AGENT_STATUS_AVAILABLE = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_AVAILABLE");
    public static final String AGENT_STATUS_UNAVAILABLE = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_UNAVAILABLE");
    public static final String AGENT_STATUS_UPGRADING = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_UPGRADING");
    public static final String AGENT_STATUS_DISABLED = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_DISABLED");
    public static final String AGENT_STATUS_DISCOVERING = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_DISCOVERING");
    public static final String AGENT_STATUS_ERASE = TextManager.instance().get("DISCOVERY_AGENTS_LIST_AGENT_STATUS_ERASE");
    private int CHECK_ALL = 0;
    private int UNCHECK_ALL = 1;
    private int INVERT_SELECTION = 2;
    private int REFRESH = 3;
    private String[] agentListActions = new String[]{TextManager.instance().get("DISCOVERY_AGENTS_LIST_SELECT_ALL_BTN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_SELECT_CLEAR_ALL_BTN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_SELECT_INVERT_SELECTION_BTN"), TextManager.instance().get("DISCOVERY_AGENTS_LIST_SELECT_REFRESH_BTN")};

    public DiscoveryResults(ResultsType resultsType) {
        this.resultsType = resultsType;
        this.initialize();
    }

    private void initialize() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new OverlayLayout(this.jPanel));
        this.loadingPanel = new BussyLoadingPanel();
        this.jPanel.add(this.loadingPanel);
        this.loadingPanel.setVisible(false);
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new BorderLayout());
        this.dataPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel.add(this.dataPanel);
        switch (this.resultsType.ordinal()) {
            case 0: {
                this.modelsArray = new DefaultTableModel[1];
                this.modelsArray[0] = new DiscoveryBaseTableModel(new String[0][], this.agentsTableColumn, this.resultsType);
                this.modelsArray[0].addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        if (e.getColumn() == 1) {
                            DiscoveryResults.this.fireValidityEvent(DiscoveryResults.this.isValid());
                        }
                    }
                });
                BaseFilterableTable baseFilterableTable = new BaseFilterableTable(new DiscoveryBaseTable());
                baseFilterableTable.setModel(this.modelsArray[0]);
                this.agentListToolbar = new BaseTableToolbar();
                BaseButton selectAll = new BaseButton(this.agentListActions[this.CHECK_ALL]);
                selectAll.setActionCommand(this.agentListActions[this.CHECK_ALL]);
                selectAll.addActionListener(this);
                this.agentListToolbar.add(selectAll);
                this.agentListToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
                BaseButton unSelectAll = new BaseButton(this.agentListActions[this.UNCHECK_ALL]);
                unSelectAll.setActionCommand(this.agentListActions[this.UNCHECK_ALL]);
                unSelectAll.addActionListener(this);
                this.agentListToolbar.add(unSelectAll);
                this.agentListToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
                BaseButton invertSelection = new BaseButton(this.agentListActions[this.INVERT_SELECTION]);
                invertSelection.setActionCommand(this.agentListActions[this.INVERT_SELECTION]);
                invertSelection.addActionListener(this);
                this.agentListToolbar.add(invertSelection);
                this.agentListToolbar.add(Box.createRigidArea(new Dimension(5, 0)));
                this.agentListToolbar.add(Box.createHorizontalGlue());
                BaseButton refresh = new BaseButton(this.agentListActions[this.REFRESH]);
                refresh.setActionCommand(this.agentListActions[this.REFRESH]);
                refresh.addActionListener(this);
                this.agentListToolbar.add(refresh);
                this.agentsList = new BaseExtendedTable(baseFilterableTable, this.agentListToolbar, null);
                this.dataPanel.add(this.agentsList.getComponent(), "Center");
                break;
            }
            case 1: {
                this.modelsArray = new DefaultTableModel[4];
                this.modelsArray[3] = new DefaultTableModel(new String[0][], this.columnNames);
                this.modelsArray[3].addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent e) {
                        DiscoveryResults.this.updateModelsArray(e);
                    }
                });
                this.tabbedPane = new BaseTabbedPane();
                this.tabbedPane.addTab(tabNames[0], this.createTab(0));
                this.tabbedPane.addTab(tabNames[1], this.createTab(1));
                this.tabbedPane.addTab(tabNames[2], this.createTab(2));
                this.tabbedPane.setTabPlacement(1);
                this.dataPanel.add(this.tabbedPane.getComponent(), "Center");
                break;
            }
            default: {
                this.dataPanel = new JPanel();
            }
        }
    }

    public void setBusyLoading(boolean b) {
        if (this.resultsType.equals((Object)ResultsType.AGENTS_LIST)) {
            this.agentsList.setEnabled(!b);
        }
        this.loadingPanel.setVisible(b);
    }

    public ResultsType getResultsType() {
        return this.resultsType;
    }

    private JPanel createTab(int type) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(FlowGlobals.customTableTabBorder);
        jPanel.setBackground(FlowGlobals.ConversionGray);
        JPanel contentPanel = new JPanel();
        contentPanel.setBackground(new Color(12702954));
        contentPanel.setLayout(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(7, 4, 4, 4), FlowGlobals.customLowerBorder));
        this.modelsArray[type] = new DiscoveryBaseTableModel(new String[0][], this.columnNames, this.resultsType);
        BaseFilterableTable baseFilterableTable = new BaseFilterableTable();
        baseFilterableTable.setModel(this.modelsArray[type]);
        baseFilterableTable.setColumnWidth(0, 0);
        baseFilterableTable.setColumnWidth(1, 0);
        baseFilterableTable.setColumnWidth(5, 0);
        baseFilterableTable.setColumnWidth(6, 0);
        BaseExtendedTable filesList = new BaseExtendedTable(baseFilterableTable, null, type == 0 ? null : new FileListTableDetails());
        contentPanel.add(filesList.getComponent());
        jPanel.add(contentPanel);
        return jPanel;
    }

    public DefaultTableModel getModel(int model) {
        return this.modelsArray[model];
    }

    private void updateModelsArray(TableModelEvent e) {
        int changedRow = e.getFirstRow();
        int status = Integer.valueOf((String)this.modelsArray[3].getValueAt(changedRow, 1));
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        values.put(2, (String)this.modelsArray[3].getValueAt(changedRow, 2));
        values.put(3, (String)this.modelsArray[3].getValueAt(changedRow, 3));
        switch (e.getType()) {
            case 1: {
                this.modelsArray[status].addRow(this.getRowData(3, changedRow));
                this.tabbedPane.setTitleAt(status, tabNames[status].replace(TAB_TITLE_COUNTER, String.valueOf(this.modelsArray[status].getRowCount())));
                break;
            }
            case -1: {
                if (status != 0) break;
                this.modelsArray[0].removeRow(changedRow);
                this.tabbedPane.setTitleAt(0, tabNames[0].replace(TAB_TITLE_COUNTER, String.valueOf(this.modelsArray[0].getRowCount())));
                break;
            }
            case 0: {
                int rowIndex = this.getRowIndexByValues(status, values);
                if (rowIndex != -1) {
                    for (int columnIndex = 0; columnIndex < this.modelsArray[status].getColumnCount(); ++columnIndex) {
                        this.modelsArray[status].setValueAt(this.modelsArray[3].getValueAt(changedRow, columnIndex), rowIndex, columnIndex);
                    }
                    break;
                }
                this.modelsArray[status].addRow(this.getRowData(3, changedRow));
                this.tabbedPane.setTitleAt(status, tabNames[status].replace(TAB_TITLE_COUNTER, String.valueOf(this.modelsArray[status].getRowCount())));
                break;
            }
        }
        for (int model = 0; model < this.modelsArray.length; ++model) {
            int index;
            if (model == 3 || model == status || (index = this.getRowIndexByValues(model, values)) == -1) continue;
            this.modelsArray[model].removeRow(index);
            this.tabbedPane.setTitleAt(model, tabNames[model].replace(TAB_TITLE_COUNTER, String.valueOf(this.modelsArray[model].getRowCount())));
        }
    }

    protected Object[] getRowData(int model, int rowIndex) {
        Object[] row = null;
        if (rowIndex != -1) {
            int columnCount = this.modelsArray[model].getColumnCount();
            row = new Object[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                row[i] = this.modelsArray[model].getValueAt(rowIndex, i);
            }
        }
        return row;
    }

    protected int getRowIndexByValues(int model, HashMap<Integer, String> values) {
        for (int row = 0; row < this.modelsArray[model].getRowCount(); ++row) {
            boolean found = true;
            for (int column : values.keySet()) {
                if (this.modelsArray[model].getValueAt(row, column).equals(values.get(column))) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return row;
        }
        return -1;
    }

    public static String getDirSep(String path) {
        if (path.matches("^([A-Za-z]:|\\\\\\\\).*")) {
            return "\\";
        }
        return "/";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(this.agentListActions[this.CHECK_ALL])) {
            this.setTableCheckBoxs(this.CHECK_ALL);
        } else if (e.getActionCommand().equals(this.agentListActions[this.UNCHECK_ALL])) {
            this.setTableCheckBoxs(this.UNCHECK_ALL);
        } else if (e.getActionCommand().equals(this.agentListActions[this.INVERT_SELECTION])) {
            this.setTableCheckBoxs(this.INVERT_SELECTION);
        } else if (e.getActionCommand().equals(this.agentListActions[this.REFRESH])) {
            this.fireNavegationEvent(this.agentListActions[this.REFRESH]);
        }
    }

    private void setTableCheckBoxs(int checkAction) {
        Boolean value = null;
        if (checkAction == this.CHECK_ALL) {
            value = new Boolean(true);
        } else if (checkAction == this.UNCHECK_ALL) {
            value = new Boolean(false);
        }
        for (int row = 0; row < this.modelsArray[0].getRowCount(); ++row) {
            if (!this.modelsArray[0].getValueAt(row, 2).equals(AGENT_STATUS_AVAILABLE)) continue;
            if (checkAction == this.INVERT_SELECTION) {
                value = new Boolean((Boolean)this.modelsArray[0].getValueAt(row, 1) == false);
            }
            this.modelsArray[0].setValueAt(value, row, 1);
        }
    }

    @Override
    public boolean isValid() {
        boolean valid = false;
        block0 : switch (this.resultsType.ordinal()) {
            case 0: {
                for (int i = 0; i < this.modelsArray[0].getRowCount(); ++i) {
                    if (!((Boolean)this.modelsArray[0].getValueAt(i, 1)).booleanValue() && !this.modelsArray[0].getValueAt(i, 6).equals(AGENT_RETRIEVE_STATUS_COLLECTED)) continue;
                    valid = true;
                    break block0;
                }
                break;
            }
            case 1: {
                if (this.modelsArray[1].getRowCount() <= 0 || this.modelsArray[0].getRowCount() != 0) break;
                valid = true;
                break;
            }
        }
        this.setValid(valid);
        return valid;
    }

    public void stopMonitoring() {
        DefaultTableModel model = null;
        if (this.resultsType.equals((Object)ResultsType.AGENTS_LIST)) {
            model = this.modelsArray[0];
        } else {
            model = this.modelsArray[0];
            this.tabbedPane.setTitleAt(0, tabNames[0].replace(TAB_TITLE_COUNTER, String.valueOf(0)));
        }
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
    }

    @Override
    public void validityActionPerformed(ConversionEvent e) {
        if (!this.isValid()) {
            this.fireValidityEvent(false);
        }
        this.setBusyLoading(false);
    }

    @Override
    public Component getComponent() {
        return this.jPanel;
    }

    public static enum ResultsType {
        AGENTS_LIST,
        CAPTURE_FILES;

    }
}

