/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.base.Base;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.discovery.DiscoveryJob;
import com.bmc.ctmconvert.discovery.DiscoveryResults;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiscoveryMonitor
extends Base
implements Runnable {
    private static final int maxFailures = 3;
    private HashMap<Integer, DiscoveryJob> runningJobs = new HashMap();
    private HashMap<Integer, DiscoveryJob> completedJobs = new HashMap();
    private ArrayList<DiscoveryJob> waitingJobs = new ArrayList();
    private DiscoveryResults discoModel;
    private HashMap<Integer, Integer> orderId2JobId;
    private Boolean isV8 = null;
    private Properties dateFormatMap;
    private boolean stoppedByUser;
    private int failCount = 0;
    private File tmpOutput;
    private StringBuilder lastFailureDetails;

    public DiscoveryMonitor(DiscoveryResults resultsModel, String agentExePath) {
        this.discoModel = resultsModel;
        this.orderId2JobId = new HashMap();
        this.isV8 = this.isV8Server(agentExePath);
    }

    public void stopMonitoring() {
        this.stoppedByUser = true;
    }

    public static Properties getDiscoJobAttrs() throws ConvertorException {
        String application = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_APPLICATION : SettingsStringKeys.MS_DISCOVERY_JOBS_APPLICATION);
        String group = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_SUB_APPLICATION : SettingsStringKeys.MS_DISCOVERY_JOBS_SUB_APPLICATION);
        String table = SettingsTable.instance().getProperty(Params.instance().getVendorName().equals("CRON") ? SettingsStringKeys.CRON_DISCOVERY_JOBS_FOLDER_NAME : SettingsStringKeys.MS_DISCOVERY_JOBS_FOLDER_NAME);
        String version = SettingsTable.instance().getProperty(SettingsStringKeys.GUI_VERSION);
        boolean isV7 = version.equals("7");
        if (!application.matches("[^ \t']{1,64}")) {
            throw new ConvertorException("Invalid application name defined for discovery job");
        }
        if (!group.matches("[^ \t']{1,64}")) {
            throw new ConvertorException(String.format("Invalid %s name defined for discovery job", isV7 ? "group" : "sub application"));
        }
        if (!table.matches("[^ \t']{1,770}")) {
            throw new ConvertorException(String.format("Invalid %s name defined for discovery job", isV7 ? "table" : "folder"));
        }
        Properties toRet = new Properties();
        toRet.setProperty("TABLE", table);
        toRet.setProperty("GROUP", group);
        toRet.setProperty("APPLICATION", application);
        return toRet;
    }

    private Boolean isV8Server(String agentExePath) {
        if (this.isV8 == null) {
            File verTestFile = null;
            try {
                verTestFile = File.createTempFile("verTest", null, new File(Globs.TEMP_DIR));
                ConversionLogger.getLogger().info("verTestFile: " + verTestFile.getAbsolutePath());
                ExternalCommand exCmd = new ExternalCommand.Builder("ctmpsm.exe", "-listgroup", "NOT_AN_APP", "NOT_A_GROUP", "ODAT").isScript(false).waitFor(true).workingDirectory(agentExePath).redirectErrToOut(true).redirectOutputToFile(verTestFile).build();
                exCmd.start();
                this.isV8 = exCmd.getExitValue() == 0 ? (this.file2String(verTestFile).toUpperCase().contains("LISTSUBAPPLICATION") ? Boolean.valueOf(true) : Boolean.valueOf(false)) : Boolean.valueOf(true);
            }
            catch (IOException e) {
                ConversionLogger.getLogger().severe("Caught IOException: " + e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
            ConversionLogger.getLogger().info("Determined version=" + (this.isV8 != false ? "V8" : "700"));
        }
        return this.isV8;
    }

    public boolean isFailedMonitor() {
        return this.failCount >= 3;
    }

    public File getOutFile() {
        return this.tmpOutput;
    }

    public void resetTmpOutput() {
        this.tmpOutput = null;
    }

    private String file2String(File file) throws IOException {
        String tmp;
        BufferedReader freader = new BufferedReader(new FileReader(file));
        StringBuilder contents = new StringBuilder();
        while ((tmp = freader.readLine()) != null) {
            contents.append(tmp).append('\n');
        }
        freader.close();
        return contents.toString();
    }

    private String[] job2TableRow(DiscoveryJob job) {
        return new String[]{job.getId().toString(), this.state2Stateus(job.getState()), job.getNode(), job.getOwner(), TextManager.instance().get("DISCOVERY_MONITOR_TARGET_FILE")};
    }

    private String state2Stateus(String state) {
        if (state.equals("OK")) {
            return "1";
        }
        if (state.equals("NOTOK")) {
            return "2";
        }
        return "0";
    }

    @Override
    public void run() {
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        Integer agentListJobId = null;
        int chunk = 5;
        this.lastFailureDetails = new StringBuilder();
        while (!this.stoppedByUser && !this.isFailedMonitor()) {
            for (int i = 0; i < 5 && !this.waitingJobs.isEmpty(); ++i) {
                DiscoveryJob currJob = this.waitingJobs.remove(0);
                if (this.discoModel.getResultsType().equals((Object)DiscoveryResults.ResultsType.AGENTS_LIST)) {
                    agentListJobId = currJob.getId();
                }
                try {
                    currJob.submit();
                    if (currJob.getOid() != null) {
                        this.orderId2JobId.put(Integer.valueOf(currJob.getOid(), 36), currJob.getId());
                        this.runningJobs.put(currJob.getId(), currJob);
                        continue;
                    }
                    if (!currJob.isMonitored()) continue;
                    values.put(2, currJob.getNode());
                    values.put(3, currJob.getOwner());
                    currJob.setNOTOK();
                    this.discoModel.getModel(3).setValueAt("2", this.discoModel.getRowIndexByValues(3, values), 1);
                    this.completedJobs.put(currJob.getId(), currJob);
                    this.discoModel.getModel(3).setValueAt(currJob.getGeneralDetails(), this.discoModel.getRowIndexByValues(3, values), 5);
                    this.discoModel.getModel(3).setValueAt(currJob.getDetails(), this.discoModel.getRowIndexByValues(3, values), 6);
                    continue;
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                    continue;
                }
                catch (InterruptedException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                    continue;
                }
                catch (ConvertorException e) {
                    // empty catch block
                }
            }
            try {
                this.failCount = this.refresh() ? 0 : ++this.failCount;
            }
            catch (ConvertorException e1) {
                ConversionLogger.getLogger().severe(e1.getMessage());
                this.failCount = 100;
                this.lastFailureDetails.append(e1.getMessage());
            }
            if (this.runningJobs.isEmpty() && this.waitingJobs.isEmpty()) {
                Object[][] agentList;
                if (!this.discoModel.getResultsType().equals((Object)DiscoveryResults.ResultsType.AGENTS_LIST) || agentListJobId == null || (agentList = this.getAgentList(this.completedJobs.get(agentListJobId))) == null) break;
                for (int row = 0; row < agentList.length; ++row) {
                    values.put(3, (String)agentList[row][3]);
                    int rowIndex = this.discoModel.getRowIndexByValues(0, values);
                    if (rowIndex == -1) {
                        this.discoModel.getModel(0).addRow(agentList[row]);
                        continue;
                    }
                    this.discoModel.getModel(0).setValueAt(agentList[row][2], rowIndex, 2);
                }
                break;
            }
            if (!this.waitingJobs.isEmpty()) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
        if (!this.discoModel.getResultsType().equals((Object)DiscoveryResults.ResultsType.AGENTS_LIST) && this.dateFormatMap != null) {
            try {
                this.dateFormatMap.store(new BufferedWriter(new FileWriter(Params.instance().getDatasourcePath() + "dateMap.txt")), null);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
        if (this.stoppedByUser || this.isFailedMonitor()) {
            this.discoModel.stopMonitoring();
        }
        this.setValid(true);
        if (this.isFailedMonitor()) {
            String title = this.discoModel.getResultsType().equals((Object)DiscoveryResults.ResultsType.AGENTS_LIST) ? TextManager.instance().get("DISCOVERY_MONITOR_MSG_DIALOG_TITLE_AGENT_LIST") : TextManager.instance().get("DISCOVERY_MONITOR_MSG_DIALOG_TITLE_RESULT_LIST");
            String message = String.format(TextManager.instance().get("DISCOVERY_MONITOR_MSG_DIALOG_FAILED_TO_RETRIVE"), this.discoModel.getResultsType().equals((Object)DiscoveryResults.ResultsType.AGENTS_LIST) ? TextManager.instance().get("DISCOVERY_MONITOR_MSG_DIALOG_TITLE_AGENT_LIST") : TextManager.instance().get("DISCOVERY_MONITOR_MSG_DIALOG_DATA_COLLECTION_STATUS"));
            String details = this.getFailureDetails();
            BaseMessageDialog.showMessageDialog(title, message, BaseMessageDialog.TYPE.ERROR_MESSAGE, details);
        }
    }

    private String getFailureDetails() {
        if (this.lastFailureDetails.length() > 0) {
            this.lastFailureDetails.insert(0, TextManager.instance().get("DISCOVERY_MONITOR_FAILURE_DETAILS_ERRORS") + ":\n");
        }
        if (this.tmpOutput != null) {
            try {
                this.lastFailureDetails.append(TextManager.instance().get("DISCOVERY_MONITOR_FAILURE_DETAILS_STDOUT") + ":\n");
                this.lastFailureDetails.append(this.file2String(this.tmpOutput));
            }
            catch (IOException e) {
                this.lastFailureDetails.append(e.getMessage());
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
        return this.lastFailureDetails.toString();
    }

    public void registerJob(DiscoveryJob job) {
        ConversionLogger.getLogger().info(String.format("Registered %s job with owner: %s, node: %s", job.isMonitored() ? "monitored" : "unmonitored", job.getOwner() == null ? "NULL" : job.getOwner(), job.getNode() == null ? "NULL" : job.getNode()));
        this.waitingJobs.add(job);
        if (job.isMonitored()) {
            this.discoModel.getModel(3).addRow(this.job2TableRow(job));
        }
    }

    public boolean refresh() throws ConvertorException {
        boolean toRet = true;
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        try {
            if (this.tmpOutput == null) {
                this.tmpOutput = File.createTempFile("CTMPSM_", null, new File(Globs.TEMP_DIR));
            }
            Properties tmpProps = DiscoveryMonitor.getDiscoJobAttrs();
            String application = tmpProps.getProperty("APPLICATION");
            String group = tmpProps.getProperty("GROUP");
            ConversionLogger.getLogger().info("Temp PSM: " + this.tmpOutput.getAbsolutePath());
            String cmdline = String.format("cmd /c \"\"%s\\ctmpsm\" -%s %s %s  ODAT> \"%s\" 2>&1\"", DiscoveryJob.getAgentExepath(), this.isV8 != false ? "LISTSUBAPPLICATION" : "listgroup", application, group, this.tmpOutput.getAbsoluteFile());
            ConversionLogger.getLogger().info("PSM command: " + cmdline);
            ExternalCommand exCmd = new ExternalCommand.Builder("ctmpsm.exe", "-" + (this.isV8 != false ? "LISTSUBAPPLICATION" : "listgroup"), application, group, "ODAT").isScript(false).waitFor(true).workingDirectory(DiscoveryJob.getAgentExepath()).redirectErrToOut(true).redirectOutputToFile(this.tmpOutput.getAbsoluteFile()).build();
            exCmd.startThrows();
            if (exCmd.getExitValue() == 0) {
                String line;
                BufferedReader freader = new BufferedReader(new FileReader(this.tmpOutput));
                Pattern psmPat = Pattern.compile("^([0-9a-z]+).+?(CMD|JOB)[\\s|]+[0-9]{8}[\\s|]+(.*)");
                while ((line = freader.readLine()) != null) {
                    String lineStateStat;
                    Integer lineOid;
                    Integer jobId;
                    Matcher psmMatch = psmPat.matcher(line);
                    if (!psmMatch.matches() || !this.runningJobs.containsKey(jobId = this.orderId2JobId.get(lineOid = Integer.valueOf(psmMatch.group(1), 36)))) continue;
                    if (this.runningJobs.get(jobId).isMonitored()) {
                        values.put(2, this.runningJobs.get(jobId).getNode());
                        values.put(3, this.runningJobs.get(jobId).getOwner());
                    }
                    if ((lineStateStat = psmMatch.group(3)).toUpperCase().contains("POST PRO")) {
                        if (lineStateStat.contains("NOTOK")) {
                            ConversionLogger.getLogger().info("Job orederid=" + Integer.toString(lineOid, 36) + " ended NOTOK");
                            this.runningJobs.get(jobId).setNOTOK(TextManager.instance().get("DISCOVERY_MONITOR_SET_NOTOK_RETRIVEAL_JOB_ENDED_NOTOK"));
                            if (this.runningJobs.get(jobId).isMonitored()) {
                                this.discoModel.getModel(3).setValueAt("2", this.discoModel.getRowIndexByValues(3, values), 1);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getGeneralDetails(), this.discoModel.getRowIndexByValues(3, values), 5);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getDetails(), this.discoModel.getRowIndexByValues(3, values), 6);
                                this.runningJobs.get(jobId).getLog();
                                if (!this.runningJobs.get(jobId).isFailedSubmit()) {
                                    this.runningJobs.get(jobId).getSysout();
                                }
                            }
                            this.completedJobs.put(jobId, this.runningJobs.remove(jobId));
                            continue;
                        }
                        ConversionLogger.getLogger().info("Job orederid=" + Integer.toString(lineOid, 36) + " ended OK");
                        if (this.runningJobs.get(jobId).isMonitored()) {
                            if (this.sysout2datasource(this.runningJobs.get(jobId))) {
                                this.discoModel.getModel(3).setValueAt("1", this.discoModel.getRowIndexByValues(3, values), 1);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getGeneralDetails(), this.discoModel.getRowIndexByValues(3, values), 5);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getDetails(), this.discoModel.getRowIndexByValues(3, values), 6);
                                this.runningJobs.get(jobId).getSysout();
                                this.runningJobs.get(jobId).getLog();
                            } else {
                                this.discoModel.getModel(3).setValueAt("2", this.discoModel.getRowIndexByValues(3, values), 1);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getGeneralDetails(), this.discoModel.getRowIndexByValues(3, values), 5);
                                this.discoModel.getModel(3).setValueAt(this.runningJobs.get(jobId).getDetails(), this.discoModel.getRowIndexByValues(3, values), 6);
                                this.runningJobs.get(jobId).getSysout();
                                this.runningJobs.get(jobId).getLog();
                            }
                        } else {
                            this.runningJobs.get(jobId).setOK();
                        }
                        this.completedJobs.put(jobId, this.runningJobs.remove(jobId));
                        continue;
                    }
                    ConversionLogger.getLogger().info("Job orederid=" + Integer.toString(lineOid, 36) + " Still executing");
                    if (this.runningJobs.get(jobId).isMonitored()) {
                        this.discoModel.getModel(3).setValueAt("0", this.discoModel.getRowIndexByValues(3, values), 1);
                    }
                    this.runningJobs.get(jobId).setEXEC();
                }
                freader.close();
                for (Integer tmpId : this.runningJobs.keySet()) {
                    ConversionLogger.getLogger().info("Peeking at Job orederid=" + this.runningJobs.get(tmpId).getOid());
                    if (!this.runningJobs.get(tmpId).getState().equals((Object)DiscoveryJob.JobStateEnum.NOTOK)) continue;
                    if (this.runningJobs.get(tmpId).isMonitored()) {
                        values.put(2, this.runningJobs.get(tmpId).getNode());
                        values.put(3, this.runningJobs.get(tmpId).getOwner());
                        this.discoModel.getModel(3).setValueAt("2", this.discoModel.getRowIndexByValues(3, values), 1);
                        this.discoModel.getModel(3).setValueAt(this.runningJobs.get(tmpId).getGeneralDetails(), this.discoModel.getRowIndexByValues(3, values), 5);
                        this.discoModel.getModel(3).setValueAt(this.runningJobs.get(tmpId).getDetails(), this.discoModel.getRowIndexByValues(3, values), 6);
                        ConversionLogger.getLogger().info("Job orederid=" + this.runningJobs.get(tmpId).getOid() + " Forced to NOTOK");
                    }
                    this.completedJobs.put(tmpId, this.runningJobs.remove(tmpId));
                }
            } else {
                toRet = false;
            }
            ConversionLogger.getLogger().info("Command returned " + Integer.valueOf(exCmd.getExitValue()));
        }
        catch (InterruptedException e) {
            this.lastFailureDetails.append(e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
            toRet = false;
        }
        catch (IOException e) {
            this.lastFailureDetails.append(e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
            toRet = false;
        }
        ConversionLogger.getLogger().info("Refresh " + (toRet ? "successful" : "failed"));
        return toRet;
    }

    public Object[][] getAgentList(DiscoveryJob dJob) {
        Object[][] toRet = null;
        try {
            BufferedReader sysout = new BufferedReader(new InputStreamReader(dJob.getSysout()));
            HashMap<String, ArrayList<String>> ownersMap = this.fetchOwners(sysout);
            ArrayList<HashMap<String, String>> agentsMap = this.fetchAgents(sysout);
            ArrayList mergedTable = new ArrayList();
            for (HashMap<String, String> node : agentsMap) {
                if (node.get("PLATFORM").toUpperCase().contains("UNIX") && !Params.instance().getVendorName().equals("CRON") || node.get("PLATFORM").toUpperCase().contains("WINDOWS") && !Params.instance().getVendorName().equals("MS")) continue;
                ArrayList<Object> toAdd = new ArrayList<Object>();
                toAdd.add(Integer.toString(mergedTable.size() + 1));
                toAdd.add(new Boolean(node.get("STATUS").equals("V")));
                toAdd.add(this.convetToFullStatus(node.get("STATUS")));
                toAdd.add(node.get("NODE"));
                toAdd.add(node.get("PLATFORM"));
                if (ownersMap == null || !ownersMap.containsKey(node.get("NODE")) || node.get("PLATFORM").toUpperCase().contains("WINDOWS")) {
                    toAdd.add(5, "ALL");
                    toAdd.add(this.getCollectionStatus(Params.instance().getVendorName(), node.get("NODE"), null));
                    Boolean isChecked = true;
                    if (this.getCollectionStatus(Params.instance().getVendorName(), node.get("NODE"), null).equals(DiscoveryResults.AGENT_RETRIEVE_STATUS_COLLECTED) || !node.get("STATUS").equals("V") || node.get("PLATFORM").trim().isEmpty()) {
                        isChecked = Boolean.FALSE;
                    }
                    toAdd.set(1, isChecked);
                    mergedTable.add(toAdd);
                    continue;
                }
                for (String owner : ownersMap.get(node.get("NODE"))) {
                    ArrayList<Object> tmpArr = new ArrayList<Object>(toAdd);
                    tmpArr.add(5, owner);
                    tmpArr.set(0, Integer.toString(mergedTable.size() + 1));
                    tmpArr.add(this.getCollectionStatus(Params.instance().getVendorName(), node.get("NODE"), owner));
                    Boolean isChecked = true;
                    if (this.getCollectionStatus(Params.instance().getVendorName(), node.get("NODE"), null).equals("Data collected") || !node.get("STATUS").equals("V") || node.get("PLATFORM").trim().isEmpty()) {
                        isChecked = Boolean.FALSE;
                    }
                    tmpArr.set(1, isChecked);
                    mergedTable.add(tmpArr);
                }
            }
            toRet = new Object[mergedTable.size()][7];
            for (int i = 0; i < toRet.length; ++i) {
                Object[] tmpArr2 = new Object[7];
                tmpArr2 = ((ArrayList)mergedTable.get(i)).toArray(tmpArr2);
                toRet[i] = tmpArr2;
            }
            sysout.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return toRet;
    }

    private String convetToFullStatus(String value) {
        if (value.equalsIgnoreCase("V")) {
            return DiscoveryResults.AGENT_STATUS_AVAILABLE;
        }
        if (value.equalsIgnoreCase("P")) {
            return DiscoveryResults.AGENT_STATUS_UPGRADING;
        }
        if (value.equalsIgnoreCase("U")) {
            return DiscoveryResults.AGENT_STATUS_UNAVAILABLE;
        }
        if (value.equalsIgnoreCase("D")) {
            return DiscoveryResults.AGENT_STATUS_DISABLED;
        }
        if (value.equalsIgnoreCase("R")) {
            return DiscoveryResults.AGENT_STATUS_DISCOVERING;
        }
        if (value.equalsIgnoreCase("E")) {
            return DiscoveryResults.AGENT_STATUS_ERASE;
        }
        return "";
    }

    private ArrayList<HashMap<String, String>> fetchAgents(BufferedReader sysout) throws IOException {
        String line;
        ArrayList toRet = null;
        while ((line = sysout.readLine()) != null) {
            String[] lineArr;
            if (line.contains("Fetching Agents")) {
                toRet = new ArrayList();
            }
            if (toRet == null || !line.contains("@#@") || !line.matches("^\\s*PLATFORM=.*") || (lineArr = line.split("\\s*@#@\\s*")) == null || lineArr.length < 5) continue;
            HashMap<String, String> lineHash = new HashMap<String, String>();
            for (int i = 0; i < lineArr.length; ++i) {
                String[] tmpArr = lineArr[i].split("=", 2);
                lineHash.put(tmpArr[0].trim(), tmpArr[1].trim());
            }
            ConversionLogger.getLogger().info("Found agent:\n\t" + lineHash.toString());
            toRet.add(lineHash);
        }
        return toRet;
    }

    private HashMap<String, ArrayList<String>> fetchOwners(BufferedReader sysout) throws IOException {
        String[] tmpArr;
        String line;
        HashMap toRet = null;
        while ((line = sysout.readLine()) != null && !line.contains("Fetching owners")) {
        }
        while ((line = sysout.readLine()) != null && !line.matches("^-+.*")) {
        }
        while ((line = sysout.readLine()) != null && !line.matches("^\\S+") && (tmpArr = line.split("\\s+", 3)).length >= 3 && !line.matches("found\\.\\s*$")) {
            if (toRet == null) {
                toRet = new HashMap();
            }
            if (!toRet.containsKey(tmpArr[1])) {
                toRet.put(tmpArr[1], new ArrayList());
            }
            ((ArrayList)toRet.get(tmpArr[1])).add(tmpArr[0]);
            ConversionLogger.getLogger().info(String.format("Mapped owner %s in node %s", tmpArr[0], tmpArr[1]));
        }
        return toRet;
    }

    private String getCollectionStatus(String vendor, String node, String owner) {
        String toRet = "No data";
        if (vendor.equals("CRON")) {
            if (owner == null) {
                File testDir = new File(Globs.TEMP_IMPORT_DIR);
                File[] contents = testDir.listFiles();
                if (contents != null) {
                    for (int i = 0; i < contents.length; ++i) {
                        if (!contents[i].getName().toLowerCase().endsWith("%" + node + ".txt")) continue;
                        toRet = "Data collected";
                        break;
                    }
                }
            } else {
                File testFile = new File(String.format("%s%%%s.txt", Params.instance().getDatasourcePath() + Globs.DIRSEP + owner, node));
                if (testFile.isFile()) {
                    toRet = "Data collected";
                }
            }
        } else {
            String baseFname = Params.instance().getDatasourcePath() + Globs.DIRSEP + node + ".";
            File testFile1 = new File(baseFname + "xml");
            File testFile2 = new File(baseFname + "csv");
            if (testFile1.isFile() || testFile2.isFile()) {
                toRet = "Data collected";
            }
        }
        return toRet;
    }

    public boolean sysout2datasource(DiscoveryJob job) {
        boolean success;
        ConversionLogger.getLogger().info("Adding <" + job.getSysoutFileFullPath() + "> to datasource");
        try {
            success = Params.instance().getVendorName().equalsIgnoreCase("Cron") ? this.sysout2cronDatasource(job) : this.sysout2MSSchedDatasource(job);
        }
        catch (IOException e) {
            success = false;
            ConversionLogger.getLogger().severe("Caught IOException: " + e.getMessage());
            ExceptionHandler.writeToExceptionFile(e);
        }
        if (success) {
            ConversionLogger.getLogger().info("Added successfully");
        } else {
            ConversionLogger.getLogger().info("Failed to add <" + job.getSysoutFileFullPath() + "> to datasource");
        }
        return success;
    }

    private boolean sysout2cronDatasource(DiscoveryJob job) throws IOException {
        String line;
        String machine = job.getNode();
        String user = null;
        BufferedReader fReader = new BufferedReader(new InputStreamReader(job.getSysout()));
        Writer fWriter = null;
        File dataFile = null;
        Pattern linePat = Pattern.compile("^getting jobs for (\\S+/)?(\\S+)");
        boolean success = false;
        StringBuilder message = new StringBuilder();
        StringBuilder currentDefs = new StringBuilder();
        boolean deleteDataFile = false;
        String messageDetails = null;
        while ((line = fReader.readLine()) != null && !line.equals("getting cron defs")) {
        }
        while ((line = fReader.readLine()) != null) {
            Matcher lineMatcher = linePat.matcher(line);
            if (lineMatcher.matches()) {
                if (currentDefs.length() > 0) {
                    fWriter.write(currentDefs.toString());
                    message.append(String.format(TextManager.instance().get("DISCOVERY_MONITOR_MSG_RETRIVED_DEFINITIONS_FOR") + " %s@%s\n", user, machine));
                    success = true;
                    currentDefs.delete(0, currentDefs.length());
                } else if (dataFile != null) {
                    deleteDataFile = true;
                    message.append(String.format(TextManager.instance().get("DISCOVERY_MONITOR_MSG_FAILED_TO_RETRIVE_DEFINITIONS_FOR") + " %s@%s\n", user, machine));
                }
                if (messageDetails != null && !messageDetails.isEmpty()) {
                    message.append(messageDetails);
                    messageDetails = null;
                }
                user = lineMatcher.group(2);
                if (fWriter != null) {
                    ((BufferedWriter)fWriter).close();
                }
                if (deleteDataFile && dataFile != null && dataFile.isFile()) {
                    deleteDataFile = false;
                    dataFile.delete();
                }
                dataFile = new File(Globs.TEMP_IMPORT_DIR + String.format("%s%%%s.txt", user, machine));
                if (!new File(Globs.TEMP_IMPORT_DIR).exists()) continue;
                dataFile.createNewFile();
                fWriter = new BufferedWriter(new FileWriter(dataFile));
                continue;
            }
            if (line.matches("^\\s*crontab returned [0-9].*")) {
                if (line.matches(".*crontab returned 0+\\s*$")) {
                    success = true;
                    continue;
                }
                currentDefs.insert(0, '\t');
                currentDefs.append(line);
                messageDetails = currentDefs.toString().replace("\n", "\n\t");
                currentDefs.delete(0, currentDefs.length());
                deleteDataFile = true;
                continue;
            }
            if (line.equals("got cron defs")) {
                success = true;
                if (currentDefs.length() > 0) {
                    message.append(String.format(TextManager.instance().get("DISCOVERY_MONITOR_MSG_RETRIVED_DEFINITIONS_FOR") + " %s@%s\n", user, machine));
                } else {
                    message.append(String.format(TextManager.instance().get("DISCOVERY_MONITOR_MSG_FAILED_TO_RETRIVE_DEFINITIONS_FOR") + " %s@%s\n", user, machine));
                    deleteDataFile = true;
                }
                if (messageDetails == null || messageDetails.isEmpty()) break;
                message.append(messageDetails);
                messageDetails = null;
                break;
            }
            if (line.matches("^\\s*\\+.*") || line.trim().isEmpty() || user == null) continue;
            currentDefs.append(line).append('\n');
        }
        fReader.close();
        if (success) {
            job.setOK(message.toString());
        } else {
            job.setNOTOK(message.toString());
        }
        if (currentDefs.length() > 0 && fWriter != null) {
            fWriter.write(currentDefs.toString());
        }
        if (fWriter != null) {
            ((BufferedWriter)fWriter).close();
        }
        if (deleteDataFile && dataFile != null && dataFile.isFile()) {
            dataFile.delete();
        }
        return success;
    }

    private boolean sysout2MSSchedDatasource(DiscoveryJob job) throws IOException {
        boolean success;
        String line;
        String machine = job.getNode();
        BufferedReader fReader = new BufferedReader(new InputStreamReader(job.getSysout()));
        BufferedWriter fWriter = null;
        File dataFile = null;
        boolean isXML = true;
        while ((line = fReader.readLine()) != null) {
            if (line.matches("\\s*sShortDate\\s+REG_SZ\\s+\\S+.*")) {
                String[] tmpArr = line.trim().split("\\s+", 3);
                if (this.dateFormatMap == null) {
                    this.dateFormatMap = new Properties();
                }
                this.dateFormatMap.setProperty(machine, tmpArr[2]);
            }
            if (line.matches("\\s*<\\s*Tasks\\s*>")) {
                dataFile = new File(Globs.TEMP_IMPORT_DIR + String.format("%s.xml", machine));
                fWriter = new BufferedWriter(new FileWriter(dataFile));
                isXML = true;
                fWriter.write(line + "\n");
                break;
            }
            if (!line.contains("schtasks /Query /V /FO CSV")) continue;
            dataFile = new File(Globs.TEMP_IMPORT_DIR + String.format("%s.csv", machine));
            fWriter = new BufferedWriter(new FileWriter(dataFile));
            isXML = false;
            break;
        }
        while ((line = fReader.readLine()) != null && (isXML || !line.trim().endsWith("end of CSV tasks"))) {
            fWriter.write(line + "\n");
            if (!isXML || !line.matches("\\s*</\\s*Tasks\\s*>")) continue;
        }
        fReader.close();
        fWriter.close();
        boolean bl = success = line != null;
        if (success) {
            job.setOK(TextManager.instance().get("DISCOVERY_MONITOR_MSG_SUCCESSFULLY_RETRIVED_DEFINTIONS_FROM") + " " + machine + "\n");
        } else {
            job.setNOTOK(TextManager.instance().get("DISCOVERY_MONITOR_MSG_SUCCESSFULLY_RETRIVED_DEFINTIONS_FROM") + " " + machine + "\n\t" + TextManager.instance().get("DISCOVERY_MONITOR_MSG_UNEXPECTED_EOF"));
            dataFile.delete();
        }
        return success;
    }
}

