/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.exceptions.ConvertorException;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.discovery.DiscoveryMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DiscoveryJob
implements Runnable {
    private String orderid = null;
    private String cmdline = null;
    private String script = null;
    private String description = null;
    private String owner = null;
    private String node = null;
    private String jobName = "";
    private JobStateEnum state = JobStateEnum.NOT_SUBMITTED;
    private boolean isMonintored = true;
    private static Integer nextId = 0;
    private static String agentExePath = null;
    private Integer id;
    private LinkedHashMap<String, String> autoedits;
    private File sysoutFile;
    private File logFile;
    private StringBuilder generalDetails = new StringBuilder();
    private StringBuilder details = new StringBuilder();

    public DiscoveryJob(String command, String description, String owner, String node, boolean isScript, String jobName) {
        if (isScript) {
            this.script = command;
        } else {
            this.cmdline = command;
        }
        this.description = description;
        this.jobName = jobName;
        this.owner = owner;
        this.node = node;
        Integer n = nextId;
        nextId = nextId + 1;
        this.id = n;
        if (agentExePath == null) {
            agentExePath = DiscoveryJob.getAgentExepath();
        }
    }

    public static boolean isAgentExist() {
        return DiscoveryJob.getAgentExepath() != null;
    }

    public static String getAgentExepath() {
        ExternalCommand extCmd = new ExternalCommand.Builder("reg QUERY \"HKEY_LOCAL_MACHINE\\SOFTWARE\\BMC Software\\Control-M/Agent\\CONFIG\" /v AGENT_DIR").waitFor(true).isScript(true).build();
        extCmd.start();
        if (extCmd.getExitValue() != 0) {
            return null;
        }
        return extCmd.getOutputStdOut().split("REG_SZ")[1].trim() + "EXE\\";
    }

    public static String getPrimaryServer() {
        ExternalCommand extCmd = new ExternalCommand.Builder("reg QUERY \"HKEY_LOCAL_MACHINE\\SOFTWARE\\BMC Software\\Control-M/Agent\\CONFIG\" /v CTMSHOST").waitFor(true).isScript(true).build();
        extCmd.start();
        if (extCmd.getExitValue() != 0) {
            return null;
        }
        String[] tmpArr = extCmd.getOutputStdOut().split("REG_SZ");
        return tmpArr[1].trim();
    }

    public void setAutoedit(String name, String value) {
        if (this.autoedits == null) {
            this.autoedits = new LinkedHashMap();
        }
        this.autoedits.put(name, value);
    }

    public void setAutoedit(Map<String, String> vars) {
        if (this.autoedits == null) {
            this.autoedits = new LinkedHashMap();
        }
        this.autoedits.putAll(vars);
    }

    @Override
    public void run() {
    }

    public boolean isMonitored() {
        return this.isMonintored;
    }

    public void setMonitored(boolean desired) {
        this.isMonintored = desired;
    }

    public void submit() throws IOException, InterruptedException, ConvertorException {
        File tmpOutput = File.createTempFile("ctmcreate_output_", null, new File(Globs.TEMP_DIR));
        String redirToFile = "> \"" + tmpOutput.getAbsolutePath() + "\"";
        String redirErrToOut = "2>&1";
        StringBuilder ctmcreateCmd = new StringBuilder("\"").append(agentExePath).append("ctmcreate").append("\"");
        HashMap<String, Object> cmdArgs = new HashMap<String, Object>();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("ctmcreate");
        Properties tmpProperties = DiscoveryMonitor.getDiscoJobAttrs();
        String application = tmpProperties.getProperty("APPLICATION");
        String group = tmpProperties.getProperty("GROUP");
        String table = tmpProperties.getProperty("TABLE");
        if (this.script != null) {
            cmdArgs.put("TASKTYPE", "Job");
            cmdArgs.put("MEMNAME", ".bat");
            cmdArgs.put("JOBNAME", this.jobName);
            cmdArgs.put("MEMLIB", "EMBEDDED_SCRIPT");
            cmdArgs.put("OWNER", this.owner);
            cmdArgs.put("NODEGRP", this.node);
            cmdArgs.put("GROUP", group);
            cmdArgs.put("APPLICATION", application);
            cmdArgs.put("TABLE", table);
            cmdArgs.put("DESCRIPTION", this.description);
            cmdArgs.put("EMBEDDED_SCRIPT", "\"" + this.script + "\"");
        } else {
            cmdArgs.put("JOBNAME", this.jobName);
            cmdArgs.put("TASKTYPE", "Command");
            cmdArgs.put("CMDLINE", "\"" + this.cmdline + "\"");
            cmdArgs.put("OWNER", this.owner);
            cmdArgs.put("NODEGRP", this.node);
            cmdArgs.put("GROUP", group);
            cmdArgs.put("APPLICATION", application);
            cmdArgs.put("TABLE", table);
            cmdArgs.put("DESCRIPTION", this.description);
        }
        for (String arg : cmdArgs.keySet()) {
            if (cmdArgs.get(arg) == null || ((String)cmdArgs.get(arg)).isEmpty()) continue;
            ctmcreateCmd.append(" -").append(arg).append(" ").append((String)cmdArgs.get(arg));
            cmd.add("-" + arg);
            cmd.add((String)cmdArgs.get(arg));
        }
        if (this.autoedits != null && this.autoedits.keySet().size() > 0) {
            for (String varName : this.autoedits.keySet()) {
                ctmcreateCmd.append(" -AUTOEDIT %%").append(varName).append(" \"").append(this.autoedits.get(varName)).append("\"");
                cmd.add("-AUTOEDIT");
                cmd.add("%%" + varName);
                cmd.add(this.autoedits.get(varName));
            }
        }
        ctmcreateCmd.append(" ").append(redirToFile).append(" ").append(redirErrToOut);
        ConversionLogger.getLogger().info(ctmcreateCmd.toString());
        ConversionLogger.getLogger().info("Output file: " + String.valueOf(tmpOutput));
        ExternalCommand extCmd = new ExternalCommand.Builder(cmd).workingDirectory(agentExePath).redirectErrToOut(true).redirectOutputToFile(tmpOutput).waitFor(true).isScript(false).build();
        extCmd.start();
        if (extCmd.getExitValue() != 0) {
            this.generalDetails.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_FAILED_TO_SUBMIT") + "\n");
            this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_COMMAND_LINE") + ": ").append(ctmcreateCmd.toString()).append("\n").append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_OUTPUT") + ": ").append(this.file2String(tmpOutput));
            this.setNOTOK();
            ConversionLogger.getLogger().severe("Failed submission");
            ConversionLogger.getLogger().severe("\tOutput=<" + this.file2String(tmpOutput) + ">");
        } else {
            Matcher oidMatcher = Pattern.compile(".*orderid:([0-9a-z]{5,})\\(.*").matcher(this.file2String(tmpOutput).replaceAll("[\r\n]+", " "));
            if (oidMatcher.matches() && oidMatcher.group(1) != null && !oidMatcher.group(1).isEmpty()) {
                this.orderid = oidMatcher.group(1);
                this.state = JobStateEnum.SUBMITTED;
                ConversionLogger.getLogger().info("Submitted: " + this.orderid);
                this.generalDetails.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_ORDER_ID") + ": ").append(this.orderid).append("\n");
            } else {
                this.generalDetails.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_FAILED_TO_SUBMIT_UNABLE_TO_READ_OREDER_ID") + "\n");
                this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_COMMAND_LINE") + ": ").append(ctmcreateCmd.toString()).append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_OUTPUT") + ": ").append(this.file2String(tmpOutput));
                ConversionLogger.getLogger().info("Failed to read orderid");
                this.setNOTOK();
            }
        }
    }

    public String getSysoutFileFullPath() {
        return this.sysoutFile == null ? "" : this.sysoutFile.getAbsolutePath();
    }

    public InputStream getSysout() {
        InputStream inputStream = null;
        if (this.sysoutFile == null) {
            if (this.orderid != null) {
                try {
                    this.sysoutFile = File.createTempFile(this.orderid + "_SYSOUT_", null, new File(Globs.TEMP_DIR));
                    String cmdline = "cmd /c \"\"" + DiscoveryJob.getAgentExepath() + "ctmpsm\" -listsysout " + this.orderid + " > \"" + String.valueOf(this.sysoutFile.getAbsoluteFile()) + "\" 2>&1\"";
                    ConversionLogger.getLogger().info("Temp file: " + this.sysoutFile.getAbsolutePath());
                    ConversionLogger.getLogger().info("Command line: " + cmdline);
                    ExternalCommand extCmd = new ExternalCommand.Builder("ctmpsm", "-listsysout", this.orderid).workingDirectory(DiscoveryJob.getAgentExepath()).redirectOutputToFile(this.sysoutFile).redirectErrToOut(true).isScript(false).waitFor(true).build();
                    extCmd.startThrows();
                    if (extCmd.getExitValue() == 0) {
                        inputStream = Files.newInputStream(Paths.get(this.sysoutFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
                    } else {
                        this.sysoutFile = null;
                    }
                    ConversionLogger.getLogger().info("Exit code: " + extCmd.getExitValue());
                }
                catch (IOException e) {
                    ConversionLogger.getLogger().info("Caught IOException: " + e.getMessage());
                    this.sysoutFile = null;
                    ExceptionHandler.writeToExceptionFile(e);
                }
                catch (InterruptedException e) {
                    ConversionLogger.getLogger().info("Caught InterruptedException: " + e.getMessage());
                    this.sysoutFile = null;
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
        } else {
            try {
                inputStream = Files.newInputStream(Paths.get(this.sysoutFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile(e);
                return null;
            }
        }
        return inputStream;
    }

    public BufferedReader getLogAsStream() throws FileNotFoundException {
        BufferedReader fReader = null;
        File logFile = this.getLog();
        if (logFile != null) {
            fReader = new BufferedReader(new FileReader(logFile));
        }
        return fReader;
    }

    private String file2String(File file) throws IOException {
        String tmp;
        BufferedReader freader = new BufferedReader(new FileReader(file));
        StringBuilder contents = new StringBuilder();
        while ((tmp = freader.readLine()) != null) {
            contents.append(tmp).append('\n');
        }
        freader.close();
        return contents.toString();
    }

    public String getOid() {
        return this.orderid;
    }

    public void setNOTOK() {
        this.setNOTOK(null);
    }

    public void setNOTOK(String message) {
        String extendedMessage;
        this.logAndOutputToDetails();
        Object failureMesage = TextManager.instance().get("DISCOVERY_JOB_DETAILS_FAILED");
        if (message != null && !message.isEmpty()) {
            failureMesage = (String)failureMesage + ":\n" + message + "\n";
        }
        if ((extendedMessage = this.checkLogForAgentMessage()) != null) {
            failureMesage = (String)failureMesage + extendedMessage + "\n";
        }
        this.generalDetails.insert(0, (String)failureMesage);
        this.state = JobStateEnum.NOTOK;
    }

    private String checkLogForAgentMessage() {
        String msgFromLog = null;
        boolean last = false;
        try {
            BufferedReader joblogStream = this.getLogAsStream();
            if (joblogStream != null) {
                String logLine;
                while ((logLine = joblogStream.readLine()) != null) {
                    if ((logLine = logLine.replaceAll("\\s*\\|\\s*$", "")).lastIndexOf(124) <= 0) continue;
                    msgFromLog = logLine.substring(logLine.lastIndexOf(124) + 1);
                    if (last) break;
                    if (!msgFromLog.toLowerCase().contains("message from agent follows")) continue;
                    last = true;
                }
                if (logLine == null) {
                    msgFromLog = null;
                }
                joblogStream.close();
            } else {
                msgFromLog = "Failed to get job log";
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(String.format("Caught exeception %s: %s", e.getClass().toString(), e.getMessage()));
            ExceptionHandler.writeToExceptionFile(e);
        }
        return msgFromLog;
    }

    public void setOK() {
        this.setOK(null);
    }

    public void setOK(String message) {
        Object successMesage = TextManager.instance().get("DISCOVERY_JOB_DETAILS_COMLETED_SUCCESSFULLY");
        if (message != null && !message.isEmpty()) {
            successMesage = (String)successMesage + ":\n" + message + "\n";
        }
        this.generalDetails.insert(0, (String)successMesage);
        this.logAndOutputToDetails();
        this.state = JobStateEnum.OK;
    }

    public void setEXEC() {
        this.state = JobStateEnum.EXECUTING;
    }

    private void logAndOutputToDetails() {
        String line;
        BufferedReader reader;
        this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_JOB_LOG") + ": ").append("\n");
        try {
            reader = this.getLogAsStream();
            if (reader != null) {
                line = "";
                while ((line = reader.readLine()) != null) {
                    this.details.append(line).append("\n");
                }
            }
        }
        catch (IOException e) {
            this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_FAILED_TO_READ_LOG_FROM") + " - \"").append(this.getLog()).append("\"\n");
            ExceptionHandler.writeToExceptionFile(e);
        }
        if (!this.isFailedSubmit()) {
            this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_JOB_OUTPUT") + ": ").append("\n");
            try {
                reader = new BufferedReader(new InputStreamReader(this.getSysout()));
                if (reader != null) {
                    line = "";
                    while ((line = reader.readLine()) != null) {
                        this.details.append(line).append("\n");
                    }
                }
            }
            catch (IOException e) {
                this.details.append(TextManager.instance().get("DISCOVERY_JOB_DETAILS_FAILED_TO_READ_OUTPUT_FROM") + " - \"").append(this.getSysout()).append("\"\n");
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
    }

    public String getState() {
        return this.state.toString();
    }

    public String getNode() {
        return this.node;
    }

    public String getOwner() {
        return this.owner;
    }

    public Integer getId() {
        return this.id;
    }

    public File getLog() {
        if (this.logFile == null) {
            String exePath = DiscoveryJob.getAgentExepath().toString().replaceAll("^\"", "").replaceAll("\"$", "");
            File ctmlogExe = new File(exePath.toString() + "ctmlog.exe");
            ConversionLogger.getLogger().info(String.format("ctmlog full path:<%s>", ctmlogExe.getAbsolutePath()));
            if (!ctmlogExe.exists()) {
                File source = new File(exePath.toString() + "ctmpsm.exe");
                ConversionLogger.getLogger().info(ctmlogExe.getAbsolutePath() + " not found copying from " + source.getAbsolutePath());
                try {
                    GlobalFunctions.copy(source, ctmlogExe);
                }
                catch (IOException e) {
                    ConversionLogger.getLogger().info("Caught IOException <" + e.getMessage() + "> when copying from " + source.getAbsolutePath() + " to " + ctmlogExe.getAbsolutePath());
                    if (e.getMessage().toLowerCase().contains("access is denied")) {
                        ctmlogExe = new File(System.getenv("TEMP") + Globs.DIRSEP + "ctmlog.exe");
                        if (!ctmlogExe.isFile()) {
                            try {
                                GlobalFunctions.copy(source, ctmlogExe);
                            }
                            catch (IOException e2) {
                                ConversionLogger.getLogger().info("Caught IOException <" + e2.getMessage() + "> when copying from " + source.getAbsolutePath() + " to " + ctmlogExe.getAbsolutePath());
                                ExceptionHandler.writeToExceptionFile(e2);
                            }
                        }
                    }
                    ExceptionHandler.writeToExceptionFile(e);
                }
                Params.instance().addToCleanup(ctmlogExe);
            }
            if (this.orderid != null && ctmlogExe.isFile()) {
                try {
                    this.logFile = File.createTempFile(this.orderid + "_LOG_", null, new File(Globs.TEMP_DIR));
                    ConversionLogger.getLogger().info("Temp joblog: " + this.logFile.getAbsolutePath());
                    String cmdline = String.format("cmd.exe /c \"\"%s\" listord %s \"*\" > \"%s\" 2>&1\"", ctmlogExe.getAbsolutePath(), this.orderid, this.logFile.getAbsolutePath());
                    ConversionLogger.getLogger().info("Command line: " + cmdline);
                    ExternalCommand extCmd = new ExternalCommand.Builder(ctmlogExe.getAbsolutePath(), "listord", this.orderid, "*").redirectOutputToFile(this.logFile.getAbsolutePath()).redirectErrToOut(true).isScript(false).waitFor(true).build();
                    extCmd.startThrows();
                    if (extCmd.getExitValue() != 0) {
                        this.logFile = null;
                    }
                    ConversionLogger.getLogger().info("Exit code: " + extCmd.getExitValue());
                }
                catch (IOException e) {
                    this.logFile = null;
                    ConversionLogger.getLogger().severe("Caught IOException: " + e.getMessage());
                    ExceptionHandler.writeToExceptionFile(e);
                }
                catch (InterruptedException e) {
                    ConversionLogger.getLogger().severe("Caught InterruptedException: " + e.getMessage());
                    this.logFile = null;
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
        }
        return this.logFile;
    }

    public String getGeneralDetails() {
        return this.generalDetails.toString();
    }

    public void addToGeneralDetails(boolean addToStart, String toAdd) {
        if (addToStart) {
            this.generalDetails.insert(0, toAdd);
        } else {
            this.generalDetails.append(toAdd);
        }
    }

    public String getDetails() {
        return this.details.toString();
    }

    public void addToDetails(boolean addToStart, String toAdd) {
        if (addToStart) {
            this.details.insert(0, toAdd);
        } else {
            this.details.append(toAdd);
        }
    }

    public boolean isFailedSubmit() {
        boolean failedSubmit = false;
        try {
            BufferedReader logStream = this.getLogAsStream();
            if (logStream == null) {
                failedSubmit = true;
                ConversionLogger.getLogger().info("Failed to retrieve log assuming failedSubmit=true");
            } else {
                String line;
                while ((line = logStream.readLine()) != null) {
                    if (!line.toUpperCase().contains("FAILED TO SUBMIT JOB")) continue;
                    ConversionLogger.getLogger().info(String.format("Found line %s Setting failedSubmit=true", line));
                    failedSubmit = true;
                    break;
                }
                logStream.close();
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(String.format("Caught exeception %s: %s, assuming failedSubmit=false", e.getClass().toString(), e.getMessage()));
            ExceptionHandler.writeToExceptionFile(e);
        }
        return failedSubmit;
    }

    public static enum JobStateEnum {
        NOT_SUBMITTED,
        SUBMITTED,
        EXECUTING,
        OK,
        NOTOK;

    }
}

