/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.bmcdiscovery;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class DiscoveryExceptionInterpreter {
    Map<String, String> code2errorMessageMap;
    static final String CONNECTION_REFUSED_CODE = "Connection refused";
    static final String CONNECTION_REFUSED_ERROR_MESSAGE = "Failed to connect to the BMC Discovery Server. Please ensure that the BMC Discovery Server host is configured to \"HTTPS Enabled\".\n";
    static final String PERMISSION_DENAID_ERROR_MESSAGE = "Failed to retrieve data from the BMC Discovery Server. Please ensure that the user has api-access permission.\n";
    static final String PERMISSION_DENIAD_STATUS_CODE = "403";
    static final String CONNECT_RETRY_INSTRUCTIONS = "Click \"Load data\" button to reconnect to BMC Discovery again.";
    static final String UNKNOWN_HOST_EXCEPTION = "UnknownHostException";
    static final String HOSTNAME_ERROR_MESSAGE = "Failed to connect to the BMC Discovery Server. Please ensure that the host name is correct.\n";
    static final String UNAUTOHARIZED_STATUS_CODE = "401";
    static final String USER_NAME_OR_PASSWORD_ERROR_MESSAGE = "Failed to connect to the BMC Discovery Server. Please ensure that the username and password are correct.\n";
    public static final String DEFAULT_ERROR_MESSAGE = "Failed to retrieve data from the BMC Discovery Server. Please contact BMC Support for assistance.";
    static final String EMPTY_RESPONSE_ERROR_CRON = "No Cron job definitions were found by BMC Discovery.";
    public static final String EMPTY_RESPONSE_ERROR_MS = "No MS Task Scheduler job definitions were found by BMC Discovery.";
    public static final String FAILED_TO_PARSE_RESPONSE_CRON = "Failed to parse the Cron data that was retrieved from BMC Discovery Server. Please contact BMC Support for further assistance.";

    public DiscoveryExceptionInterpreter() {
        this.initCodeToMessageMap();
    }

    private void initCodeToMessageMap() {
        this.code2errorMessageMap = new LinkedHashMap<String, String>();
        this.code2errorMessageMap.put(UNKNOWN_HOST_EXCEPTION, "Failed to connect to the BMC Discovery Server. Please ensure that the host name is correct.\nClick \"Load data\" button to reconnect to BMC Discovery again.");
        this.code2errorMessageMap.put(CONNECTION_REFUSED_CODE, CONNECTION_REFUSED_ERROR_MESSAGE);
        this.code2errorMessageMap.put(UNAUTOHARIZED_STATUS_CODE, "Failed to connect to the BMC Discovery Server. Please ensure that the username and password are correct.\nClick \"Load data\" button to reconnect to BMC Discovery again.");
        this.code2errorMessageMap.put(PERMISSION_DENIAD_STATUS_CODE, PERMISSION_DENAID_ERROR_MESSAGE);
        this.code2errorMessageMap.put(EMPTY_RESPONSE_ERROR_CRON, EMPTY_RESPONSE_ERROR_CRON);
        this.code2errorMessageMap.put(EMPTY_RESPONSE_ERROR_MS, EMPTY_RESPONSE_ERROR_MS);
        this.code2errorMessageMap.put(FAILED_TO_PARSE_RESPONSE_CRON, FAILED_TO_PARSE_RESPONSE_CRON);
    }

    public String interpretException(Throwable e) {
        String cause = e.toString();
        Optional<String> statusCode = this.code2errorMessageMap.keySet().stream().filter(key -> cause.contains((CharSequence)key)).findFirst();
        return statusCode.isPresent() ? this.code2errorMessageMap.get(statusCode.get()) : DEFAULT_ERROR_MESSAGE;
    }
}

