/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.vendors.DataTypeProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/exposed/sql/vendors/SQLServerDataTypeProvider;", "Lorg/jetbrains/exposed/sql/vendors/DataTypeProvider;", "()V", "binaryType", "", "blobType", "booleanToStatementString", "bool", "", "booleanType", "dateTimeType", "integerAutoincType", "longAutoincType", "textType", "uuidToDB", "", "value", "Ljava/util/UUID;", "uuidType", "exposed-core"})
public final class SQLServerDataTypeProvider
extends DataTypeProvider {
    @NotNull
    public static final SQLServerDataTypeProvider INSTANCE = new SQLServerDataTypeProvider();

    private SQLServerDataTypeProvider() {
    }

    @Override
    @NotNull
    public String integerAutoincType() {
        return "INT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String longAutoincType() {
        return "BIGINT IDENTITY(1,1)";
    }

    @Override
    @NotNull
    public String binaryType() {
        SQLLogKt.getExposedLogger().error("The length of the Binary column is missing.");
        String string = "The length of the Binary column is missing.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public String blobType() {
        return "VARBINARY(MAX)";
    }

    @Override
    @NotNull
    public String uuidType() {
        return "uniqueidentifier";
    }

    @Override
    @NotNull
    public Object uuidToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter(value, "value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue(string, "value.toString()");
        return string;
    }

    @Override
    @NotNull
    public String dateTimeType() {
        return "DATETIME2";
    }

    @Override
    @NotNull
    public String booleanType() {
        return "BIT";
    }

    @Override
    @NotNull
    public String booleanToStatementString(boolean bool) {
        return bool ? "1" : "0";
    }

    @Override
    @NotNull
    public String textType() {
        return "VARCHAR(MAX)";
    }
}

