/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.PostgreSQLDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.PostgreSQLFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J(\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0014J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\u0014\u0010\u000b\u001a\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0016J2\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "createDatabase", "", "name", "createIndexWithType", "table", "columns", "type", "dropDatabase", "isAllowedAsColumnDefault", "", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "nullabilityChanged", "autoIncrementChanged", "defaultChanged", "setSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "Companion", "exposed-core"})
public class PostgreSQLDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String dialectName = "postgresql";

    public PostgreSQLDialect() {
        super(dialectName, PostgreSQLDataTypeProvider.INSTANCE, PostgreSQLFunctionProvider.INSTANCE);
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, boolean nullabilityChanged, boolean autoIncrementChanged, boolean defaultChanged) {
        Intrinsics.checkNotNullParameter(column, "column");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$modifyColumn_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        Transaction tr = TransactionManager.Companion.current();
        $this$modifyColumn_u24lambda_u2d2.append("ALTER TABLE " + tr.identity(column.getTable()) + ' ');
        String colName = tr.identity(column);
        $this$modifyColumn_u24lambda_u2d2.append("ALTER COLUMN " + colName + " TYPE " + column.getColumnType().sqlType());
        if (nullabilityChanged) {
            $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + ' ');
            if (column.getColumnType().getNullable()) {
                $this$modifyColumn_u24lambda_u2d2.append("DROP ");
            } else {
                $this$modifyColumn_u24lambda_u2d2.append("SET ");
            }
            $this$modifyColumn_u24lambda_u2d2.append("NOT NULL");
        }
        if (defaultChanged) {
            boolean bl6;
            StringBuilder stringBuilder2;
            Expression<?> expression = column.getDbDefaultValue$exposed_core();
            if (expression == null) {
                stringBuilder2 = null;
            } else {
                Expression<?> expression2 = expression;
                bl6 = false;
                boolean bl7 = false;
                Expression<?> it = expression2;
                boolean bl8 = false;
                stringBuilder2 = $this$modifyColumn_u24lambda_u2d2.append(", ALTER COLUMN " + colName + " SET DEFAULT " + PostgreSQLDataTypeProvider.INSTANCE.processForDefaultValue(it));
            }
            StringBuilder stringBuilder3 = stringBuilder2;
            if (stringBuilder3 == null) {
                expression = $this$modifyColumn_u24lambda_u2d2;
                boolean bl9 = false;
                bl6 = false;
                Expression<?> $this$modifyColumn_u24lambda_u2d2_u24lambda_u2d1 = expression;
                boolean bl10 = false;
                String cfr_ignored_0 = ",  ALTER COLUMN " + colName + " DROP DEFAULT";
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return CollectionsKt.listOf(string);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("CREATE DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("DROP DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return Intrinsics.stringPlus("SET search_path TO ", schema.getIdentifier());
    }

    @Override
    @NotNull
    protected String createIndexWithType(@NotNull String name, @NotNull String table, @NotNull String columns2, @NotNull String type) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(type, "type");
        return "CREATE INDEX " + name + " ON " + table + " USING " + type + ' ' + columns2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/PostgreSQLDialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

