/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.GroupConcat;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.SortOrder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001a\u0010\t\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u000b0\n\"\u0006\u0012\u0002\b\u00030\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ$\u0010\r\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J9\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00062\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J*\u0010\u001a\u001a\u00020\u0004\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u001b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u001c\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u001d\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u001e\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0016J\u0017\u0010$\u001a\u00020\u00062\b\u0010%\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010&J$\u0010'\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016JN\u0010(\u001a\u00020\u0004\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00160\u000b2\u0006\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0006H\u0016JW\u0010-\u001a\u00020\u00062\u0006\u0010.\u001a\u00020/2\u001e\u00100\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000303\u0012\u0006\u0012\u0004\u0018\u00010402012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00106JW\u0010-\u001a\u00020\u00062\u0006\u00107\u001a\u00020\u00132\u001e\u00100\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u000303\u0012\u0006\u0012\u0004\u0018\u00010402012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u0001052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a2\u0006\u0002\u00108J$\u00109\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u000e2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006:"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleFunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "concat", "", "separator", "", "queryBuilder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "expr", "", "Lorg/jetbrains/exposed/sql/Expression;", "(Ljava/lang/String;Lorg/jetbrains/exposed/sql/QueryBuilder;[Lorg/jetbrains/exposed/sql/Expression;)V", "day", "T", "delete", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "where", "limit", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "(ZLorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "groupConcat", "Lorg/jetbrains/exposed/sql/GroupConcat;", "hour", "minute", "month", "queryLimit", "size", "offset", "", "alreadyOrdered", "random", "seed", "(Ljava/lang/Integer;)Ljava/lang/String;", "second", "substring", "start", "length", "builder", "prefix", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/sql/Column;", "", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "target", "(Lorg/jetbrains/exposed/sql/Table;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "year", "exposed-core"})
public final class OracleFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final OracleFunctionProvider INSTANCE = new OracleFunctionProvider();

    private OracleFunctionProvider() {
    }

    @Override
    @NotNull
    public String random(@Nullable Integer seed) {
        return "dbms_random.value";
    }

    @Override
    public <T extends String> void substring(@NotNull Expression<T> expr, @NotNull Expression<Integer> start, @NotNull Expression<Integer> length, @NotNull QueryBuilder builder, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(start, "start");
        Intrinsics.checkNotNullParameter(length, "length");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        super.substring(expr, start, length, builder, "SUBSTR");
    }

    @Override
    public void concat(@NotNull String separator, @NotNull QueryBuilder queryBuilder, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter(separator, "separator");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        Intrinsics.checkNotNullParameter(expr, "expr");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(separator, expr){
            final /* synthetic */ String $separator;
            final /* synthetic */ Expression<?>[] $expr;
            {
                this.$separator = $separator;
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                if (Intrinsics.areEqual(this.$separator, "")) {
                    QueryBuilder.appendTo$default($this$invoke, this.$expr, (CharSequence)" || ", null, null, (Function2)concat.1.INSTANCE, 6, null);
                } else {
                    QueryBuilder.appendTo$default($this$invoke, this.$expr, (CharSequence)(" || '" + this.$separator + "' || "), null, null, (Function2)concat.2.INSTANCE, 6, null);
                }
            }
        });
    }

    @Override
    public <T extends String> void groupConcat(@NotNull GroupConcat<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ GroupConcat<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                if (this.$expr.getOrderBy().length != 1) {
                    ExceptionsKt.throwUnsupportedException(TransactionManager.Companion.current(), "SQLServer supports only single column in ORDER BY clause in LISTAGG");
                    throw new KotlinNothingValueException();
                }
                $this$invoke.append("LISTAGG(");
                $this$invoke.append(this.$expr.getExpr());
                Object object = this.$expr.getSeparator();
                if (object != null) {
                    String string = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string;
                    boolean bl3 = false;
                    $this$invoke.append(", '" + it + '\'');
                }
                $this$invoke.append(") WITHIN GROUP (ORDER BY ");
                object = ArraysKt.single(this.$expr.getOrderBy());
                Expression col = (Expression)((Pair)object).component1();
                SortOrder order = (SortOrder)((Object)((Pair)object).component2());
                Object[] objectArray = new Object[]{col, " ", order.name(), ")"};
                ExpressionKt.append($this$invoke, objectArray);
            }
        });
    }

    @Override
    public <T> void year(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(YEAR FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void month(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(MONTH FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void day(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(DAY FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void hour(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(HOUR FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void minute(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(MINUTE FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    public <T> void second(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(queryBuilder, "queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(expr){
            final /* synthetic */ Expression<T> $expr;
            {
                this.$expr = $expr;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("Extract(SECOND FROM ");
                $this$invoke.append(this.$expr);
                $this$invoke.append(")");
            }
        });
    }

    @Override
    @NotNull
    public String update(@NotNull Table target, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        String def = super.update(target, columnsAndValues, null, where, transaction2);
        return limit != null && where != null ? def + " AND ROWNUM <= " + limit : (limit != null ? def + " WHERE ROWNUM <= " + limit : def);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        boolean bl;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Object object;
        void $this$flatMapTo$iv$iv;
        Object element$iv2;
        boolean bl2;
        Object object2;
        Pair it;
        Collection collection;
        Collection destination$iv$iv;
        Object object3;
        QueryBuilder $this$update_u24lambda_u2d6;
        block11: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(targets, "targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            QueryBuilder queryBuilder = new QueryBuilder(true);
            boolean bl3 = false;
            boolean bl4 = false;
            $this$update_u24lambda_u2d6 = queryBuilder;
            boolean bl5 = false;
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            object3 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                object2 = ((Column)it.getFirst()).getTable();
                collection.add(object2);
            }
            Table table = (Table)CollectionsKt.singleOrNull(CollectionsKt.distinct((List)destination$iv$iv));
            if (table == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "Oracle supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            Iterable $this$any$iv = targets.getJoinParts$exposed_core();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    Join.JoinPart it2 = (Join.JoinPart)element$iv2;
                    boolean bl7 = false;
                    if (!(it2.getJoinType() != JoinType.INNER)) continue;
                    bl2 = true;
                    break block11;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
        }
        $this$update_u24lambda_u2d6.unaryPlus("UPDATE (");
        Iterable $this$flatMap$iv = columnsAndValues;
        boolean $i$f$flatMap = false;
        element$iv2 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl8 = false;
            Expression[] expressionArray = new Expression[]{(Expression)it.getFirst(), (object = it.getSecond()) instanceof Expression ? (Expression)object : null};
            Iterable list$iv$iv = CollectionsKt.listOfNotNull(expressionArray);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$mapIndexed = false;
        $this$flatMapTo$iv$iv = $this$mapIndexed$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void expression;
            int n = index$iv$iv++;
            boolean bl9 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object = (Expression)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl10 = false;
            object2 = TuplesKt.to(expression, AliasKt.alias(expression, Intrinsics.stringPlus("c", (int)index)));
            collection.add(object2);
        }
        Map columnsToSelect = MapsKt.toMap((List)destination$iv$iv);
        Query subQuery = QueriesKt.selectAll(targets.slice(CollectionsKt.toList(columnsToSelect.values())));
        Op<Boolean> op = where;
        if (op != null) {
            object3 = op;
            boolean bl11 = false;
            bl = false;
            Object it3 = object3;
            boolean bl12 = false;
            subQuery.adjustWhere((Function1<? super Op<Boolean>, ? extends Op<Boolean>>)new Function1<Op<Boolean>, Op<Boolean>>((Op<Boolean>)it3){
                final /* synthetic */ Op<Boolean> $it;
                {
                    this.$it = $it;
                    super(1);
                }

                @NotNull
                public final Op<Boolean> invoke(@Nullable Op<Boolean> $this$adjustWhere) {
                    return this.$it;
                }
            });
        }
        subQuery.prepareSQL($this$update_u24lambda_u2d6);
        $this$update_u24lambda_u2d6.unaryPlus(") x");
        ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2d6, null, " SET ", null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(columnsToSelect){
            final /* synthetic */ Map<Expression<? extends Object>, ExpressionAlias<? extends Object>> $columnsToSelect;
            {
                this.$columnsToSelect = $columnsToSelect;
                super(2);
            }

            public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> $dstr$col$value) {
                block2: {
                    QueryBuilder queryBuilder;
                    Expression expression;
                    Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                    Intrinsics.checkNotNullParameter($dstr$col$value, "$dstr$col$value");
                    Column<?> col = $dstr$col$value.component1();
                    Object value = $dstr$col$value.component2();
                    ExpressionAlias<? extends Object> alias = MapsKt.getValue(this.$columnsToSelect, col);
                    $this$appendTo.unaryPlus(alias.getAlias());
                    $this$appendTo.unaryPlus("=");
                    Expression expression2 = expression = value instanceof Expression ? (Expression)value : null;
                    if (expression == null) {
                        queryBuilder = null;
                    } else {
                        Expression expression3 = expression;
                        Map<Expression<? extends Object>, ExpressionAlias<? extends Object>> map2 = this.$columnsToSelect;
                        boolean bl = false;
                        boolean bl2 = false;
                        Expression it = expression3;
                        boolean bl3 = false;
                        queryBuilder = $this$appendTo.unaryPlus(MapsKt.getValue(map2, it).getAlias());
                    }
                    QueryBuilder queryBuilder2 = queryBuilder;
                    if (queryBuilder2 != null) break block2;
                    $this$appendTo.registerArgument(col, value);
                }
            }
        }, 10, null);
        op = limit;
        if (op != null) {
            object3 = op;
            boolean bl13 = false;
            bl = false;
            int it4 = ((Number)object3).intValue();
            boolean bl14 = false;
            Intrinsics.stringPlus("WHERE ROWNUM <= ", it4);
        }
        return $this$update_u24lambda_u2d6.toString();
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (limit != null) {
            ExceptionsKt.throwUnsupportedException(transaction2, "Oracle doesn't support LIMIT in DELETE clause.");
            throw new KotlinNothingValueException();
        }
        return super.delete(ignore, table, where, limit, transaction2);
    }

    @Override
    @NotNull
    public String queryLimit(int size, long offset, boolean alreadyOrdered) {
        return (offset > 0L ? " OFFSET " + offset + " ROWS" : "") + " FETCH FIRST " + size + " ROWS ONLY";
    }
}

