/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaKt;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.OracleDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.OracleFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 )2\u00020\u0001:\u0001)B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\bH\u0016J\u0014\u0010\u001e\u001a\u00020\b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 H\u0016J2\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\"2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\n\u00a8\u0006*"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "defaultReferenceOption", "Lorg/jetbrains/exposed/sql/ReferenceOption;", "getDefaultReferenceOption", "()Lorg/jetbrains/exposed/sql/ReferenceOption;", "needsQuotesWhenSymbolsInNames", "", "getNeedsQuotesWhenSymbolsInNames", "()Z", "needsSequenceToAutoInc", "getNeedsSequenceToAutoInc", "supportsDualTableConcept", "getSupportsDualTableConcept", "supportsIfNotExists", "getSupportsIfNotExists", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "createDatabase", "", "name", "createSchema", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropDatabase", "dropSchema", "cascade", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "modifyColumn", "", "column", "Lorg/jetbrains/exposed/sql/Column;", "nullabilityChanged", "autoIncrementChanged", "defaultChanged", "setSchema", "Companion", "exposed-core"})
public class OracleDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean supportsIfNotExists;
    private final boolean needsSequenceToAutoInc;
    @NotNull
    private final ReferenceOption defaultReferenceOption = ReferenceOption.NO_ACTION;
    private final boolean needsQuotesWhenSymbolsInNames;
    private final boolean supportsMultipleGeneratedKeys;
    private final boolean supportsOnlyIdentifiersInGeneratedKeys;
    private final boolean supportsDualTableConcept;
    @NotNull
    public static final String dialectName = "oracle";

    public OracleDialect() {
        super(dialectName, OracleDataTypeProvider.INSTANCE, OracleFunctionProvider.INSTANCE);
        this.needsSequenceToAutoInc = true;
        this.supportsOnlyIdentifiersInGeneratedKeys = true;
        this.supportsDualTableConcept = true;
    }

    @Override
    public boolean getSupportsIfNotExists() {
        return this.supportsIfNotExists;
    }

    @Override
    public boolean getNeedsSequenceToAutoInc() {
        return this.needsSequenceToAutoInc;
    }

    @Override
    @NotNull
    public ReferenceOption getDefaultReferenceOption() {
        return this.defaultReferenceOption;
    }

    @Override
    public boolean getNeedsQuotesWhenSymbolsInNames() {
        return this.needsQuotesWhenSymbolsInNames;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return this.supportsOnlyIdentifiersInGeneratedKeys;
    }

    @Override
    public boolean getSupportsDualTableConcept() {
        return this.supportsDualTableConcept;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, boolean nullabilityChanged, boolean autoIncrementChanged, boolean defaultChanged) {
        List list;
        String string;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, "column");
        Iterable $this$map$iv = super.modifyColumn(column, nullabilityChanged, autoIncrementChanged, defaultChanged);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = StringsKt.replace$default((String)it, "MODIFY COLUMN", "MODIFY", false, 4, null);
            collection.add(string);
        }
        List result2 = (List)destination$iv$iv;
        if (!nullabilityChanged) {
            void $this$mapTo$iv$iv2;
            String nullableState = column.getColumnType().getNullable() ? "NULL " : "NOT NULL";
            Iterable $this$map$iv2 = result2;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                string = StringsKt.replace$default((String)it, nullableState, "", false, 4, null);
                collection.add(string);
            }
            list = (List)destination$iv$iv2;
        } else {
            list = result2;
        }
        return list;
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("CREATE DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return Intrinsics.stringPlus("DROP DATABASE ", DefaultKt.inProperCase(name));
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return Intrinsics.stringPlus("ALTER SESSION SET CURRENT_SCHEMA = ", schema.getIdentifier());
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$createSchema_u24lambda_u2d2 = stringBuilder;
        boolean bl5 = false;
        if (schema.getQuota() == null ^ schema.getOn() == null) {
            throw new IllegalArgumentException("You must either provide both <quota> and <on> options or non of them");
        }
        String[] stringArray = new String[]{"CREATE USER ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u2d2, stringArray);
        stringArray = new String[]{" IDENTIFIED BY ", schema.getPassword()};
        StringsKt.append($this$createSchema_u24lambda_u2d2, stringArray);
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " DEFAULT TABLESPACE ", schema.getDefaultTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " TEMPORARY TABLESPACE ", schema.getTemporaryTablespace());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " QUOTA ", schema.getQuota());
        SchemaKt.appendIfNotNull($this$createSchema_u24lambda_u2d2, " ON ", schema.getOn());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$dropSchema_u24lambda_u2d3 = stringBuilder;
        boolean bl5 = false;
        String[] stringArray = new String[]{"DROP USER ", schema.getIdentifier()};
        StringsKt.append($this$dropSchema_u24lambda_u2d3, stringArray);
        if (cascade) {
            $this$dropSchema_u24lambda_u2d3.append(" CASCADE");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/OracleDialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

