/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.exceptions.UnsupportedByDialectException;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.Schema;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDataTypeProvider;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eH\u0016J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0004H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0014J\u0014\u0010\u001b\u001a\u00020\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001b\u0010\u0003\u001a\u00020\u00048@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006!"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMysql8", "", "isMysql8$exposed_core", "()Z", "isMysql8$delegate", "Lkotlin/Lazy;", "supportsCreateSequence", "getSupportsCreateSequence", "supportsSubqueryUnions", "getSupportsSubqueryUnions", "createSchema", "", "schema", "Lorg/jetbrains/exposed/sql/Schema;", "dropIndex", "tableName", "indexName", "dropSchema", "cascade", "fillConstraintCacheForTables", "", "tables", "", "Lorg/jetbrains/exposed/sql/Table;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isFractionDateTimeSupported", "setSchema", "Companion", "exposed-core"})
public class MysqlDialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy isMysql8$delegate = LazyKt.lazy(isMysql8.2.INSTANCE);
    private final boolean supportsCreateSequence;
    private final boolean supportsSubqueryUnions;
    @NotNull
    public static final String dialectName = "mysql";

    public MysqlDialect() {
        super(dialectName, MysqlDataTypeProvider.INSTANCE, MysqlFunctionProvider.INSTANCE.INSTANCE);
        this.supportsSubqueryUnions = true;
    }

    public final boolean isMysql8$exposed_core() {
        Lazy lazy = this.isMysql8$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsCreateSequence() {
        return this.supportsCreateSequence;
    }

    @Override
    public boolean getSupportsSubqueryUnions() {
        return this.supportsSubqueryUnions;
    }

    public final boolean isFractionDateTimeSupported() {
        return TransactionManager.Companion.current().getDb().isVersionCovers(new BigDecimal("5.6"));
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, "e");
        if (super.isAllowedAsColumnDefault(e)) {
            return true;
        }
        Object object = new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIMESTAMP()", "NOW()", "CURRENT_TIMESTAMP(6)", "NOW(6)"};
        String[] acceptableDefaults = object;
        object = e.toString();
        boolean bl = false;
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ArraysKt.contains(acceptableDefaults, ((Object)StringsKt.trim((CharSequence)object)).toString()) && this.isFractionDateTimeSupported();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void fillConstraintCacheForTables(@NotNull List<? extends Table> tables) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.nameInDatabaseCase();
            map2.put(string, element$iv$iv);
        }
        Map allTables = destination$iv$iv;
        Set<String> allTableNames = allTables.keySet();
        String inTableList = CollectionsKt.joinToString$default(allTableNames, "','", " ku.TABLE_NAME IN ('", "')", 0, null, null, 56, null);
        Transaction tr = TransactionManager.Companion.current();
        String schemaName = '\'' + this.getDatabase() + '\'';
        HashMap<String, List<ForeignKeyConstraint>> constraintsToLoad = new HashMap<String, List<ForeignKeyConstraint>>();
        Transaction.exec$default(tr, "SELECT\n  rc.CONSTRAINT_NAME,\n  ku.TABLE_NAME,\n  ku.COLUMN_NAME,\n  ku.REFERENCED_TABLE_NAME,\n  ku.REFERENCED_COLUMN_NAME,\n  rc.UPDATE_RULE,\n  rc.DELETE_RULE\nFROM INFORMATION_SCHEMA.REFERENTIAL_CONSTRAINTS rc\n  INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE ku\n    ON ku.TABLE_SCHEMA = rc.CONSTRAINT_SCHEMA AND rc.CONSTRAINT_NAME = ku.CONSTRAINT_NAME\nWHERE ku.TABLE_SCHEMA = " + schemaName + "    AND ku.CONSTRAINT_SCHEMA = " + schemaName + "   AND rc.CONSTRAINT_SCHEMA = " + schemaName + "   AND " + inTableList, null, null, new Function1<ResultSet, Unit>(allTableNames, this, tr, (Map<String, ? extends Table>)allTables, constraintsToLoad){
            final /* synthetic */ Set<String> $allTableNames;
            final /* synthetic */ MysqlDialect this$0;
            final /* synthetic */ Transaction $tr;
            final /* synthetic */ Map<String, Table> $allTables;
            final /* synthetic */ HashMap<String, List<ForeignKeyConstraint>> $constraintsToLoad;
            {
                this.$allTableNames = $allTableNames;
                this.this$0 = $receiver;
                this.$tr = $tr;
                this.$allTables = $allTables;
                this.$constraintsToLoad = $constraintsToLoad;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ResultSet rs) {
                Intrinsics.checkNotNullParameter(rs, "rs");
                while (rs.next()) {
                    String constraintName;
                    Object object;
                    T element$iv3;
                    Object fromColumn;
                    HashMap<String, List<ForeignKeyConstraint>> hashMap;
                    String fromTableName;
                    block6: {
                        String targetTableName;
                        Object v1;
                        Transaction transaction2;
                        MysqlDialect mysqlDialect;
                        Object object2;
                        block5: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNull(rs.getString("TABLE_NAME"));
                            if (!this.$allTableNames.contains(fromTableName)) continue;
                            String string = rs.getString("COLUMN_NAME");
                            Intrinsics.checkNotNull(string);
                            String fromColumnName = this.this$0.quoteIdentifierWhenWrongCaseOrNecessary(string, this.$tr);
                            object2 = MapsKt.getValue(this.$allTables, fromTableName).getColumns();
                            mysqlDialect = this.this$0;
                            transaction2 = this.$tr;
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv2 : $this$firstOrNull$iv) {
                                Column it = (Column)element$iv2;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), fromColumnName)) continue;
                                v1 = element$iv2;
                                break block5;
                            }
                            v1 = null;
                        }
                        Column column = v1;
                        if (column == null) continue;
                        object2 = column;
                        mysqlDialect = this.this$0;
                        transaction2 = this.$tr;
                        Map<String, Table> map2 = this.$allTables;
                        hashMap = this.$constraintsToLoad;
                        boolean bl = false;
                        boolean bl2 = false;
                        fromColumn = object2;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(rs.getString("CONSTRAINT_NAME"));
                        Intrinsics.checkNotNull(rs.getString("REFERENCED_TABLE_NAME"));
                        String string = rs.getString("REFERENCED_COLUMN_NAME");
                        Intrinsics.checkNotNull(string);
                        String targetColumnName = mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(string, transaction2);
                        Iterable $this$first$iv = MapsKt.getValue(map2, targetTableName).getColumns();
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual(mysqlDialect.quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase(), transaction2), targetColumnName)) continue;
                            break block6;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    String string = rs.getString("UPDATE_RULE");
                    Intrinsics.checkNotNull(string);
                    ReferenceOption constraintUpdateRule = ReferenceOption.valueOf(StringsKt.replace$default(string, " ", "_", false, 4, null));
                    String string2 = rs.getString("DELETE_RULE");
                    Intrinsics.checkNotNull(string2);
                    ReferenceOption constraintDeleteRule = ReferenceOption.valueOf(StringsKt.replace$default(string2, " ", "_", false, 4, null));
                    Map $this$getOrPut$iv = hashMap;
                    boolean $i$f$getOrPut = false;
                    V value$iv = $this$getOrPut$iv.get(fromTableName);
                    if (value$iv == null) {
                        boolean bl = false;
                        boolean bl5 = false;
                        List answer$iv = new ArrayList<E>();
                        $this$getOrPut$iv.put(fromTableName, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).add(new ForeignKeyConstraint(targetColumn, (Column<?>)fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName));
                }
                this.this$0.getColumnConstraintsCache().putAll((Map<String, List<ForeignKeyConstraint>>)this.$constraintsToLoad);
            }
        }, 6, null);
    }

    @Override
    @NotNull
    public String dropIndex(@NotNull String tableName, @NotNull String indexName2) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(indexName2, "indexName");
        return "ALTER TABLE " + tableName + " DROP INDEX " + indexName2;
    }

    @Override
    @NotNull
    public String setSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return Intrinsics.stringPlus("USE ", schema.getIdentifier());
    }

    @Override
    @NotNull
    public String createSchema(@NotNull Schema schema) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$createSchema_u24lambda_u2d1 = stringBuilder;
        boolean bl5 = false;
        String[] stringArray = new String[]{"CREATE SCHEMA IF NOT EXISTS ", schema.getIdentifier()};
        StringsKt.append($this$createSchema_u24lambda_u2d1, stringArray);
        if (schema.getAuthorization() != null) {
            throw new UnsupportedByDialectException(Intrinsics.stringPlus(DefaultKt.getCurrentDialect().getName(), " do not have database owners. You can use GRANT to allow or deny rights on database."), DefaultKt.getCurrentDialect());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public String dropSchema(@NotNull Schema schema, boolean cascade) {
        Intrinsics.checkNotNullParameter(schema, "schema");
        return Intrinsics.stringPlus("DROP SCHEMA IF EXISTS ", schema.getIdentifier());
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/MysqlDialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

