/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionKt;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.Join;
import org.jetbrains.exposed.sql.JoinType;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.vendors.FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J:\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J8\u0010\u0010\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u001e\u0010\u0011\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016JW\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u001e\u0010\u0017\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2FunctionProvider;", "Lorg/jetbrains/exposed/sql/vendors/FunctionProvider;", "()V", "exactH2Version", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "insert", "ignore", "", "table", "Lorg/jetbrains/exposed/sql/Table;", "columns", "", "Lorg/jetbrains/exposed/sql/Column;", "expr", "replace", "data", "Lkotlin/Pair;", "", "update", "targets", "Lorg/jetbrains/exposed/sql/Join;", "columnsAndValues", "limit", "", "where", "Lorg/jetbrains/exposed/sql/Op;", "(Lorg/jetbrains/exposed/sql/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/sql/Op;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/String;", "exposed-core"})
public final class H2FunctionProvider
extends FunctionProvider {
    @NotNull
    public static final H2FunctionProvider INSTANCE = new H2FunctionProvider();

    private H2FunctionProvider() {
    }

    private final String exactH2Version(Transaction transaction2) {
        return (String)transaction2.getDb().metadata$exposed_core(exactH2Version.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns2, @NotNull String expr, @NotNull Transaction transaction2) {
        String string;
        Column<?>[] columnArray;
        Object $this$flatMapTo$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(columns2, "columns");
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        boolean bl = false;
        Set uniqueCols = new LinkedHashSet();
        Iterable $this$filter$iv = table.getIndices();
        boolean $i$f$filter = false;
        Column<?>[] columnArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Index it = (Index)element$iv$iv;
            boolean bl2 = false;
            if (!it.getUnique()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMapTo = false;
        columnArray2 = $this$flatMapTo$iv.iterator();
        while (columnArray2.hasNext()) {
            Object element$iv = columnArray2.next();
            Index it = (Index)element$iv;
            boolean bl3 = false;
            Iterable list$iv = it.getColumns();
            CollectionsKt.addAll((Collection)uniqueCols, list$iv);
        }
        $this$flatMapTo$iv = table.getPrimaryKey();
        if ($this$flatMapTo$iv != null && (columnArray = ((Table.PrimaryKey)$this$flatMapTo$iv).getColumns()) != null) {
            columnArray2 = columnArray;
            boolean bl4 = false;
            boolean bl5 = false;
            Column<?>[] primaryKeys = columnArray2;
            boolean bl6 = false;
            Collection collection = uniqueCols;
            boolean bl7 = false;
            CollectionsKt.addAll(collection, primaryKeys);
        }
        if (ignore) {
            $this$flatMapTo$iv = uniqueCols;
            boolean bl8 = false;
            if (!$this$flatMapTo$iv.isEmpty() && H2Kt.access$isMySQLMode(transaction2) && this.exactH2Version(transaction2).compareTo("1.4.197") < 0) {
                String def = super.insert(false, table, columns2, expr, transaction2);
                string = def + " ON DUPLICATE KEY UPDATE " + CollectionsKt.joinToString$default(uniqueCols, null, null, null, 0, null, new Function1<Column<?>, CharSequence>(transaction2){
                    final /* synthetic */ Transaction $transaction;
                    {
                        this.$transaction = $transaction;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Column<?> it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        return this.$transaction.identity(it) + "=VALUES(" + this.$transaction.identity(it) + ')';
                    }
                }, 31, null);
                return string;
            }
        }
        if (ignore) {
            Collection collection = uniqueCols;
            boolean bl9 = false;
            if (!collection.isEmpty() && H2Kt.access$isMySQLMode(transaction2)) {
                string = StringsKt.replace$default(super.insert(false, table, columns2, expr, transaction2), "INSERT", "INSERT IGNORE", false, 4, null);
                return string;
            }
        }
        string = super.insert(ignore, table, columns2, expr, transaction2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction2) {
        Object it;
        boolean bl;
        Table tableToUpdate;
        Object object;
        QueryBuilder $this$update_u24lambda_u2d7;
        block11: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(targets, "targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, "columnsAndValues");
            Intrinsics.checkNotNullParameter(transaction2, "transaction");
            QueryBuilder queryBuilder = new QueryBuilder(true);
            boolean bl2 = false;
            boolean bl3 = false;
            $this$update_u24lambda_u2d7 = queryBuilder;
            boolean bl4 = false;
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            Iterable $this$map$iv = columnsAndValues;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                Table table = ((Column)it2.getFirst()).getTable();
                collection.add(table);
            }
            object = (Table)CollectionsKt.singleOrNull(CollectionsKt.distinct((List)destination$iv$iv));
            if (object == null) {
                ExceptionsKt.throwUnsupportedException(transaction2, "H2 supports a join updates with a single table columns to update.");
                throw new KotlinNothingValueException();
            }
            tableToUpdate = object;
            Iterable $this$any$iv = targets.getJoinParts$exposed_core();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Join.JoinPart)element$iv;
                    boolean bl6 = false;
                    if (!(((Join.JoinPart)it).getJoinType() != JoinType.INNER)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("All tables in UPDATE statement will be joined with inner join");
        }
        $this$update_u24lambda_u2d7.unaryPlus("MERGE INTO ");
        tableToUpdate.describe(transaction2, $this$update_u24lambda_u2d7);
        $this$update_u24lambda_u2d7.unaryPlus(" USING ");
        if (!Intrinsics.areEqual(targets.getTable(), tableToUpdate)) {
            targets.getTable().describe(transaction2, $this$update_u24lambda_u2d7);
        }
        Iterable $this$forEach$iv = targets.getJoinParts$exposed_core();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Join.JoinPart)element$iv;
            boolean bl7 = false;
            if (!Intrinsics.areEqual(((Join.JoinPart)it).getJoinPart(), tableToUpdate)) {
                ((Join.JoinPart)it).getJoinPart().describe(transaction2, $this$update_u24lambda_u2d7);
            }
            $this$update_u24lambda_u2d7.unaryPlus(" ON ");
            ((Join.JoinPart)it).appendConditions($this$update_u24lambda_u2d7);
        }
        $this$update_u24lambda_u2d7.unaryPlus(" WHEN MATCHED THEN UPDATE SET ");
        ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2d7, null, null, null, new Function2<QueryBuilder, Pair<? extends Column<?>, ? extends Object>, Unit>(transaction2){
            final /* synthetic */ Transaction $transaction;
            {
                this.$transaction = $transaction;
                super(2);
            }

            public final void invoke(@NotNull QueryBuilder $this$appendTo, @NotNull Pair<? extends Column<?>, ? extends Object> $dstr$col$value) {
                Intrinsics.checkNotNullParameter($this$appendTo, "$this$appendTo");
                Intrinsics.checkNotNullParameter($dstr$col$value, "$dstr$col$value");
                Column<?> col = $dstr$col$value.component1();
                Object value = $dstr$col$value.component2();
                $this$appendTo.append(Intrinsics.stringPlus(this.$transaction.fullIdentity(col), "="));
                $this$appendTo.registerArgument(col, value);
            }
        }, 14, null);
        object = where;
        if (object != null) {
            Object object2 = object;
            boolean bl8 = false;
            boolean bl9 = false;
            it = object2;
            boolean bl10 = false;
            $this$update_u24lambda_u2d7.unaryPlus(" WHERE ");
            $this$update_u24lambda_u2d7.unaryPlus((Expression)it);
        }
        return $this$update_u24lambda_u2d7.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data, @NotNull Transaction transaction2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(table, "table");
        Intrinsics.checkNotNullParameter(data, "data");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        if (data.isEmpty()) {
            return "";
        }
        Iterable $this$map$iv = data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Column column = (Column)it.getFirst();
            collection.add(column);
        }
        List columns2 = (List)destination$iv$iv;
        QueryBuilder builder = new QueryBuilder(true);
        String sql2 = ExpressionKt.appendTo$default(data, builder, null, "VALUES (", ")", replace.sql.1.INSTANCE, 2, null).toString();
        return StringsKt.replaceFirst$default(super.insert(false, table, columns2, sql2, transaction2), "INSERT", "MERGE", false, 4, null);
    }
}

