/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.transactions;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedConnection;
import org.jetbrains.exposed.sql.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.sql.transactions.TransactionInterface;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u00020\u00058VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager;", "Lorg/jetbrains/exposed/sql/transactions/TransactionManager;", "db", "Lorg/jetbrains/exposed/sql/Database;", "defaultRepetitionAttempts", "", "(Lorg/jetbrains/exposed/sql/Database;I)V", "defaultIsolationLevel", "getDefaultIsolationLevel", "()I", "setDefaultIsolationLevel", "(I)V", "getDefaultRepetitionAttempts", "setDefaultRepetitionAttempts", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/Transaction;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "bindTransactionToThread", "", "transaction", "currentOrNull", "newTransaction", "isolation", "outerTransaction", "ThreadLocalTransaction", "exposed-core"})
public final class ThreadLocalTransactionManager
implements TransactionManager {
    @NotNull
    private final Database db;
    private volatile int defaultRepetitionAttempts;
    private volatile int defaultIsolationLevel;
    @NotNull
    private final ThreadLocal<Transaction> threadLocal;

    public ThreadLocalTransactionManager(@NotNull Database db, int defaultRepetitionAttempts) {
        Intrinsics.checkNotNullParameter(db, "db");
        this.db = db;
        this.defaultRepetitionAttempts = defaultRepetitionAttempts;
        this.defaultIsolationLevel = -1;
        this.threadLocal = new ThreadLocal();
    }

    @Override
    public int getDefaultRepetitionAttempts() {
        return this.defaultRepetitionAttempts;
    }

    @Override
    public void setDefaultRepetitionAttempts(int n) {
        this.defaultRepetitionAttempts = n;
    }

    @Override
    public int getDefaultIsolationLevel() {
        if (this.defaultIsolationLevel == -1) {
            this.defaultIsolationLevel = Database.Companion.getDefaultIsolationLevel(this.db);
        }
        return this.defaultIsolationLevel;
    }

    @Override
    public void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    @NotNull
    public final ThreadLocal<Transaction> getThreadLocal() {
        return this.threadLocal;
    }

    @Override
    @NotNull
    public Transaction newTransaction(int isolation, @Nullable Transaction outerTransaction) {
        int n;
        Transaction transaction2;
        Transaction transaction3;
        Transaction transaction4 = outerTransaction;
        if (transaction4 == null) {
            transaction3 = null;
        } else {
            Transaction transaction5 = transaction4;
            boolean bl = false;
            boolean bl2 = false;
            Transaction it = transaction5;
            boolean bl3 = false;
            transaction3 = transaction2 = !this.db.getUseNestedTransactions() ? transaction5 : null;
        }
        transaction2 = transaction2 == null ? new Transaction(new ThreadLocalTransaction(this.db, (transaction4 = outerTransaction) == null ? isolation : (n = transaction4.getTransactionIsolation()), this.threadLocal, outerTransaction)) : transaction2;
        boolean bl = false;
        boolean bl4 = false;
        Transaction $this$newTransaction_u24lambda_u2d1 = transaction2;
        boolean bl5 = false;
        this.bindTransactionToThread($this$newTransaction_u24lambda_u2d1);
        return transaction2;
    }

    @Override
    @Nullable
    public Transaction currentOrNull() {
        return this.threadLocal.get();
    }

    @Override
    public void bindTransactionToThread(@Nullable Transaction transaction2) {
        if (transaction2 != null) {
            this.threadLocal.set(transaction2);
        } else {
            this.threadLocal.remove();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0016R\u0018\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00110\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\t\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/transactions/ThreadLocalTransactionManager$ThreadLocalTransaction;", "Lorg/jetbrains/exposed/sql/transactions/TransactionInterface;", "db", "Lorg/jetbrains/exposed/sql/Database;", "transactionIsolation", "", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/sql/Transaction;", "outerTransaction", "(Lorg/jetbrains/exposed/sql/Database;ILjava/lang/ThreadLocal;Lorg/jetbrains/exposed/sql/Transaction;)V", "connection", "Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/sql/statements/api/ExposedConnection;", "connectionLazy", "Lkotlin/Lazy;", "", "getDb", "()Lorg/jetbrains/exposed/sql/Database;", "getOuterTransaction", "()Lorg/jetbrains/exposed/sql/Transaction;", "savepoint", "Lorg/jetbrains/exposed/sql/statements/api/ExposedSavepoint;", "savepointName", "", "getSavepointName", "()Ljava/lang/String;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "getTransactionIsolation", "()I", "useSavePoints", "", "close", "", "commit", "rollback", "exposed-core"})
    private static final class ThreadLocalTransaction
    implements TransactionInterface {
        @NotNull
        private final Database db;
        private final int transactionIsolation;
        @NotNull
        private final ThreadLocal<Transaction> threadLocal;
        @Nullable
        private final Transaction outerTransaction;
        @NotNull
        private final Lazy<ExposedConnection<? extends Object>> connectionLazy;
        private final boolean useSavePoints;
        @Nullable
        private ExposedSavepoint savepoint;

        public ThreadLocalTransaction(@NotNull Database db, int transactionIsolation, @NotNull ThreadLocal<Transaction> threadLocal, @Nullable Transaction outerTransaction) {
            Intrinsics.checkNotNullParameter(db, "db");
            Intrinsics.checkNotNullParameter(threadLocal, "threadLocal");
            this.db = db;
            this.transactionIsolation = transactionIsolation;
            this.threadLocal = threadLocal;
            this.outerTransaction = outerTransaction;
            this.connectionLazy = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<ExposedConnection<? extends Object>>(this){
                final /* synthetic */ ThreadLocalTransaction this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final ExposedConnection<? extends Object> invoke() {
                    ExposedConnection exposedConnection;
                    ExposedConnection exposedConnection2;
                    Object object = this.this$0.getOuterTransaction();
                    ExposedConnection exposedConnection3 = exposedConnection2 = object == null ? null : ((Transaction)object).getConnection();
                    if (exposedConnection2 == null) {
                        object = this.this$0.getDb().getConnector().invoke();
                        ThreadLocalTransaction threadLocalTransaction = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        ExposedConnection $this$invoke_u24lambda_u2d0 = (ExposedConnection)object;
                        boolean bl3 = false;
                        $this$invoke_u24lambda_u2d0.setAutoCommit(false);
                        $this$invoke_u24lambda_u2d0.setTransactionIsolation(threadLocalTransaction.getTransactionIsolation());
                        exposedConnection = (ExposedConnection)object;
                    } else {
                        exposedConnection = exposedConnection2;
                    }
                    return exposedConnection;
                }
            });
            this.useSavePoints = this.getOuterTransaction() != null && this.getDb().getUseNestedTransactions();
            this.savepoint = this.useSavePoints ? this.getConnection().setSavepoint(this.getSavepointName()) : null;
        }

        @Override
        @NotNull
        public Database getDb() {
            return this.db;
        }

        @Override
        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        @NotNull
        public final ThreadLocal<Transaction> getThreadLocal() {
            return this.threadLocal;
        }

        @Override
        @Nullable
        public Transaction getOuterTransaction() {
            return this.outerTransaction;
        }

        @Override
        @NotNull
        public ExposedConnection<?> getConnection() {
            return this.connectionLazy.getValue();
        }

        @Override
        public void commit() {
            if (this.connectionLazy.isInitialized() && !this.useSavePoints) {
                this.getConnection().commit();
            }
        }

        @Override
        public void rollback() {
            if (this.connectionLazy.isInitialized() && !this.getConnection().isClosed()) {
                if (this.useSavePoints && this.savepoint != null) {
                    ExposedConnection<?> exposedConnection = this.getConnection();
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    Intrinsics.checkNotNull(exposedSavepoint);
                    exposedConnection.rollback(exposedSavepoint);
                    this.savepoint = this.getConnection().setSavepoint(this.getSavepointName());
                } else {
                    this.getConnection().rollback();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                if (!this.useSavePoints) {
                    if (this.connectionLazy.isInitialized()) {
                        this.getConnection().close();
                    }
                } else {
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    if (exposedSavepoint == null) {
                    } else {
                        ExposedSavepoint exposedSavepoint2 = exposedSavepoint;
                        boolean bl = false;
                        boolean bl2 = false;
                        ExposedSavepoint it = exposedSavepoint2;
                        boolean bl3 = false;
                        this.getConnection().releaseSavepoint(it);
                        this.savepoint = null;
                    }
                }
            }
            finally {
                this.threadLocal.set(this.getOuterTransaction());
            }
        }

        private final String getSavepointName() {
            Transaction transaction2;
            int nestedLevel = 0;
            Transaction currenTransaction = this.getOuterTransaction();
            while (((transaction2 = currenTransaction) == null ? null : transaction2.getOuterTransaction()) != null) {
                int n = nestedLevel;
                nestedLevel = n + 1;
                currenTransaction = currenTransaction.getOuterTransaction();
            }
            return Intrinsics.stringPlus("Exposed_savepoint_", nestedLevel);
        }
    }
}

