/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements.jdbc;

import java.math.BigDecimal;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.ReferenceOption;
import org.jetbrains.exposed.sql.SchemaUtils;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.ExposedDatabaseMetadata;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImpl;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcDatabaseMetadataImplKt;
import org.jetbrains.exposed.sql.statements.jdbc.JdbcIdentifierManager;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.ColumnMetadata;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;
import org.jetbrains.exposed.sql.vendors.OracleDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Z2\u00020\u0001:\u0002YZB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010A\u001a\u00020BH\u0016J3\u0010C\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ3\u0010H\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d062\u0012\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F\"\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010GJ-\u0010I\u001a\b\u0012\u0004\u0012\u0002HK0J\"\u0004\b\u0000\u0010K2\u0017\u0010L\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002HK0M\u00a2\u0006\u0002\bNH\u0002J\b\u0010O\u001a\u00020BH\u0016J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001dH\u0002J(\u0010P\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0\u001d062\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001dH\u0016J\u0016\u0010R\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\u0006\u0010S\u001a\u00020\u0003H\u0002JS\u0010T\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020D0\u001d06*\u00020U2\u000e\u0010E\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0F2\u001e\u0010V\u001a\u001a\u0012\u0004\u0012\u00020U\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020D0W0MH\u0002\u00a2\u0006\u0002\u0010XR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u001b\u0010\f\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\tR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u001b\u0010\u0012\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0013\u0010\tR\u001b\u0010\u0015\u001a\u00020\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R6\u0010\u001a\u001a*\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d0\u001bj\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d`\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010 \u001a\u00020!8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010\u000f\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001b\u0010*\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u000f\u001a\u0004\b,\u0010-R\u001b\u0010/\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b1\u0010\u000f\u001a\u0004\b0\u0010-R\u001b\u00102\u001a\u00020+8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b4\u0010\u000f\u001a\u0004\b3\u0010-R&\u00105\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001d068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u001b\u00109\u001a\u00020\u00038VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010\u000f\u001a\u0004\b:\u0010\tR\u001b\u0010<\u001a\u00020=8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010\u000f\u001a\u0004\b>\u0010?\u00a8\u0006["}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;", "Lorg/jetbrains/exposed/sql/statements/api/ExposedDatabaseMetadata;", "database", "", "metadata", "Ljava/sql/DatabaseMetaData;", "(Ljava/lang/String;Ljava/sql/DatabaseMetaData;)V", "_currentScheme", "get_currentScheme", "()Ljava/lang/String;", "currentScheme", "getCurrentScheme", "databaseDialectName", "getDatabaseDialectName", "databaseDialectName$delegate", "Lkotlin/Lazy;", "databaseName", "getDatabaseName", "databaseProductVersion", "getDatabaseProductVersion", "databaseProductVersion$delegate", "defaultIsolationLevel", "", "getDefaultIsolationLevel", "()I", "defaultIsolationLevel$delegate", "existingIndicesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/exposed/sql/Table;", "", "Lorg/jetbrains/exposed/sql/Index;", "Lkotlin/collections/HashMap;", "identifierManager", "Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "getIdentifierManager", "()Lorg/jetbrains/exposed/sql/statements/api/IdentifierManagerApi;", "identifierManager$delegate", "getMetadata", "()Ljava/sql/DatabaseMetaData;", "schemaNames", "getSchemaNames", "()Ljava/util/List;", "supportsAlterTableWithAddColumn", "", "getSupportsAlterTableWithAddColumn", "()Z", "supportsAlterTableWithAddColumn$delegate", "supportsMultipleResultSets", "getSupportsMultipleResultSets", "supportsMultipleResultSets$delegate", "supportsSelectForUpdate", "getSupportsSelectForUpdate", "supportsSelectForUpdate$delegate", "tableNames", "", "getTableNames", "()Ljava/util/Map;", "url", "getUrl", "url$delegate", "version", "Ljava/math/BigDecimal;", "getVersion", "()Ljava/math/BigDecimal;", "version$delegate", "cleanCache", "", "columns", "Lorg/jetbrains/exposed/sql/vendors/ColumnMetadata;", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "existingIndices", "lazyMetadata", "Lkotlin/Lazy;", "T", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "resetCurrentScheme", "tableConstraints", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "tableNamesFor", "scheme", "extractColumns", "Ljava/sql/ResultSet;", "extract", "Lkotlin/Pair;", "(Ljava/sql/ResultSet;[Lorg/jetbrains/exposed/sql/Table;Lkotlin/jvm/functions/Function1;)Ljava/util/Map;", "CachableMapWithDefault", "Companion", "exposed-jdbc"})
public final class JdbcDatabaseMetadataImpl
extends ExposedDatabaseMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DatabaseMetaData metadata;
    @NotNull
    private final Lazy url$delegate;
    @NotNull
    private final Lazy version$delegate;
    @NotNull
    private final Lazy databaseDialectName$delegate;
    @NotNull
    private final Lazy databaseProductVersion$delegate;
    @NotNull
    private final Lazy defaultIsolationLevel$delegate;
    @NotNull
    private final Lazy supportsAlterTableWithAddColumn$delegate;
    @NotNull
    private final Lazy supportsMultipleResultSets$delegate;
    @NotNull
    private final Lazy supportsSelectForUpdate$delegate;
    @NotNull
    private final Lazy identifierManager$delegate;
    @Nullable
    private String _currentScheme;
    @NotNull
    private final HashMap<Table, List<Index>> existingIndicesCache;
    @NotNull
    private static final ConcurrentHashMap<String, JdbcIdentifierManager> identityManagerCache = new ConcurrentHashMap();

    public JdbcDatabaseMetadataImpl(@NotNull String database, @NotNull DatabaseMetaData metadata2) {
        Intrinsics.checkNotNullParameter(database, "database");
        Intrinsics.checkNotNullParameter(metadata2, "metadata");
        super(database);
        this.metadata = metadata2;
        this.url$delegate = this.lazyMetadata(url.2.INSTANCE);
        this.version$delegate = this.lazyMetadata(version.2.INSTANCE);
        this.databaseDialectName$delegate = this.lazyMetadata(databaseDialectName.2.INSTANCE);
        this.databaseProductVersion$delegate = this.lazyMetadata(databaseProductVersion.2.INSTANCE);
        this.defaultIsolationLevel$delegate = this.lazyMetadata(defaultIsolationLevel.2.INSTANCE);
        this.supportsAlterTableWithAddColumn$delegate = this.lazyMetadata(supportsAlterTableWithAddColumn.2.INSTANCE);
        this.supportsMultipleResultSets$delegate = this.lazyMetadata(supportsMultipleResultSets.2.INSTANCE);
        this.supportsSelectForUpdate$delegate = this.lazyMetadata(supportsSelectForUpdate.2.INSTANCE);
        this.identifierManager$delegate = this.lazyMetadata(identifierManager.2.INSTANCE);
        this.existingIndicesCache = new HashMap();
    }

    @NotNull
    public final DatabaseMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    @NotNull
    public String getUrl() {
        Lazy lazy = this.url$delegate;
        boolean bl = false;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-url>(...)");
        return (String)t;
    }

    @Override
    @NotNull
    public BigDecimal getVersion() {
        Lazy lazy = this.version$delegate;
        boolean bl = false;
        return (BigDecimal)lazy.getValue();
    }

    @Override
    @NotNull
    public String getDatabaseDialectName() {
        Lazy lazy = this.databaseDialectName$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    private final String getDatabaseName() {
        String string = this.getDatabaseDialectName();
        return (Intrinsics.areEqual(string, "mysql") ? true : Intrinsics.areEqual(string, "mariadb")) ? this.getCurrentScheme() : this.getDatabase();
    }

    @Override
    @NotNull
    public String getDatabaseProductVersion() {
        Lazy lazy = this.databaseProductVersion$delegate;
        boolean bl = false;
        return (String)lazy.getValue();
    }

    @Override
    public int getDefaultIsolationLevel() {
        Lazy lazy = this.defaultIsolationLevel$delegate;
        boolean bl = false;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    public boolean getSupportsAlterTableWithAddColumn() {
        Lazy lazy = this.supportsAlterTableWithAddColumn$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsMultipleResultSets() {
        Lazy lazy = this.supportsMultipleResultSets$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    public boolean getSupportsSelectForUpdate() {
        Lazy lazy = this.supportsSelectForUpdate$delegate;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @Override
    @NotNull
    public IdentifierManagerApi getIdentifierManager() {
        Lazy lazy = this.identifierManager$delegate;
        boolean bl = false;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-identifierManager>(...)");
        return (IdentifierManagerApi)t;
    }

    private final String get_currentScheme() {
        block14: {
            String string;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl;
            if (this._currentScheme != null) break block14;
            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl2 = this;
            try {
                String string2;
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                switch (this.getDatabaseDialectName()) {
                    case "mariadb": 
                    case "mysql": {
                        String string3 = this.metadata.getConnection().getCatalog();
                        boolean bl = false;
                        string2 = string3;
                        if (string2 != null) break;
                        string2 = "";
                        break;
                    }
                    case "oracle": {
                        string2 = this.getDatabaseName();
                        break;
                    }
                    default: {
                        String string3 = this.metadata.getConnection().getSchema();
                        boolean bl = false;
                        string2 = string3;
                        if (string2 != null) break;
                        string2 = "";
                    }
                }
                string = string2;
            }
            catch (Throwable throwable) {
                jdbcDatabaseMetadataImpl = jdbcDatabaseMetadataImpl2;
                string = "";
            }
            jdbcDatabaseMetadataImpl._currentScheme = string;
        }
        String string = this._currentScheme;
        Intrinsics.checkNotNull(string);
        return string;
    }

    @Override
    @NotNull
    public String getCurrentScheme() {
        String string = this.get_currentScheme();
        Intrinsics.checkNotNull(string);
        return string;
    }

    @Override
    public void resetCurrentScheme() {
        this._currentScheme = null;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getTableNames() {
        return new CachableMapWithDefault(null, new Function1<String, List<? extends String>>(this){
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull String schemeName) {
                Intrinsics.checkNotNullParameter(schemeName, "schemeName");
                return JdbcDatabaseMetadataImpl.access$tableNamesFor(this.this$0, schemeName);
            }
        }, 1, null);
    }

    private final List<String> tableNamesFor(String scheme2) {
        Pair<String, CharSequence> pair;
        DatabaseMetaData databaseMetaData = this.metadata;
        boolean bl = false;
        boolean bl2 = false;
        DatabaseMetaData $this$tableNamesFor_u24lambda_u2d1 = databaseMetaData;
        boolean bl3 = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            pair = TuplesKt.to(scheme2, "%");
        } else if (DefaultKt.getCurrentDialect() instanceof OracleDialect) {
            pair = TuplesKt.to(this.getDatabaseName(), this.getDatabaseName());
        } else {
            CharSequence charSequence;
            String string = this.getDatabaseName();
            CharSequence charSequence2 = scheme2;
            boolean bl4 = false;
            CharSequence charSequence3 = charSequence2;
            boolean bl5 = false;
            if (charSequence3.length() == 0) {
                String string2 = string;
                boolean bl6 = false;
                String string3 = "%";
                string = string2;
                charSequence = string3;
            } else {
                charSequence = charSequence2;
            }
            pair = TuplesKt.to(string, charSequence);
        }
        Pair<String, String> pair2 = pair;
        String catalogName = pair2.component1();
        String schemeName = pair2.component2();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet resultSet = $this$tableNamesFor_u24lambda_u2d1.getTables(catalogName, schemeName, "%", stringArray);
        Intrinsics.checkNotNullExpressionValue(resultSet, "resultSet");
        return JdbcDatabaseMetadataImplKt.access$iterate(resultSet, new Function1<ResultSet, String>(useCatalogInsteadOfScheme, this){
            final /* synthetic */ boolean $useCatalogInsteadOfScheme;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$useCatalogInsteadOfScheme = $useCatalogInsteadOfScheme;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull ResultSet $this$iterate) {
                String it;
                boolean bl;
                boolean bl2;
                String string;
                String string2;
                String string3;
                Intrinsics.checkNotNullParameter($this$iterate, "$this$iterate");
                String string4 = $this$iterate.getString("TABLE_NAME");
                Intrinsics.checkNotNull(string4);
                String tableName = string4;
                if (this.$useCatalogInsteadOfScheme) {
                    string3 = $this$iterate.getString("TABLE_CAT");
                    if (string3 == null) {
                        string2 = null;
                    } else {
                        string = string3;
                        bl2 = false;
                        bl = false;
                        it = string;
                        boolean bl3 = false;
                        string2 = it + '.' + tableName;
                    }
                } else {
                    string3 = $this$iterate.getString("TABLE_SCHEM");
                    if (string3 == null) {
                        string2 = null;
                    } else {
                        string = string3;
                        bl2 = false;
                        bl = false;
                        it = string;
                        boolean bl4 = false;
                        string2 = it + '.' + tableName;
                    }
                }
                String string5 = string2;
                String fullTableName = string5 == null ? tableName : string5;
                return this.this$0.getIdentifierManager().inProperCase(fullTableName);
            }
        });
    }

    @Override
    @NotNull
    public List<String> getSchemaNames() {
        return this.schemaNames();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> schemaNames() {
        void $this$mapTo$iv$iv;
        List list;
        ResultSet resultSet;
        DatabaseMetaData databaseMetaData = this.metadata;
        boolean bl = false;
        boolean bl2 = false;
        DatabaseMetaData $this$schemaNames_u24lambda_u2d3 = databaseMetaData;
        boolean bl3 = false;
        boolean useCatalogInsteadOfScheme = DefaultKt.getCurrentDialect() instanceof MysqlDialect;
        if (useCatalogInsteadOfScheme) {
            resultSet = $this$schemaNames_u24lambda_u2d3.getCatalogs();
            Intrinsics.checkNotNullExpressionValue(resultSet, "catalogs");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.1.INSTANCE);
        } else {
            resultSet = $this$schemaNames_u24lambda_u2d3.getSchemas();
            Intrinsics.checkNotNullExpressionValue(resultSet, "schemas");
            list = JdbcDatabaseMetadataImplKt.access$iterate(resultSet, schemaNames.1.schemas.2.INSTANCE);
        }
        List schemas2 = list;
        Iterable $this$map$iv = schemas2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            IdentifierManagerApi identifierManagerApi = this.getIdentifierManager();
            Intrinsics.checkNotNullExpressionValue(it, "it");
            String string2 = identifierManagerApi.inProperCase((String)it);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Table, List<ColumnMetadata>> extractColumns(ResultSet $this$extractColumns, Table[] tables, Function1<? super ResultSet, Pair<String, ColumnMetadata>> extract) {
        Collection collection;
        void $this$associateByTo$iv$iv;
        Table[] $this$associateBy$iv = tables;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity($this$associateBy$iv.length), 16);
        Table[] tableArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (void element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            collection = element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.nameInDatabaseCase();
            map2.put(string, element$iv$iv);
        }
        Map mapping = destination$iv$iv;
        HashMap result2 = new HashMap();
        while ($this$extractColumns.next()) {
            Object object;
            Pair<String, ColumnMetadata> pair = extract.invoke($this$extractColumns);
            String tableName = pair.component1();
            ColumnMetadata columnMetadata = pair.component2();
            Table table = (Table)mapping.get(tableName);
            if (table == null) continue;
            Table table2 = table;
            boolean bl = false;
            int n = 0;
            Table t = table2;
            boolean bl2 = false;
            Map $this$getOrPut$iv = result2;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(t);
            if (value$iv == null) {
                boolean bl3 = false;
                boolean bl4 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(t, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            collection = (Collection)object;
            boolean bl5 = false;
            collection.add(columnMetadata);
        }
        return result2;
    }

    @Override
    @NotNull
    public Map<Table, List<ColumnMetadata>> columns(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        ResultSet rs = this.metadata.getColumns(this.getDatabaseName(), this.getCurrentScheme(), "%", "%");
        Intrinsics.checkNotNullExpressionValue(rs, "rs");
        Map<Table, List<ColumnMetadata>> result2 = this.extractColumns(rs, tables, columns.result.1.INSTANCE);
        rs.close();
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Intrinsics.checkNotNullParameter(tables, "tables");
        Table[] tableArray = tables;
        int n = 0;
        int n2 = tableArray.length;
        while (n < n2) {
            Object object;
            Table table = tableArray[n];
            ++n;
            String tableName = table.nameInDatabaseCase();
            Transaction transaction2 = TransactionManager.Companion.current();
            Map $this$getOrPut$iv = this.existingIndicesCache;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(table);
            if (value$iv == null) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterNotTo$iv$iv;
                void $this$associateByTo$iv$iv;
                boolean isUnique;
                Object it;
                Object object2;
                Object it2;
                boolean bl = false;
                ResultSet resultSet = this.getMetadata().getPrimaryKeys(this.getDatabaseName(), this.getCurrentScheme(), tableName);
                boolean bl2 = false;
                boolean bl3 = false;
                Object rs = resultSet;
                boolean bl4 = false;
                boolean bl5 = false;
                ArrayList names = new ArrayList();
                while (rs.next()) {
                    Unit unit;
                    String string = rs.getString("PK_NAME");
                    if (string == null) {
                        unit = null;
                        continue;
                    }
                    String string2 = string;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    it2 = string2;
                    boolean bl8 = false;
                    object2 = names;
                    boolean bl9 = false;
                    object2.add(it2);
                    unit = Unit.INSTANCE;
                }
                rs.close();
                ArrayList pkNames = names;
                ResultSet rs2 = this.getMetadata().getIndexInfo(this.getDatabaseName(), this.getCurrentScheme(), tableName, false, false);
                bl3 = false;
                HashMap tmpIndices = new HashMap();
                while (rs2.next()) {
                    Object object3;
                    void $this$getOrPut$iv2;
                    Boolean bl10;
                    String string = rs2.getString("INDEX_NAME");
                    if (string == null) {
                        bl10 = null;
                        continue;
                    }
                    rs = string;
                    bl4 = false;
                    bl5 = false;
                    it = rs;
                    boolean bl11 = false;
                    IdentifierManagerApi identifierManagerApi = transaction2.getDb().getIdentifierManager();
                    String string3 = rs2.getString("COLUMN_NAME");
                    Intrinsics.checkNotNull(string3);
                    String column = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string3);
                    isUnique = !rs2.getBoolean("NON_UNIQUE");
                    it2 = tmpIndices;
                    Pair<Object, Boolean> key$iv = TuplesKt.to(it, isUnique);
                    boolean $i$f$getOrPut2 = false;
                    Object value$iv2 = $this$getOrPut$iv2.get(key$iv);
                    if (value$iv2 == null) {
                        boolean bl12 = false;
                        boolean bl13 = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv2.put(key$iv, answer$iv);
                        object3 = answer$iv;
                    } else {
                        object3 = value$iv2;
                    }
                    bl10 = ((List)object3).add(column);
                }
                rs2.close();
                Iterable $this$associateBy$iv = table.getColumns();
                boolean $i$f$associateBy = false;
                int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
                it = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
                boolean $i$f$associateByTo22 = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void it3;
                    Column key$iv = (Column)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl14 = false;
                    String string = transaction2.identity((Column<?>)it3);
                    map2.put(string, element$iv$iv);
                }
                Map tColumns = destination$iv$iv;
                Map $this$filterNot$iv = tmpIndices;
                boolean $i$f$filterNot = false;
                Map capacity$iv22 = $this$filterNot$iv;
                Object destination$iv$iv2 = new LinkedHashMap();
                boolean $i$f$filterNotTo = false;
                void $i$f$associateByTo22 = $this$filterNotTo$iv$iv;
                isUnique = false;
                Iterator iterator2 = $i$f$associateByTo22.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it4 = element$iv$iv = iterator2.next();
                    boolean bl15 = false;
                    if (pkNames.contains(((Pair)it4.getKey()).getFirst())) continue;
                    destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$filterNot$iv = destination$iv$iv2;
                boolean $i$f$mapNotNull = false;
                $this$filterNotTo$iv$iv = $this$mapNotNull$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                iterator2 = $this$forEach$iv$iv$iv;
                boolean bl16 = false;
                object2 = iterator2.entrySet().iterator();
                while (object2.hasNext()) {
                    Index index;
                    void $this$mapNotNullTo$iv$iv2;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = (Map.Entry)object2.next();
                    boolean bl17 = false;
                    Map.Entry $dstr$index$columns = element$iv$iv;
                    boolean bl18 = false;
                    Map.Entry entry = $dstr$index$columns;
                    boolean bl19 = false;
                    Pair index2 = (Pair)entry.getKey();
                    Object object4 = $dstr$index$columns;
                    boolean bl20 = false;
                    List columns2 = (List)object4.getValue();
                    Iterable $this$mapNotNull$iv2 = CollectionsKt.distinct(columns2);
                    boolean $i$f$mapNotNull2 = false;
                    Iterable iterable = $this$mapNotNull$iv2;
                    Collection destination$iv$iv3 = new ArrayList();
                    boolean $i$f$mapNotNullTo2 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach2 = false;
                    Iterator iterator3 = $this$forEach$iv$iv$iv2.iterator();
                    while (iterator3.hasNext()) {
                        Column column;
                        Object element$iv$iv$iv2;
                        Object element$iv$iv2 = element$iv$iv$iv2 = iterator3.next();
                        boolean bl21 = false;
                        String cn = (String)element$iv$iv2;
                        boolean bl22 = false;
                        if ((Column)tColumns.get(cn) == null) continue;
                        boolean bl23 = false;
                        boolean bl24 = false;
                        Column it$iv$iv = column;
                        boolean bl25 = false;
                        destination$iv$iv3.add(it$iv$iv);
                    }
                    Object object5 = (List)destination$iv$iv3;
                    boolean bl26 = false;
                    boolean bl27 = false;
                    Object c = object5;
                    boolean bl28 = false;
                    Object object6 = object4 = c.size() == columns2.size() ? object5 : null;
                    if (object4 == null) {
                        index = null;
                    } else {
                        object5 = object4;
                        bl26 = false;
                        bl27 = false;
                        c = object5;
                        boolean bl29 = false;
                        index = new Index((List)c, (Boolean)index2.getSecond(), (String)index2.getFirst(), null, 8, null);
                    }
                    if (index == null) continue;
                    Index index3 = index;
                    boolean bl30 = false;
                    boolean bl31 = false;
                    Index it$iv$iv = index3;
                    boolean bl32 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                List answer$iv = (List)destination$iv$iv2;
                $this$getOrPut$iv.put(table, answer$iv);
                object = answer$iv;
                continue;
            }
            object = value$iv;
        }
        return new HashMap(this.existingIndicesCache);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public synchronized Map<String, List<ForeignKeyConstraint>> tableConstraints(@NotNull List<? extends Table> tables) {
        String string;
        Map map2;
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(tables, "tables");
        Iterable $this$associateBy$iv = SchemaUtils.INSTANCE.sortTablesByReferences((Iterable<? extends Table>)tables);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            Table table = (Table)element$iv$iv2;
            map2 = destination$iv$iv;
            boolean bl = false;
            string = it.nameInDatabaseCase();
            map2.put(string, element$iv$iv2);
        }
        Map allTables = destination$iv$iv;
        Iterable $this$associateWith$iv = allTables.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void table;
            Object element$iv$iv2;
            element$iv$iv2 = (String)element$iv$iv;
            string = element$iv$iv;
            map2 = result$iv;
            boolean bl = false;
            ResultSet resultSet = this.getMetadata().getImportedKeys(this.getDatabaseName(), this.getCurrentScheme(), (String)table);
            Intrinsics.checkNotNullExpressionValue(resultSet, "metadata.getImportedKeys(databaseName, currentScheme, table)");
            List list = CollectionsKt.filterNotNull(JdbcDatabaseMetadataImplKt.access$iterate(resultSet, new Function1<ResultSet, ForeignKeyConstraint>(this, (Map<String, ? extends Table>)allTables){
                final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
                final /* synthetic */ Map<String, Table> $allTables;
                {
                    this.this$0 = $receiver;
                    this.$allTables = $allTables;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final ForeignKeyConstraint invoke(@NotNull ResultSet $this$iterate) {
                    T element$iv3;
                    String constraintName;
                    Column fromColumn;
                    block4: {
                        void $this$first$iv;
                        Object v3;
                        Object element$iv22;
                        block3: {
                            void $this$firstOrNull$iv;
                            Intrinsics.checkNotNullParameter($this$iterate, "$this$iterate");
                            String string = $this$iterate.getString("FKTABLE_NAME");
                            Intrinsics.checkNotNull(string);
                            String fromTableName = string;
                            IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                            String string2 = $this$iterate.getString("FKCOLUMN_NAME");
                            Intrinsics.checkNotNull(string2);
                            String fromColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string2);
                            Iterable iterable = MapsKt.getValue(this.$allTables, fromTableName).getColumns();
                            JdbcDatabaseMetadataImpl jdbcDatabaseMetadataImpl = this.this$0;
                            boolean $i$f$firstOrNull = false;
                            for (Object element$iv22 : $this$firstOrNull$iv) {
                                Column it = (Column)element$iv22;
                                boolean bl = false;
                                if (!Intrinsics.areEqual(jdbcDatabaseMetadataImpl.getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.getName()), fromColumnName)) continue;
                                v3 = element$iv22;
                                break block3;
                            }
                            v3 = null;
                        }
                        Column column = v3;
                        if (column == null) {
                            return null;
                        }
                        fromColumn = column;
                        String string = $this$iterate.getString("FK_NAME");
                        Intrinsics.checkNotNull(string);
                        constraintName = string;
                        String string3 = $this$iterate.getString("PKTABLE_NAME");
                        Intrinsics.checkNotNull(string3);
                        String targetTableName = string3;
                        IdentifierManagerApi identifierManagerApi = this.this$0.getIdentifierManager();
                        String string4 = $this$iterate.getString("PKCOLUMN_NAME");
                        Intrinsics.checkNotNull(string4);
                        String targetColumnName = identifierManagerApi.quoteIdentifierWhenWrongCaseOrNecessary(string4);
                        Iterable iterable = MapsKt.getValue(this.$allTables, targetTableName).getColumns();
                        element$iv22 = this.this$0;
                        boolean $i$f$first = false;
                        for (T element$iv3 : $this$first$iv) {
                            Column it = (Column)element$iv3;
                            boolean bl = false;
                            if (!Intrinsics.areEqual(((JdbcDatabaseMetadataImpl)element$iv22).getIdentifierManager().quoteIdentifierWhenWrongCaseOrNecessary(it.nameInDatabaseCase()), targetColumnName)) continue;
                            break block4;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    Column targetColumn = (Column)element$iv3;
                    ReferenceOption constraintUpdateRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("UPDATE_RULE"));
                    ReferenceOption constraintDeleteRule = ReferenceOption.Companion.resolveRefOptionFromJdbc($this$iterate.getInt("DELETE_RULE"));
                    return new ForeignKeyConstraint(targetColumn, fromColumn, constraintUpdateRule, constraintDeleteRule, constraintName);
                }
            }));
            map2.put(string, list);
        }
        return result$iv;
    }

    @Override
    public synchronized void cleanCache() {
        this.existingIndicesCache.clear();
    }

    private final <T> Lazy<T> lazyMetadata(Function1<? super DatabaseMetaData, ? extends T> body) {
        return LazyKt.lazy(new Function0<T>(body, this){
            final /* synthetic */ Function1<DatabaseMetaData, T> $body;
            final /* synthetic */ JdbcDatabaseMetadataImpl this$0;
            {
                this.$body = $body;
                this.this$0 = $receiver;
                super(0);
            }

            public final T invoke() {
                return this.$body.invoke(this.this$0.getMetadata());
            }
        });
    }

    public static final /* synthetic */ List access$tableNamesFor(JdbcDatabaseMetadataImpl $this, String scheme2) {
        return $this.tableNamesFor(scheme2);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getIdentityManagerCache$cp() {
        return identityManagerCache;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0082\u0004\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003B/\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00028\u0001H\u0096\u0001\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010 \u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001bH\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r0\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006#"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$CachableMapWithDefault;", "K", "V", "", "map", "", "default", "Lkotlin/Function1;", "(Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl;Ljava/util/Map;Lkotlin/jvm/functions/Function1;)V", "getDefault", "()Lkotlin/jvm/functions/Function1;", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keys", "getKeys", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", "isEmpty", "exposed-jdbc"})
    private final class CachableMapWithDefault<K, V>
    implements Map<K, V>,
    KMappedMarker {
        @NotNull
        private final Map<K, V> map;
        @NotNull
        private final Function1<K, V> default;

        public CachableMapWithDefault(@NotNull Map<K, V> map2, Function1<? super K, ? extends V> function1) {
            Intrinsics.checkNotNullParameter(JdbcDatabaseMetadataImpl.this, "this$0");
            Intrinsics.checkNotNullParameter(map2, "map");
            Intrinsics.checkNotNullParameter(function1, "default");
            this.map = map2;
            this.default = function1;
        }

        public /* synthetic */ CachableMapWithDefault(Map map2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                boolean bl = false;
                map2 = new LinkedHashMap();
            }
            this(map2, function1);
        }

        @NotNull
        public final Function1<K, V> getDefault() {
            return this.default;
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @NotNull
        public Set<Map.Entry<K, V>> getEntries() {
            return this.map.entrySet();
        }

        @NotNull
        public Set<K> getKeys() {
            return this.map.keySet();
        }

        public int getSize() {
            return this.map.size();
        }

        @NotNull
        public Collection<V> getValues() {
            return this.map.values();
        }

        @Override
        @Nullable
        public V get(Object key) {
            V v;
            Map<Object, V> $this$getOrPut$iv = this.map;
            boolean $i$f$getOrPut = false;
            V value$iv = $this$getOrPut$iv.get(key);
            if (value$iv == null) {
                boolean bl = false;
                V answer$iv = this.getDefault().invoke(key);
                $this$getOrPut$iv.put(key, answer$iv);
                v = answer$iv;
            } else {
                v = value$iv;
            }
            return v;
        }

        @Override
        public boolean containsKey(Object key) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V merge(K p0, V p1, BiFunction<? super V, ? super V, ? extends V> p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfPresent(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V computeIfAbsent(K p0, Function<? super K, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V putIfAbsent(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> from) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean replace(K p0, V p1, V p2) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V compute(K p0, BiFunction<? super K, ? super V, ? extends V> p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public V replace(K p0, V p1) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcDatabaseMetadataImpl$Companion;", "", "()V", "identityManagerCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/exposed/sql/statements/jdbc/JdbcIdentifierManager;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

