/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.dao.id.EntityID;
import org.jetbrains.exposed.dao.id.IdTable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.UpdateStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\bJ\"\u0010\u0017\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u00180\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J6\u0010\u001e\u001a\u00020\u001f\"\u0004\b\u0000\u0010 \"\n\b\u0001\u0010!*\u0004\u0018\u0001H 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H 0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H!0$H\u0016J\u0019\u0010%\u001a\u00020&*\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010(R9\u0010\u0005\u001a*\u0012&\u0012$\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\t0\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR,\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00070\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006)\u00b2\u0006\u0014\u0010*\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0+X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/exposed/sql/statements/BatchUpdateStatement;", "Lorg/jetbrains/exposed/sql/statements/UpdateStatement;", "table", "Lorg/jetbrains/exposed/dao/id/IdTable;", "(Lorg/jetbrains/exposed/dao/id/IdTable;)V", "data", "Ljava/util/ArrayList;", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/dao/id/EntityID;", "", "Lorg/jetbrains/exposed/sql/Column;", "", "getData", "()Ljava/util/ArrayList;", "firstDataSet", "", "getFirstDataSet", "()Ljava/util/List;", "getTable", "()Lorg/jetbrains/exposed/dao/id/IdTable;", "addBatch", "", "id", "arguments", "", "Lorg/jetbrains/exposed/sql/IColumnType;", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "update", "", "T", "S", "column", "value", "Lorg/jetbrains/exposed/sql/Expression;", "executeInternal", "", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "(Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;Lorg/jetbrains/exposed/sql/Transaction;)Ljava/lang/Integer;", "exposed-core", "different", ""})
public class BatchUpdateStatement
extends UpdateStatement {
    @NotNull
    private final IdTable<?> table;
    @NotNull
    private final ArrayList<Pair<EntityID<?>, Map<Column<?>, Object>>> data;

    public BatchUpdateStatement(@NotNull IdTable<?> table) {
        Intrinsics.checkNotNullParameter(table, "table");
        super(table, null, null, 4, null);
        this.table = table;
        this.data = new ArrayList();
    }

    @NotNull
    public final IdTable<?> getTable() {
        return this.table;
    }

    @NotNull
    public final ArrayList<Pair<EntityID<?>, Map<Column<?>, Object>>> getData() {
        return this.data;
    }

    @Override
    @NotNull
    public List<Pair<Column<?>, Object>> getFirstDataSet() {
        return MapsKt.toList((Map)((Pair)CollectionsKt.first((List)this.data)).getSecond());
    }

    public final void addBatch(@NotNull EntityID<?> id2) {
        boolean bl;
        Collection collection;
        Intrinsics.checkNotNullParameter(id2, "id");
        Pair lastBatch = (Pair)CollectionsKt.lastOrNull((List)this.data);
        Lazy different$delegate = LazyKt.lazy(new Function0<Set<? extends Column<?>>>(this, lastBatch){
            final /* synthetic */ BatchUpdateStatement this$0;
            final /* synthetic */ Pair<EntityID<?>, Map<Column<?>, Object>> $lastBatch;
            {
                this.this$0 = $receiver;
                this.$lastBatch = $lastBatch;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Set<Column<?>> invoke() {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.this$0.getFirstDataSet();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Column column = (Column)it.getFirst();
                    collection.add(column);
                }
                Set<T> set1 = CollectionsKt.toSet((List)destination$iv$iv);
                Pair<EntityID<?>, Map<Column<?>, Object>> pair = this.$lastBatch;
                Intrinsics.checkNotNull(pair);
                Set<Column<?>> set2 = pair.getSecond().keySet();
                return SetsKt.plus(SetsKt.minus(set1, (Iterable)set2), (Iterable)SetsKt.minus(set2, (Iterable)set1));
            }
        });
        if (this.data.size() > 1) {
            collection = BatchUpdateStatement.addBatch$lambda-0(different$delegate);
            bl = false;
            if (!collection.isEmpty()) {
                throw new BatchDataInconsistentException(Intrinsics.stringPlus("Some values missing for batch update. Different columns: ", BatchUpdateStatement.addBatch$lambda-0(different$delegate)));
            }
        }
        collection = this.data;
        bl = false;
        if (!collection.isEmpty()) {
            int n = this.data.size() - 1;
            Pair pair = lastBatch;
            Intrinsics.checkNotNull(pair);
            this.data.set(n, Pair.copy$default(pair, null, MapsKt.toMap(this.getValues()), 1, null));
            this.getValues().clear();
            this.setHasBathedValues(true);
        }
        this.data.add(TuplesKt.to(id2, this.getValues()));
    }

    @NotNull
    public <T, S extends T> Void update(@NotNull Column<T> column, @NotNull Expression<S> value) {
        Intrinsics.checkNotNullParameter(column, "column");
        Intrinsics.checkNotNullParameter(value, "value");
        String string = "Expressions unsupported in batch update";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        return super.prepareSQL(transaction2) + " WHERE " + transaction2.identity(this.table.getId()) + " = ?";
    }

    @Override
    @NotNull
    public Integer executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        return this.data.size() == 1 ? $this$executeInternal.executeUpdate() : CollectionsKt.sumOfInt((Iterable<Integer>)$this$executeInternal.executeBatch());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType, Object>>> arguments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.data;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $dstr$id$row;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            EntityID id2 = (EntityID)$dstr$id$row.component1();
            Map row = (Map)$dstr$id$row.component2();
            Iterable $this$map$iv2 = this.getFirstDataSet();
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                Pair pair2 = (Pair)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                Pair pair3 = TuplesKt.to(((Column)it.getFirst()).getColumnType(), row.get(it.getFirst()));
                collection2.add(pair3);
            }
            List<Pair<IColumnType, EntityID>> list = CollectionsKt.plus((Collection)((List)destination$iv$iv2), TuplesKt.to(this.getTable().getId().getColumnType(), id2));
            collection.add(list);
        }
        return (List)destination$iv$iv;
    }

    private static final Set<Column<?>> addBatch$lambda-0(Lazy<? extends Set<? extends Column<?>>> different$delegate) {
        Lazy<Set<Column<?>>> lazy = different$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return lazy.getValue();
    }
}

