/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.AbstractQuery;
import org.jetbrains.exposed.sql.AliasKt;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnSet;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionAlias;
import org.jetbrains.exposed.sql.FieldSet;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.QueriesKt;
import org.jetbrains.exposed.sql.Query;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SqlExpressionBuilder;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TableKt;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.Statement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u001f\u0010\u001d\u001a\u00020\u00002\u0017\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0\u001f\u00a2\u0006\u0002\b!J%\u0010\"\u001a\u00020\u00002\u001d\u0010\u001e\u001a\u0019\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030#\u00a2\u0006\u0002\b!J-\u0010$\u001a\u00020\u00002%\u0010\u001e\u001a!\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001f\u00a2\u0006\u0002\b!J\b\u0010%\u001a\u00020\u0000H\u0016J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J'\u0010)\u001a\u00020\u00002\u001a\u0010*\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0+\"\u0006\u0012\u0002\b\u00030\f\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0006J%\u0010\u0010\u001a\u00020\u00002\u001d\u0010.\u001a\u0019\u0012\u0004\u0012\u00020/\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u001f\u00a2\u0006\u0002\b!J\u0006\u00100\u001a\u00020\u0006J\b\u00101\u001a\u00020\u0000H\u0016J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0016\u00106\u001a\u0004\u0018\u00010\u0015*\u0002072\u0006\u00108\u001a\u000209H\u0016R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR2\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b2\u0010\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR.\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR.\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006:"}, d2={"Lorg/jetbrains/exposed/sql/Query;", "Lorg/jetbrains/exposed/sql/AbstractQuery;", "set", "Lorg/jetbrains/exposed/sql/FieldSet;", "where", "Lorg/jetbrains/exposed/sql/Op;", "", "(Lorg/jetbrains/exposed/sql/FieldSet;Lorg/jetbrains/exposed/sql/Op;)V", "forUpdate", "Ljava/lang/Boolean;", "<set-?>", "", "Lorg/jetbrains/exposed/sql/Expression;", "groupedByColumns", "getGroupedByColumns", "()Ljava/util/List;", "having", "getHaving", "()Lorg/jetbrains/exposed/sql/Op;", "queryToExecute", "Lorg/jetbrains/exposed/sql/statements/Statement;", "Ljava/sql/ResultSet;", "getQueryToExecute", "()Lorg/jetbrains/exposed/sql/statements/Statement;", "getSet", "()Lorg/jetbrains/exposed/sql/FieldSet;", "setSet", "(Lorg/jetbrains/exposed/sql/FieldSet;)V", "getWhere", "adjustColumnSet", "body", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/sql/ColumnSet;", "Lkotlin/ExtensionFunctionType;", "adjustSlice", "Lkotlin/Function2;", "adjustWhere", "copy", "count", "", "empty", "groupBy", "columns", "", "([Lorg/jetbrains/exposed/sql/Expression;)Lorg/jetbrains/exposed/sql/Query;", "hasCustomForUpdateState", "op", "Lorg/jetbrains/exposed/sql/SqlExpressionBuilder;", "isForUpdate", "notForUpdate", "prepareSQL", "", "builder", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "executeInternal", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "exposed-core"})
public class Query
extends AbstractQuery<Query> {
    @NotNull
    private FieldSet set;
    @NotNull
    private List<? extends Expression<?>> groupedByColumns;
    @Nullable
    private Op<Boolean> having;
    @Nullable
    private Boolean forUpdate;
    @Nullable
    private Op<Boolean> where;

    public Query(@NotNull FieldSet set, @Nullable Op<Boolean> where) {
        Intrinsics.checkNotNullParameter(set, "set");
        super(TableKt.targetTables(set.getSource()));
        this.set = set;
        boolean bl = false;
        this.groupedByColumns = new ArrayList();
        this.where = where;
    }

    @Override
    @NotNull
    public FieldSet getSet() {
        return this.set;
    }

    public void setSet(@NotNull FieldSet fieldSet) {
        Intrinsics.checkNotNullParameter(fieldSet, "<set-?>");
        this.set = fieldSet;
    }

    @NotNull
    public final List<Expression<?>> getGroupedByColumns() {
        return this.groupedByColumns;
    }

    @Nullable
    public final Op<Boolean> getHaving() {
        return this.having;
    }

    @Nullable
    public final Op<Boolean> getWhere() {
        return this.where;
    }

    @Override
    @NotNull
    protected Statement<ResultSet> getQueryToExecute() {
        List distinctExpressions = CollectionsKt.distinct((Iterable)this.getSet().getFields());
        return distinctExpressions.size() < this.getSet().getFields().size() ? (Statement)this.copy().adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(distinctExpressions){
            final /* synthetic */ List<Expression<?>> $distinctExpressions;
            {
                this.$distinctExpressions = $distinctExpressions;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                Intrinsics.checkNotNullParameter(it, "it");
                return $this$adjustSlice.slice(this.$distinctExpressions);
            }
        }) : (Statement)this;
    }

    @NotNull
    public Query copy() {
        Query query = new Query(this.getSet(), this.where);
        boolean bl = false;
        boolean bl2 = false;
        Query copy = query;
        boolean bl3 = false;
        this.copyTo(copy);
        copy.groupedByColumns = CollectionsKt.toMutableList((Collection)this.getGroupedByColumns());
        copy.having = this.getHaving();
        copy.forUpdate = this.forUpdate;
        return query;
    }

    @NotNull
    public Query forUpdate() {
        this.forUpdate = true;
        return this;
    }

    @NotNull
    public Query notForUpdate() {
        this.forUpdate = false;
        return this;
    }

    @NotNull
    public final Query adjustSlice(@NotNull Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        Query query = this;
        boolean bl = false;
        boolean bl2 = false;
        Query $this$adjustSlice_u24lambda_u2d1 = query;
        boolean bl3 = false;
        $this$adjustSlice_u24lambda_u2d1.setSet(body.invoke($this$adjustSlice_u24lambda_u2d1.getSet().getSource(), $this$adjustSlice_u24lambda_u2d1.getSet()));
        return query;
    }

    @NotNull
    public final Query adjustColumnSet(@NotNull Function1<? super ColumnSet, ? extends ColumnSet> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        return this.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(body){
            final /* synthetic */ Function1<ColumnSet, ColumnSet> $body;
            {
                this.$body = $body;
                super(2);
            }

            @NotNull
            public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet oldSlice) {
                Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                Intrinsics.checkNotNullParameter(oldSlice, "oldSlice");
                return this.$body.invoke($this$adjustSlice).slice(oldSlice.getFields());
            }
        });
    }

    @NotNull
    public final Query adjustWhere(@NotNull Function1<? super Op<Boolean>, ? extends Op<Boolean>> body) {
        Intrinsics.checkNotNullParameter(body, "body");
        Query query = this;
        boolean bl = false;
        boolean bl2 = false;
        Query $this$adjustWhere_u24lambda_u2d2 = query;
        boolean bl3 = false;
        $this$adjustWhere_u24lambda_u2d2.where = body.invoke($this$adjustWhere_u24lambda_u2d2.getWhere());
        return query;
    }

    public final boolean hasCustomForUpdateState() {
        return this.forUpdate != null;
    }

    public final boolean isForUpdate() {
        Boolean bl = this.forUpdate;
        return (bl == null ? false : bl) && DefaultKt.getCurrentDialect().supportsSelectForUpdate();
    }

    @Override
    @Nullable
    public ResultSet executeInternal(@NotNull PreparedStatementApi $this$executeInternal, @NotNull Transaction transaction2) {
        Integer fetchSize;
        Intrinsics.checkNotNullParameter($this$executeInternal, "<this>");
        Intrinsics.checkNotNullParameter(transaction2, "transaction");
        Integer n = this.getFetchSize();
        Integer n2 = fetchSize = n == null ? transaction2.getDb().getDefaultFetchSize() : n;
        if (fetchSize != null) {
            $this$executeInternal.setFetchSize(fetchSize);
        }
        return $this$executeInternal.executeQuery();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        builder.invoke((Function1<? super QueryBuilder, Unit>)new Function1<QueryBuilder, Unit>(this){
            final /* synthetic */ Query this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull QueryBuilder $this$invoke) {
                Op<Boolean> it;
                boolean bl;
                boolean bl2;
                Object object;
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.append("SELECT ");
                if (this.this$0.getCount()) {
                    $this$invoke.append("COUNT(*)");
                } else {
                    if (this.this$0.getDistinct()) {
                        $this$invoke.append("DISTINCT ");
                    }
                    QueryBuilder.appendTo$default($this$invoke, this.this$0.getSet().getRealFields(), null, null, null, (Function2)prepareSQL.1.INSTANCE, 7, null);
                }
                if (!Intrinsics.areEqual(this.this$0.getSet().getSource(), Table.Dual.INSTANCE) || DefaultKt.getCurrentDialect().getSupportsDualTableConcept()) {
                    $this$invoke.append(" FROM ");
                    this.this$0.getSet().getSource().describe(this.this$0.getTransaction(), $this$invoke);
                }
                if ((object = this.this$0.getWhere()) != null) {
                    Op<Boolean> op = object;
                    bl2 = false;
                    bl = false;
                    it = op;
                    boolean bl3 = false;
                    $this$invoke.append(" WHERE ");
                    $this$invoke.unaryPlus((Expression)it);
                }
                if (!this.this$0.getCount()) {
                    object = this.this$0.getGroupedByColumns();
                    boolean bl4 = false;
                    if (!object.isEmpty()) {
                        $this$invoke.append(" GROUP BY ");
                        QueryBuilder.appendTo$default($this$invoke, this.this$0.getGroupedByColumns(), null, null, null, (Function2)prepareSQL.3.INSTANCE, 7, null);
                    }
                    if ((object = this.this$0.getHaving()) != null) {
                        Op<Boolean> op = object;
                        bl2 = false;
                        bl = false;
                        it = op;
                        boolean bl5 = false;
                        $this$invoke.append(" HAVING ");
                        $this$invoke.append((Expression)it);
                    }
                    object = this.this$0.getOrderByExpressions();
                    boolean bl6 = false;
                    if (!object.isEmpty()) {
                        $this$invoke.append(" ORDER BY ");
                        QueryBuilder.appendTo$default($this$invoke, this.this$0.getOrderByExpressions(), null, null, null, (Function2)prepareSQL.5.INSTANCE, 7, null);
                    }
                    if ((object = this.this$0.getLimit()) != null) {
                        Object object2 = object;
                        Query query = this.this$0;
                        bl = false;
                        boolean bl7 = false;
                        int it2 = ((Number)object2).intValue();
                        boolean bl8 = false;
                        $this$invoke.append(" ");
                        Collection collection = query.getOrderByExpressions();
                        boolean bl9 = false;
                        $this$invoke.append(DefaultKt.getCurrentDialect().getFunctionProvider().queryLimit(it2, query.getOffset(), !collection.isEmpty()));
                    }
                }
                if (this.this$0.isForUpdate()) {
                    $this$invoke.append(" FOR UPDATE");
                }
            }
        });
        return builder.toString();
    }

    @NotNull
    public final Query groupBy(Expression<?> ... columns2) {
        Intrinsics.checkNotNullParameter(columns2, "columns");
        for (Expression<?> column : columns2) {
            TypeIntrinsics.asMutableList(this.groupedByColumns).add(column);
        }
        return this;
    }

    @NotNull
    public final Query having(@NotNull Function1<? super SqlExpressionBuilder, ? extends Op<Boolean>> op) {
        Intrinsics.checkNotNullParameter(op, "op");
        Op<Boolean> oop = op.invoke(SqlExpressionBuilder.INSTANCE);
        if (this.having != null) {
            String string = "HAVING clause is specified twice. Old value = '" + this.having + "', new value = '" + oop + '\'';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.having = oop;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long count() {
        long l;
        long l2;
        block10: {
            long l3;
            block9: {
                if (this.getDistinct()) break block9;
                Collection collection = this.groupedByColumns;
                boolean bl = false;
                if (!(!collection.isEmpty()) && this.getLimit() == null) break block10;
            }
            FieldSet originalSet = this.getSet();
            try {
                Ref.IntRef expInx = new Ref.IntRef();
                this.adjustSlice((Function2<? super ColumnSet, ? super FieldSet, ? extends FieldSet>)new Function2<ColumnSet, FieldSet, FieldSet>(originalSet, expInx, this){
                    final /* synthetic */ FieldSet $originalSet;
                    final /* synthetic */ Ref.IntRef $expInx;
                    final /* synthetic */ Query this$0;
                    {
                        this.$originalSet = $originalSet;
                        this.$expInx = $expInx;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final FieldSet invoke(@NotNull ColumnSet $this$adjustSlice, @NotNull FieldSet it) {
                        Collection<ExpressionAlias<T>> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter($this$adjustSlice, "$this$adjustSlice");
                        Intrinsics.checkNotNullParameter(it, "it");
                        Iterable iterable = this.$originalSet.getFields();
                        Ref.IntRef intRef = this.$expInx;
                        Query query = this.this$0;
                        ColumnSet columnSet = $this$adjustSlice;
                        boolean $i$f$map = false;
                        void var7_8 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            ExpressionAlias<T> expressionAlias;
                            void it2;
                            ExpressionAlias<T> expressionAlias2;
                            Expression expression = (Expression)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            ExpressionAlias<T> expressionAlias3 = expressionAlias2 = it2 instanceof ExpressionAlias ? (ExpressionAlias<T>)it2 : null;
                            if (expressionAlias2 == null) {
                                Column column;
                                Column column2 = column = it2 instanceof Column ? (Column)it2 : null;
                                if (column == null) {
                                    int n = intRef.element;
                                    intRef.element = n + 1;
                                    expressionAlias = AliasKt.alias(it2, Intrinsics.stringPlus("exp", n));
                                } else {
                                    expressionAlias = Query.access$count$makeAlias(column, query);
                                }
                            } else {
                                expressionAlias = expressionAlias2;
                            }
                            ExpressionAlias<T> expressionAlias4 = expressionAlias;
                            collection.add(expressionAlias4);
                        }
                        collection = (List)destination$iv$iv;
                        return columnSet.slice((List<? extends Expression<?>>)collection);
                    }
                });
                l3 = QueriesKt.selectAll(AliasKt.alias((AbstractQuery)this, "subquery")).count();
            }
            finally {
                this.setSet(originalSet);
            }
            l2 = l3;
            return l2;
        }
        try {
            this.setCount(true);
            Object r = this.getTransaction().exec(this, count.2.INSTANCE);
            Intrinsics.checkNotNull(r);
            l = ((Number)r).longValue();
        }
        finally {
            this.setCount(false);
        }
        l2 = l;
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean empty() {
        Integer oldLimit = this.getLimit();
        try {
            if (!this.isForUpdate()) {
                this.setLimit(1);
            }
            Object t = this.getTransaction().exec(this);
            Intrinsics.checkNotNull(t);
            ResultSet resultSet = (ResultSet)t;
            boolean bl = resultSet.next();
            boolean bl2 = false;
            boolean bl3 = false;
            boolean it = bl;
            boolean bl4 = false;
            resultSet.close();
            bl = !bl;
            return bl;
        }
        finally {
            this.setLimit(oldLimit);
        }
    }

    private static final ExpressionAlias<? extends Object> count$makeAlias(Column<?> $this$count_u24makeAlias, Query this$0) {
        return AliasKt.alias($this$count_u24makeAlias, this$0.getTransaction().getDb().getIdentifierManager().quoteIfNecessary($this$count_u24makeAlias.getTable().getTableName() + '_' + $this$count_u24makeAlias.getName()));
    }

    public static final /* synthetic */ ExpressionAlias access$count$makeAlias(Column $receiver, Query this$0) {
        return Query.count$makeAlias($receiver, this$0);
    }
}

