/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/exposed/sql/EnumerationColumnType;", "T", "", "Lorg/jetbrains/exposed/sql/ColumnType;", "klass", "Lkotlin/reflect/KClass;", "(Lkotlin/reflect/KClass;)V", "getKlass", "()Lkotlin/reflect/KClass;", "equals", "", "other", "", "hashCode", "", "notNullValueToDB", "value", "(Ljava/lang/Object;)Ljava/lang/Integer;", "sqlType", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Enum;", "exposed-core"})
public final class EnumerationColumnType<T extends Enum<T>>
extends ColumnType {
    @NotNull
    private final KClass<T> klass;

    public EnumerationColumnType(@NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        super(false, 1, null);
        this.klass = klass;
    }

    @NotNull
    public final KClass<T> getKlass() {
        return this.klass;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().integerType();
    }

    @NotNull
    public T valueFromDB(@NotNull Object value) {
        Enum enum_;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Number) {
            KClass<T>[] kClassArray = JvmClassMappingKt.getJavaClass(this.klass).getEnumConstants();
            Intrinsics.checkNotNull(kClassArray);
            Enum enum_2 = ((Enum[])kClassArray)[((Number)value).intValue()];
            Intrinsics.checkNotNullExpressionValue(enum_2, "klass.java.enumConstants!![value.toInt()]");
            enum_ = enum_2;
        } else if (object instanceof Enum) {
            enum_ = (Enum)value;
        } else {
            String string = value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getSimpleName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return (T)enum_;
    }

    @Override
    @NotNull
    public Integer notNullValueToDB(@NotNull Object value) {
        int n;
        Intrinsics.checkNotNullParameter(value, "value");
        Object object = value;
        if (object instanceof Integer) {
            n = ((Number)value).intValue();
        } else if (object instanceof Enum) {
            n = ((Enum)value).ordinal();
        } else {
            String string = value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName() + " is not valid for enum " + this.klass.getSimpleName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.exposed.sql.EnumerationColumnType<*>");
        }
        EnumerationColumnType cfr_ignored_0 = (EnumerationColumnType)other;
        return Intrinsics.areEqual(this.klass, ((EnumerationColumnType)other).klass);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.klass.hashCode();
        return result2;
    }
}

