/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Op;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.api.IdentifierManagerApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.MysqlDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012H\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint;", "Lorg/jetbrains/exposed/sql/DdlAware;", "tableName", "", "checkName", "checkOp", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCheckName", "()Ljava/lang/String;", "getCheckOp", "checkPart", "getCheckPart$exposed_core", "getTableName", "component1", "component2", "component3", "copy", "createStatement", "", "dropStatement", "equals", "", "other", "", "hashCode", "", "modifyStatement", "toString", "Companion", "exposed-core"})
public final class CheckConstraint
implements DdlAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tableName;
    @NotNull
    private final String checkName;
    @NotNull
    private final String checkOp;
    @NotNull
    private final String checkPart;

    public CheckConstraint(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(checkName, "checkName");
        Intrinsics.checkNotNullParameter(checkOp, "checkOp");
        this.tableName = tableName;
        this.checkName = checkName;
        this.checkOp = checkOp;
        this.checkPart = "CONSTRAINT " + this.checkName + " CHECK (" + this.checkOp + ')';
    }

    @NotNull
    public final String getTableName() {
        return this.tableName;
    }

    @NotNull
    public final String getCheckName() {
        return this.checkName;
    }

    @NotNull
    public final String getCheckOp() {
        return this.checkOp;
    }

    @NotNull
    public final String getCheckPart$exposed_core() {
        return this.checkPart;
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        List<String> list;
        if (DefaultKt.getCurrentDialect() instanceof MysqlDialect) {
            SQLLogKt.getExposedLogger().warn("Creation of CHECK constraints is not currently supported by MySQL");
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.listOf("ALTER TABLE " + this.tableName + " ADD " + this.checkPart);
        }
        return list;
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return CollectionsKt.plus((Collection)this.dropStatement(), (Iterable)this.createStatement());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        List<String> list;
        if (DefaultKt.getCurrentDialect() instanceof MysqlDialect) {
            SQLLogKt.getExposedLogger().warn("Deletion of CHECK constraints is not currently supported by MySQL");
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.listOf("ALTER TABLE " + this.tableName + " DROP CONSTRAINT " + this.checkName);
        }
        return list;
    }

    @NotNull
    public final String component1() {
        return this.tableName;
    }

    @NotNull
    public final String component2() {
        return this.checkName;
    }

    @NotNull
    public final String component3() {
        return this.checkOp;
    }

    @NotNull
    public final CheckConstraint copy(@NotNull String tableName, @NotNull String checkName, @NotNull String checkOp) {
        Intrinsics.checkNotNullParameter(tableName, "tableName");
        Intrinsics.checkNotNullParameter(checkName, "checkName");
        Intrinsics.checkNotNullParameter(checkOp, "checkOp");
        return new CheckConstraint(tableName, checkName, checkOp);
    }

    public static /* synthetic */ CheckConstraint copy$default(CheckConstraint checkConstraint, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = checkConstraint.tableName;
        }
        if ((n & 2) != 0) {
            string2 = checkConstraint.checkName;
        }
        if ((n & 4) != 0) {
            string3 = checkConstraint.checkOp;
        }
        return checkConstraint.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "CheckConstraint(tableName=" + this.tableName + ", checkName=" + this.checkName + ", checkOp=" + this.checkOp + ')';
    }

    public int hashCode() {
        int result2 = this.tableName.hashCode();
        result2 = result2 * 31 + this.checkName.hashCode();
        result2 = result2 * 31 + this.checkOp.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CheckConstraint)) {
            return false;
        }
        CheckConstraint checkConstraint = (CheckConstraint)other;
        if (!Intrinsics.areEqual(this.tableName, checkConstraint.tableName)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.checkName, checkConstraint.checkName)) {
            return false;
        }
        return Intrinsics.areEqual(this.checkOp, checkConstraint.checkOp);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u00a2\u0006\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/exposed/sql/CheckConstraint$Companion;", "", "()V", "from", "Lorg/jetbrains/exposed/sql/CheckConstraint;", "table", "Lorg/jetbrains/exposed/sql/Table;", "name", "", "op", "Lorg/jetbrains/exposed/sql/Op;", "", "from$exposed_core", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckConstraint from$exposed_core(@NotNull Table table, @NotNull String name, @NotNull Op<Boolean> op) {
            Intrinsics.checkNotNullParameter(table, "table");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(op, "op");
            CharSequence charSequence = name;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank(charSequence);
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Check constraint name cannot be blank";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Transaction tr = TransactionManager.Companion.current();
            IdentifierManagerApi identifierManager2 = tr.getDb().getIdentifierManager();
            String tableName = tr.identity(table);
            String checkOpSQL = StringsKt.replace$default(op.toString(), Intrinsics.stringPlus(tableName, "."), "", false, 4, null);
            return new CheckConstraint(tableName, identifierManager2.cutIfNecessaryAndQuote(name), checkOpSQL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

