/*
 * Decompiled with CFR 0.152.
 */
package org.h2.mvstore.rtree;

import java.util.ArrayList;
import java.util.Iterator;
import org.h2.mvstore.CursorPos;
import org.h2.mvstore.DataUtils;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.Page;
import org.h2.mvstore.rtree.SpatialDataType;
import org.h2.mvstore.rtree.SpatialKey;
import org.h2.mvstore.type.DataType;
import org.h2.mvstore.type.ObjectDataType;
import org.h2.util.New;

public class MVRTreeMap<V>
extends MVMap<SpatialKey, V> {
    final SpatialDataType keyType = (SpatialDataType)this.getKeyType();
    private boolean quadraticSplit;

    public MVRTreeMap(int n, DataType dataType) {
        super(new SpatialDataType(n), dataType);
    }

    public static <V> MVRTreeMap<V> create(int n, DataType dataType) {
        return new MVRTreeMap<V>(n, dataType);
    }

    @Override
    public V get(Object object) {
        return (V)this.get(this.root, object);
    }

    public RTreeCursor findIntersectingKeys(SpatialKey spatialKey) {
        return new RTreeCursor(this.root, spatialKey){

            @Override
            protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
                return MVRTreeMap.this.keyType.isOverlap(spatialKey, spatialKey2);
            }
        };
    }

    public RTreeCursor findContainedKeys(SpatialKey spatialKey) {
        return new RTreeCursor(this.root, spatialKey){

            @Override
            protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
                if (bl) {
                    return MVRTreeMap.this.keyType.isInside(spatialKey, spatialKey2);
                }
                return MVRTreeMap.this.keyType.isOverlap(spatialKey, spatialKey2);
            }
        };
    }

    private boolean contains(Page page, int n, Object object) {
        return this.keyType.contains(page.getKey(n), object);
    }

    protected Object get(Page page, Object object) {
        if (!page.isLeaf()) {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Object object2;
                if (!this.contains(page, i, object) || (object2 = this.get(page.getChildPage(i), object)) == null) continue;
                return object2;
            }
        } else {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                if (!this.keyType.equals(page.getKey(i), object)) continue;
                return page.getValue(i);
            }
        }
        return null;
    }

    @Override
    protected synchronized Object remove(Page page, long l, Object object) {
        Object object2 = null;
        if (page.isLeaf()) {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                if (!this.keyType.equals(page.getKey(i), object)) continue;
                object2 = page.getValue(i);
                page.remove(i);
                break;
            }
            return object2;
        }
        for (int i = 0; i < page.getKeyCount(); ++i) {
            if (!this.contains(page, i, object)) continue;
            Page page2 = page.getChildPage(i);
            Page page3 = page2.copy(l);
            long l2 = page3.getTotalCount();
            object2 = this.remove(page3, l, object);
            page.setChild(i, page3);
            if (l2 == page3.getTotalCount()) continue;
            if (page3.getTotalCount() == 0L) {
                page.remove(i);
                if (page.getKeyCount() != 0) break;
                page3.removePage();
                break;
            }
            Object object3 = page.getKey(i);
            if (this.keyType.isInside(object, object3)) break;
            page.setKey(i, this.getBounds(page3));
            break;
        }
        return object2;
    }

    private Object getBounds(Page page) {
        Object object = this.keyType.createBoundingBox(page.getKey(0));
        for (int i = 1; i < page.getKeyCount(); ++i) {
            this.keyType.increaseBounds(object, page.getKey(i));
        }
        return object;
    }

    @Override
    public V put(SpatialKey spatialKey, V v) {
        return (V)this.putOrAdd(spatialKey, v, false);
    }

    public void add(SpatialKey spatialKey, V v) {
        this.putOrAdd(spatialKey, v, true);
    }

    private synchronized Object putOrAdd(SpatialKey spatialKey, V v, boolean bl) {
        Object object;
        this.beforeWrite();
        long l = this.writeVersion;
        Page page = this.root.copy(l);
        if (bl || this.get(spatialKey) == null) {
            if (page.getMemory() > this.store.getPageSplitSize() && page.getKeyCount() > 3) {
                long l2 = page.getTotalCount();
                Page page2 = this.split(page, l);
                Object object2 = this.getBounds(page);
                Object object3 = this.getBounds(page2);
                Object[] objectArray = new Object[]{object2, object3};
                Page.PageReference[] pageReferenceArray = new Page.PageReference[]{new Page.PageReference(page, page.getPos(), page.getTotalCount()), new Page.PageReference(page2, page2.getPos(), page2.getTotalCount()), new Page.PageReference(null, 0L, 0L)};
                page = Page.create(this, l, objectArray, null, pageReferenceArray, l2, 0);
            }
            this.add(page, l, spatialKey, v);
            object = null;
        } else {
            object = this.set(page, l, spatialKey, v);
        }
        this.newRoot(page);
        return object;
    }

    private Object set(Page page, long l, Object object, Object object2) {
        if (page.isLeaf()) {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                if (!this.keyType.equals(page.getKey(i), object)) continue;
                return page.setValue(i, object2);
            }
        } else {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Page page2;
                if (!this.contains(page, i, object) || this.get(page2 = page.getChildPage(i), object) == null) continue;
                page2 = page2.copy(l);
                Object object3 = this.set(page2, l, object, object2);
                page.setChild(i, page2);
                return object3;
            }
        }
        throw DataUtils.newIllegalStateException(3, "Not found: {0}", object);
    }

    private void add(Page page, long l, Object object, Object object2) {
        Page page2;
        if (page.isLeaf()) {
            page.insertLeaf(page.getKeyCount(), object, object2);
            return;
        }
        int n = -1;
        for (int i = 0; i < page.getKeyCount(); ++i) {
            if (!this.contains(page, i, object)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            float f2 = Float.MAX_VALUE;
            for (int i = 0; i < page.getKeyCount(); ++i) {
                Object object3 = page.getKey(i);
                float f3 = this.keyType.getAreaIncrease(object3, object);
                if (!(f3 < f2)) continue;
                n = i;
                f2 = f3;
            }
        }
        if ((page2 = page.getChildPage(n).copy(l)).getMemory() > this.store.getPageSplitSize() && page2.getKeyCount() > 4) {
            Page page3 = this.split(page2, l);
            page.setKey(n, this.getBounds(page2));
            page.setChild(n, page2);
            page.insertNode(n, this.getBounds(page3), page3);
            this.add(page, l, object, object2);
            return;
        }
        this.add(page2, l, object, object2);
        Object object4 = page.getKey(n);
        this.keyType.increaseBounds(object4, object);
        page.setKey(n, object4);
        page.setChild(n, page2);
    }

    private Page split(Page page, long l) {
        return this.quadraticSplit ? this.splitQuadratic(page, l) : this.splitLinear(page, l);
    }

    private Page splitLinear(Page page, long l) {
        ArrayList<Object> arrayList = New.arrayList();
        for (int i = 0; i < page.getKeyCount(); ++i) {
            arrayList.add(page.getKey(i));
        }
        int[] nArray = this.keyType.getExtremes(arrayList);
        if (nArray == null) {
            return this.splitQuadratic(page, l);
        }
        Page page2 = this.newPage(page.isLeaf(), l);
        Page page3 = this.newPage(page.isLeaf(), l);
        MVRTreeMap.move(page, page2, nArray[0]);
        if (nArray[1] > nArray[0]) {
            nArray[1] = nArray[1] - 1;
        }
        MVRTreeMap.move(page, page3, nArray[1]);
        Object object = this.keyType.createBoundingBox(page2.getKey(0));
        Object object2 = this.keyType.createBoundingBox(page3.getKey(0));
        while (page.getKeyCount() > 0) {
            float f2;
            Object object3 = page.getKey(0);
            float f3 = this.keyType.getAreaIncrease(object, object3);
            if (f3 < (f2 = this.keyType.getAreaIncrease(object2, object3))) {
                this.keyType.increaseBounds(object, object3);
                MVRTreeMap.move(page, page2, 0);
                continue;
            }
            this.keyType.increaseBounds(object2, object3);
            MVRTreeMap.move(page, page3, 0);
        }
        while (page3.getKeyCount() > 0) {
            MVRTreeMap.move(page3, page, 0);
        }
        return page2;
    }

    private Page splitQuadratic(Page page, long l) {
        float f2;
        Object object;
        Page page2 = this.newPage(page.isLeaf(), l);
        Page page3 = this.newPage(page.isLeaf(), l);
        float f3 = Float.MIN_VALUE;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < page.getKeyCount(); ++i) {
            object = page.getKey(i);
            for (int j = 0; j < page.getKeyCount(); ++j) {
                Object object2;
                if (i == j || !((f2 = this.keyType.getCombinedArea(object, object2 = page.getKey(j))) > f3)) continue;
                f3 = f2;
                n = i;
                n2 = j;
            }
        }
        MVRTreeMap.move(page, page2, n);
        if (n < n2) {
            --n2;
        }
        MVRTreeMap.move(page, page3, n2);
        Object object3 = this.keyType.createBoundingBox(page2.getKey(0));
        object = this.keyType.createBoundingBox(page3.getKey(0));
        while (page.getKeyCount() > 0) {
            float f4 = 0.0f;
            float f5 = 0.0f;
            f2 = 0.0f;
            int n3 = 0;
            for (int i = 0; i < page.getKeyCount(); ++i) {
                float f6;
                Object object4 = page.getKey(i);
                float f7 = this.keyType.getAreaIncrease(object3, object4);
                float f8 = Math.abs(f7 - (f6 = this.keyType.getAreaIncrease(object, object4)));
                if (!(f8 > f4)) continue;
                f4 = f8;
                f5 = f7;
                f2 = f6;
                n3 = i;
            }
            if (f5 < f2) {
                this.keyType.increaseBounds(object3, page.getKey(n3));
                MVRTreeMap.move(page, page2, n3);
                continue;
            }
            this.keyType.increaseBounds(object, page.getKey(n3));
            MVRTreeMap.move(page, page3, n3);
        }
        while (page3.getKeyCount() > 0) {
            MVRTreeMap.move(page3, page, 0);
        }
        return page2;
    }

    private Page newPage(boolean bl, long l) {
        Page.PageReference[] pageReferenceArray;
        Object[] objectArray;
        if (bl) {
            objectArray = Page.EMPTY_OBJECT_ARRAY;
            pageReferenceArray = null;
        } else {
            objectArray = null;
            pageReferenceArray = new Page.PageReference[]{new Page.PageReference(null, 0L, 0L)};
        }
        return Page.create(this, l, Page.EMPTY_OBJECT_ARRAY, objectArray, pageReferenceArray, 0L, 0);
    }

    private static void move(Page page, Page page2, int n) {
        Object object = page.getKey(n);
        if (page.isLeaf()) {
            Object object2 = page.getValue(n);
            page2.insertLeaf(0, object, object2);
        } else {
            Page page3 = page.getChildPage(n);
            page2.insertNode(0, object, page3);
        }
        page.remove(n);
    }

    public void addNodeKeys(ArrayList<SpatialKey> arrayList, Page page) {
        if (page != null && !page.isLeaf()) {
            for (int i = 0; i < page.getKeyCount(); ++i) {
                arrayList.add((SpatialKey)page.getKey(i));
                this.addNodeKeys(arrayList, page.getChildPage(i));
            }
        }
    }

    public boolean isQuadraticSplit() {
        return this.quadraticSplit;
    }

    public void setQuadraticSplit(boolean bl) {
        this.quadraticSplit = bl;
    }

    @Override
    protected int getChildPageCount(Page page) {
        return page.getRawChildPageCount() - 1;
    }

    @Override
    public String getType() {
        return "rtree";
    }

    public static class Builder<V>
    implements MVMap.MapBuilder<MVRTreeMap<V>, SpatialKey, V> {
        private int dimensions = 2;
        private DataType valueType;

        public Builder<V> dimensions(int n) {
            this.dimensions = n;
            return this;
        }

        public Builder<V> valueType(DataType dataType) {
            this.valueType = dataType;
            return this;
        }

        @Override
        public MVRTreeMap<V> create() {
            if (this.valueType == null) {
                this.valueType = new ObjectDataType();
            }
            return new MVRTreeMap(this.dimensions, this.valueType);
        }
    }

    public static class RTreeCursor
    implements Iterator<SpatialKey> {
        private final SpatialKey filter;
        private CursorPos pos;
        private SpatialKey current;
        private final Page root;
        private boolean initialized;

        protected RTreeCursor(Page page, SpatialKey spatialKey) {
            this.root = page;
            this.filter = spatialKey;
        }

        @Override
        public boolean hasNext() {
            if (!this.initialized) {
                this.pos = new CursorPos(this.root, 0, null);
                this.fetchNext();
                this.initialized = true;
            }
            return this.current != null;
        }

        public void skip(long l) {
            while (this.hasNext() && l-- > 0L) {
                this.fetchNext();
            }
        }

        @Override
        public SpatialKey next() {
            if (!this.hasNext()) {
                return null;
            }
            SpatialKey spatialKey = this.current;
            this.fetchNext();
            return spatialKey;
        }

        @Override
        public void remove() {
            throw DataUtils.newUnsupportedOperationException("Removing is not supported");
        }

        protected void fetchNext() {
            while (this.pos != null) {
                Page page = this.pos.page;
                if (page.isLeaf()) {
                    while (this.pos.index < page.getKeyCount()) {
                        SpatialKey spatialKey = (SpatialKey)page.getKey(this.pos.index++);
                        if (this.filter != null && !this.check(true, spatialKey, this.filter)) continue;
                        this.current = spatialKey;
                        return;
                    }
                } else {
                    boolean bl = false;
                    while (this.pos.index < page.getKeyCount()) {
                        int n;
                        ++this.pos.index;
                        SpatialKey spatialKey = (SpatialKey)page.getKey(n);
                        if (this.filter != null && !this.check(false, spatialKey, this.filter)) continue;
                        Page page2 = this.pos.page.getChildPage(n);
                        this.pos = new CursorPos(page2, 0, this.pos);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                }
                this.pos = this.pos.parent;
            }
            this.current = null;
        }

        protected boolean check(boolean bl, SpatialKey spatialKey, SpatialKey spatialKey2) {
            return true;
        }
    }
}

