/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.util.ArrayList;
import org.h2.command.Prepared;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.Parameter;
import org.h2.result.ResultInterface;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.StatementBuilder;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;

public class Analyze
extends DefineCommand {
    private int sampleRows;

    public Analyze(Session session) {
        super(session);
        this.sampleRows = session.getDatabase().getSettings().analyzeSample;
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        for (Table table : database.getAllTablesAndViews(false)) {
            Analyze.analyzeTable(this.session, table, this.sampleRows, true);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void analyzeTable(Session session, Table table, int n, boolean bl) {
        if (!table.getTableType().equals("TABLE") || table.isHidden() || session == null) {
            return;
        }
        if (!bl) {
            if (session.getDatabase().isSysTableLocked()) {
                return;
            }
            if (table.hasSelectTrigger()) {
                return;
            }
        }
        if (table.isTemporary() && !table.isGlobalTemporary() && session.findLocalTempTable(table.getName()) == null) {
            return;
        }
        if (table.isLockedExclusively() && !table.isLockedExclusivelyBy(session)) {
            return;
        }
        if (!session.getUser().hasRight(table, 1)) {
            return;
        }
        if (session.getCancel() != 0L) {
            return;
        }
        Column[] columnArray = table.getColumns();
        if (columnArray.length == 0) {
            return;
        }
        Database database = session.getDatabase();
        StatementBuilder statementBuilder = new StatementBuilder("SELECT ");
        for (Column i : columnArray) {
            statementBuilder.appendExceptFirst(", ");
            int value = i.getType();
            if (value == 15 || value == 16) {
                statementBuilder.append("MAX(NULL)");
                continue;
            }
            statementBuilder.append("SELECTIVITY(").append(i.getSQL()).append(')');
        }
        statementBuilder.append(" FROM ").append(table.getSQL());
        if (n > 0) {
            statementBuilder.append(" LIMIT ? SAMPLE_SIZE ? ");
        }
        String string = statementBuilder.toString();
        Prepared prepared2 = session.prepare(string);
        if (n > 0) {
            ArrayList<Parameter> resultInterface = prepared2.getParameters();
            resultInterface.get(0).setValue(ValueInt.get(1));
            resultInterface.get(1).setValue(ValueInt.get(n));
        }
        ResultInterface resultInterface = prepared2.query(0);
        resultInterface.next();
        for (int session2 = 0; session2 < columnArray.length; ++session2) {
            Value session3 = resultInterface.currentRow()[session2];
            if (session3 == ValueNull.INSTANCE) continue;
            int database2 = session3.getInt();
            columnArray[session2].setSelectivity(database2);
        }
        if (bl) {
            database.updateMeta(session, table);
        } else {
            Session session2 = database.getSystemSession();
            if (session2 != session) {
                Session session3 = session2;
                synchronized (session3) {
                    Database database2 = database;
                    synchronized (database2) {
                        database.updateMeta(session2, table);
                        session2.commit(true);
                    }
                }
            }
        }
    }

    public void setTop(int n) {
        this.sampleRows = n;
    }

    @Override
    public int getType() {
        return 21;
    }
}

