/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineCallable;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineTimeOutException;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.ShutdownHookUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamFeeder;
import org.codehaus.plexus.util.cli.StreamPumper;

public abstract class CommandLineUtils {
    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(Commandline cl, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, null, systemOut, systemErr, timeoutInSeconds);
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr) throws CommandLineException {
        return CommandLineUtils.executeCommandLine(cl, systemIn, systemOut, systemErr, 0);
    }

    public static int executeCommandLine(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, int timeoutInSeconds) throws CommandLineException {
        CommandLineCallable future = CommandLineUtils.executeCommandLineAsCallable(cl, systemIn, systemOut, systemErr, timeoutInSeconds);
        return future.call();
    }

    public static CommandLineCallable executeCommandLineAsCallable(Commandline cl, InputStream systemIn, StreamConsumer systemOut, StreamConsumer systemErr, final int timeoutInSeconds) throws CommandLineException {
        if (cl == null) {
            throw new IllegalArgumentException("cl cannot be null.");
        }
        final Process p = cl.execute();
        final StreamFeeder inputFeeder = systemIn != null ? new StreamFeeder(systemIn, p.getOutputStream()) : null;
        final StreamPumper outputPumper = new StreamPumper(p.getInputStream(), systemOut);
        final StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), systemErr);
        if (inputFeeder != null) {
            inputFeeder.start();
        }
        outputPumper.start();
        errorPumper.start();
        final ProcessHook processHook = new ProcessHook(p);
        ShutdownHookUtils.addShutDownHook(processHook);
        return new CommandLineCallable(){

            public Integer call() throws CommandLineException {
                try {
                    int returnValue;
                    if (timeoutInSeconds <= 0) {
                        returnValue = p.waitFor();
                    } else {
                        long now = System.currentTimeMillis();
                        long timeoutInMillis = 1000L * (long)timeoutInSeconds;
                        long finish = now + timeoutInMillis;
                        while (CommandLineUtils.isAlive(p) && System.currentTimeMillis() < finish) {
                            Thread.sleep(10L);
                        }
                        if (CommandLineUtils.isAlive(p)) {
                            throw new InterruptedException("Process timeout out after " + timeoutInSeconds + " seconds");
                        }
                        returnValue = p.exitValue();
                    }
                    CommandLineUtils.waitForAllPumpers(inputFeeder, outputPumper, errorPumper);
                    if (outputPumper.getException() != null) {
                        throw new CommandLineException("Error inside systemOut parser", outputPumper.getException());
                    }
                    if (errorPumper.getException() != null) {
                        throw new CommandLineException("Error inside systemErr parser", errorPumper.getException());
                    }
                    Integer n = returnValue;
                    return n;
                }
                catch (InterruptedException ex) {
                    if (inputFeeder != null) {
                        inputFeeder.disable();
                    }
                    outputPumper.disable();
                    errorPumper.disable();
                    throw new CommandLineTimeOutException("Error while executing external command, process killed.", ex);
                }
                finally {
                    ShutdownHookUtils.removeShutdownHook(processHook);
                    processHook.run();
                    if (inputFeeder != null) {
                        inputFeeder.close();
                    }
                    outputPumper.close();
                    errorPumper.close();
                }
            }
        };
    }

    private static void waitForAllPumpers(StreamFeeder inputFeeder, StreamPumper outputPumper, StreamPumper errorPumper) throws InterruptedException {
        if (inputFeeder != null) {
            inputFeeder.waitUntilDone();
        }
        outputPumper.waitUntilDone();
        errorPumper.waitUntilDone();
    }

    public static Properties getSystemEnvVars() throws IOException {
        return CommandLineUtils.getSystemEnvVars(!Os.isFamily("windows"));
    }

    public static Properties getSystemEnvVars(boolean caseSensitive) throws IOException {
        Properties envVars = new Properties();
        Map<String, String> envs = System.getenv();
        for (String key : envs.keySet()) {
            String value = envs.get(key);
            if (!caseSensitive) {
                key = key.toUpperCase(Locale.ENGLISH);
            }
            envVars.put(key, value);
        }
        return envVars;
    }

    public static boolean isAlive(Process p) {
        if (p == null) {
            return false;
        }
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    public static String[] translateCommandline(String toProcess) throws Exception {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        Vector<String> v = new Vector<String>();
        StringBuilder current = new StringBuilder();
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
                continue;
            }
            if ("\"".equals(nextTok)) {
                state = 2;
                continue;
            }
            if (" ".equals(nextTok)) {
                if (current.length() == 0) continue;
                v.addElement(current.toString());
                current.setLength(0);
                continue;
            }
            current.append(nextTok);
        }
        if (current.length() != 0) {
            v.addElement(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new CommandLineException("unbalanced quotes in " + toProcess);
        }
        Object[] args2 = new String[v.size()];
        v.copyInto(args2);
        return args2;
    }

    public static String quote(String argument) throws CommandLineException {
        return CommandLineUtils.quote(argument, false, false, true);
    }

    public static String quote(String argument, boolean wrapExistingQuotes) throws CommandLineException {
        return CommandLineUtils.quote(argument, false, false, wrapExistingQuotes);
    }

    public static String quote(String argument, boolean escapeSingleQuotes, boolean escapeDoubleQuotes, boolean wrapExistingQuotes) throws CommandLineException {
        if (argument.contains("\"")) {
            if (argument.contains("'")) {
                throw new CommandLineException("Can't handle single and double quotes in same argument");
            }
            if (escapeSingleQuotes) {
                return "\\'" + argument + "\\'";
            }
            if (wrapExistingQuotes) {
                return '\'' + argument + '\'';
            }
        } else if (argument.contains("'")) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument + "\\\"";
            }
            if (wrapExistingQuotes) {
                return '\"' + argument + '\"';
            }
        } else if (argument.contains(" ")) {
            if (escapeDoubleQuotes) {
                return "\\\"" + argument + "\\\"";
            }
            return '\"' + argument + '\"';
        }
        return argument;
    }

    public static String toString(String[] line) {
        if (line == null || line.length == 0) {
            return "";
        }
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < line.length; ++i) {
            if (i > 0) {
                result2.append(' ');
            }
            try {
                result2.append(StringUtils.quoteAndEscape(line[i], '\"'));
                continue;
            }
            catch (Exception e) {
                System.err.println("Error quoting argument: " + e.getMessage());
            }
        }
        return result2.toString();
    }

    private static class ProcessHook
    extends Thread {
        private final Process process;

        private ProcessHook(Process process) {
            super("CommandlineUtils process shutdown hook");
            this.process = process;
            this.setContextClassLoader(null);
        }

        public void run() {
            this.process.destroy();
        }
    }

    public static class StringStreamConsumer
    implements StreamConsumer {
        private StringBuffer string = new StringBuffer();
        private String ls = System.getProperty("line.separator");

        public void consumeLine(String line) {
            this.string.append(line).append(this.ls);
        }

        public String getOutput() {
            return this.string.toString();
        }
    }
}

