/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel;

import org.apache.poi.ss.formula.BaseFormulaEvaluator;
import org.apache.poi.ss.formula.EvaluationCell;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationCell;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public abstract class BaseXSSFFormulaEvaluator
extends BaseFormulaEvaluator {
    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        super(bookEvaluator);
    }

    @Override
    protected RichTextString createRichTextString(String str) {
        return new XSSFRichTextString(str);
    }

    @Override
    public void notifySetFormula(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyDeleteCell(Cell cell) {
        this._bookEvaluator.notifyDeleteCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    @Override
    public void notifyUpdateCell(Cell cell) {
        this._bookEvaluator.notifyUpdateCell(new XSSFEvaluationCell((XSSFCell)cell));
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    @Override
    protected CellValue evaluateFormulaCellValue(Cell cell) {
        EvaluationCell evalCell = this.toEvaluationCell(cell);
        ValueEval eval2 = this._bookEvaluator.evaluate(evalCell);
        if (eval2 instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval2;
            return new CellValue(ne.getNumberValue());
        }
        if (eval2 instanceof BoolEval) {
            BoolEval be = (BoolEval)eval2;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval2 instanceof StringEval) {
            StringEval ne = (StringEval)eval2;
            return new CellValue(ne.getStringValue());
        }
        if (eval2 instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval2).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval2.getClass().getName() + ")");
    }
}

