/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.dev;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.opc.internal.ZipHelper;
import org.apache.poi.util.DocumentHelper;
import org.apache.poi.util.IOUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.w3c.dom.Document;

public final class XSSFDump {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws Exception {
        for (int i = 0; i < args2.length; ++i) {
            System.out.println("Dumping " + args2[i]);
            ZipFile zip2 = ZipHelper.openZipFile(args2[i]);
            try {
                XSSFDump.dump(zip2);
                continue;
            }
            finally {
                zip2.close();
            }
        }
    }

    private static void createDirIfMissing(File directory) throws RuntimeException {
        boolean dirWasCreated;
        if (!directory.exists() && !(dirWasCreated = directory.mkdir())) {
            throw new RuntimeException("Unable to create directory: " + directory);
        }
    }

    private static void recursivelyCreateDirIfMissing(File directory) throws RuntimeException {
        boolean dirsWereCreated;
        if (!directory.exists() && !(dirsWereCreated = directory.mkdirs())) {
            throw new RuntimeException("Unable to recursively create directory: " + directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(ZipFile zip2) throws Exception {
        String zipname = zip2.getName();
        int sep = zipname.lastIndexOf(46);
        File root = new File(zipname.substring(0, sep));
        XSSFDump.createDirIfMissing(root);
        System.out.println("Dumping to directory " + root);
        Enumeration<? extends ZipEntry> en = zip2.entries();
        while (en.hasMoreElements()) {
            ZipEntry entry = en.nextElement();
            String name = entry.getName();
            int idx = name.lastIndexOf(47);
            if (idx != -1) {
                File bs = new File(root, name.substring(0, idx));
                XSSFDump.recursivelyCreateDirIfMissing(bs);
            }
            File f2 = new File(root, entry.getName());
            FileOutputStream out = new FileOutputStream(f2);
            try {
                if (entry.getName().endsWith(".xml") || entry.getName().endsWith(".vml") || entry.getName().endsWith(".rels")) {
                    try {
                        Document doc = DocumentHelper.readDocument(zip2.getInputStream(entry));
                        XmlObject xml = XmlObject.Factory.parse(doc, POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
                        XmlOptions options = new XmlOptions();
                        options.setSavePrettyPrint();
                        xml.save(out, options);
                    }
                    catch (XmlException e) {
                        System.err.println("Failed to parse " + entry.getName() + ", dumping raw content");
                        IOUtils.copy(zip2.getInputStream(entry), out);
                    }
                    continue;
                }
                IOUtils.copy(zip2.getInputStream(entry), out);
            }
            finally {
                ((OutputStream)out).close();
            }
        }
    }
}

