/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.util;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.SlideShowFactory;

public class PPTX2PNG {
    static void usage(String error) {
        String msg = "Usage: PPTX2PNG [options] <ppt or pptx file>\n" + (error == null ? "" : "Error: " + error + "\n") + "Options:\n" + "    -scale <float>   scale factor\n" + "    -slide <integer> 1-based index of a slide to render\n" + "    -format <type>   png,gif,jpg (,null for testing)" + "    -outdir <dir>    output directory, defaults to origin of the ppt/pptx file" + "    -quiet           do not write to console (for normal processing)";
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args2) throws Exception {
        if (args2.length == 0) {
            PPTX2PNG.usage(null);
            return;
        }
        String slidenumStr = "-1";
        float scale = 1.0f;
        File file = null;
        String format = "png";
        File outdir = null;
        boolean quiet = false;
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i].startsWith("-")) {
                if ("-scale".equals(args2[i])) {
                    scale = Float.parseFloat(args2[++i]);
                    continue;
                }
                if ("-slide".equals(args2[i])) {
                    slidenumStr = args2[++i];
                    continue;
                }
                if ("-format".equals(args2[i])) {
                    format = args2[++i];
                    continue;
                }
                if ("-outdir".equals(args2[i])) {
                    outdir = new File(args2[++i]);
                    continue;
                }
                if (!"-quiet".equals(args2[i])) continue;
                quiet = true;
                continue;
            }
            file = new File(args2[i]);
        }
        if (file == null || !file.exists()) {
            PPTX2PNG.usage("File not specified or it doesn't exist");
            return;
        }
        if (format == null || !format.matches("^(png|gif|jpg|null)$")) {
            PPTX2PNG.usage("Invalid format given");
            return;
        }
        if (outdir == null) {
            outdir = file.getParentFile();
        }
        if (!("null".equals(format) || outdir != null && outdir.exists() && outdir.isDirectory())) {
            PPTX2PNG.usage("Output directory doesn't exist");
            return;
        }
        if (scale < 0.0f) {
            PPTX2PNG.usage("Invalid scale given");
            return;
        }
        if (!quiet) {
            System.out.println("Processing " + file);
        }
        SlideShow<?, ?> ss = SlideShowFactory.create(file, null, true);
        try {
            List<Slide<?, ?>> slides = ss.getSlides();
            Set<Integer> slidenum = PPTX2PNG.slideIndexes(slides.size(), slidenumStr);
            if (slidenum.isEmpty()) {
                PPTX2PNG.usage("slidenum must be either -1 (for all) or within range: [1.." + slides.size() + "] for " + file);
                return;
            }
            Dimension pgsize = ss.getPageSize();
            int width = (int)((float)pgsize.width * scale);
            int height = (int)((float)pgsize.height * scale);
            for (Integer slideNo : slidenum) {
                Slide<?, ?> slide = slides.get(slideNo);
                String title = slide.getTitle();
                if (!quiet) {
                    System.out.println("Rendering slide " + slideNo + (title == null ? "" : ": " + title));
                }
                BufferedImage img = new BufferedImage(width, height, 2);
                Graphics2D graphics = img.createGraphics();
                DrawFactory.getInstance(graphics).fixFonts(graphics);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                graphics.scale(scale, scale);
                slide.draw(graphics);
                if (!"null".equals(format)) {
                    String outname = file.getName().replaceFirst(".pptx?", "");
                    outname = String.format(Locale.ROOT, "%1$s-%2$04d.%3$s", outname, slideNo, format);
                    File outfile = new File(outdir, outname);
                    ImageIO.write((RenderedImage)img, format, outfile);
                }
                graphics.dispose();
                img.flush();
            }
        }
        finally {
            ss.close();
        }
        if (!quiet) {
            System.out.println("Done");
        }
    }

    private static Set<Integer> slideIndexes(int slideCount, String range) {
        TreeSet<Integer> slideIdx = new TreeSet<Integer>();
        if ("-1".equals(range)) {
            for (int i = 0; i < slideCount; ++i) {
                slideIdx.add(i);
            }
        } else {
            block5: for (String subrange : range.split(",")) {
                String[] idx = subrange.split("-");
                switch (idx.length) {
                    default: {
                        continue block5;
                    }
                    case 1: {
                        int subidx = Integer.parseInt(idx[0]);
                        if (subrange.contains("-")) {
                            int startIdx = subrange.startsWith("-") ? 0 : subidx;
                            int endIdx = subrange.endsWith("-") ? slideCount : Math.min(subidx, slideCount);
                            for (int i = Math.max(startIdx, 1); i < endIdx; ++i) {
                                slideIdx.add(i - 1);
                            }
                            continue block5;
                        }
                        slideIdx.add(Math.max(subidx, 1) - 1);
                        continue block5;
                    }
                    case 2: {
                        int startIdx = Math.min(Integer.parseInt(idx[0]), slideCount);
                        int endIdx = Math.min(Integer.parseInt(idx[1]), slideCount);
                        for (int i = Math.max(startIdx, 1); i < endIdx; ++i) {
                            slideIdx.add(i - 1);
                        }
                    }
                }
            }
        }
        return slideIdx;
    }
}

