/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xdgf.extractor;

import java.io.IOException;
import org.apache.poi.POITextExtractor;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.xdgf.usermodel.XDGFPage;
import org.apache.poi.xdgf.usermodel.XmlVisioDocument;
import org.apache.poi.xdgf.usermodel.shape.ShapeTextVisitor;

public class XDGFVisioExtractor
extends POIXMLTextExtractor {
    protected final XmlVisioDocument document;

    public XDGFVisioExtractor(XmlVisioDocument document) {
        super(document);
        this.document = document;
    }

    public XDGFVisioExtractor(OPCPackage openPackage) throws IOException {
        this(new XmlVisioDocument(openPackage));
    }

    @Override
    public String getText() {
        ShapeTextVisitor visitor2 = new ShapeTextVisitor();
        for (XDGFPage page : this.document.getPages()) {
            page.getContent().visitShapes(visitor2);
        }
        return visitor2.getText().toString();
    }

    public static void main(String[] args2) throws IOException {
        if (args2.length < 1) {
            System.err.println("Use:");
            System.err.println("  XDGFVisioExtractor <filename.vsdx>");
            System.exit(1);
        }
        XDGFVisioExtractor extractor = new XDGFVisioExtractor(POIXMLDocument.openPackage(args2[0]));
        System.out.println(((POITextExtractor)extractor).getText());
        extractor.close();
    }
}

