/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DateFormatConverter {
    private static POILogger logger = POILogFactory.getLogger(DateFormatConverter.class);
    private static Map<String, String> tokenConversions = DateFormatConverter.prepareTokenConversions();
    private static Map<String, String> localePrefixes = DateFormatConverter.prepareLocalePrefixes();

    private static Map<String, String> prepareTokenConversions() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("EEEE", "dddd");
        result2.put("EEE", "ddd");
        result2.put("EE", "ddd");
        result2.put("E", "d");
        result2.put("Z", "");
        result2.put("z", "");
        result2.put("a", "am/pm");
        result2.put("A", "AM/PM");
        result2.put("K", "H");
        result2.put("KK", "HH");
        result2.put("k", "h");
        result2.put("kk", "hh");
        result2.put("S", "0");
        result2.put("SS", "00");
        result2.put("SSS", "000");
        return result2;
    }

    private static Map<String, String> prepareLocalePrefixes() {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("af", "[$-0436]");
        result2.put("am", "[$-45E]");
        result2.put("ar_ae", "[$-3801]");
        result2.put("ar_bh", "[$-3C01]");
        result2.put("ar_dz", "[$-1401]");
        result2.put("ar_eg", "[$-C01]");
        result2.put("ar_iq", "[$-0801]");
        result2.put("ar_jo", "[$-2C01]");
        result2.put("ar_kw", "[$-3401]");
        result2.put("ar_lb", "[$-3001]");
        result2.put("ar_ly", "[$-1001]");
        result2.put("ar_ma", "[$-1801]");
        result2.put("ar_om", "[$-2001]");
        result2.put("ar_qa", "[$-4001]");
        result2.put("ar_sa", "[$-0401]");
        result2.put("ar_sy", "[$-2801]");
        result2.put("ar_tn", "[$-1C01]");
        result2.put("ar_ye", "[$-2401]");
        result2.put("as", "[$-44D]");
        result2.put("az_az", "[$-82C]");
        result2.put("az_az", "[$-42C]");
        result2.put("be", "[$-0423]");
        result2.put("bg", "[$-0402]");
        result2.put("bn", "[$-0845]");
        result2.put("bn", "[$-0445]");
        result2.put("bo", "[$-0451]");
        result2.put("bs", "[$-141A]");
        result2.put("ca", "[$-0403]");
        result2.put("cs", "[$-0405]");
        result2.put("cy", "[$-0452]");
        result2.put("da", "[$-0406]");
        result2.put("de_at", "[$-C07]");
        result2.put("de_ch", "[$-0807]");
        result2.put("de_de", "[$-0407]");
        result2.put("de_li", "[$-1407]");
        result2.put("de_lu", "[$-1007]");
        result2.put("dv", "[$-0465]");
        result2.put("el", "[$-0408]");
        result2.put("en_au", "[$-C09]");
        result2.put("en_bz", "[$-2809]");
        result2.put("en_ca", "[$-1009]");
        result2.put("en_cb", "[$-2409]");
        result2.put("en_gb", "[$-0809]");
        result2.put("en_ie", "[$-1809]");
        result2.put("en_in", "[$-4009]");
        result2.put("en_jm", "[$-2009]");
        result2.put("en_nz", "[$-1409]");
        result2.put("en_ph", "[$-3409]");
        result2.put("en_tt", "[$-2C09]");
        result2.put("en_us", "[$-0409]");
        result2.put("en_za", "[$-1C09]");
        result2.put("es_ar", "[$-2C0A]");
        result2.put("es_bo", "[$-400A]");
        result2.put("es_cl", "[$-340A]");
        result2.put("es_co", "[$-240A]");
        result2.put("es_cr", "[$-140A]");
        result2.put("es_do", "[$-1C0A]");
        result2.put("es_ec", "[$-300A]");
        result2.put("es_es", "[$-40A]");
        result2.put("es_gt", "[$-100A]");
        result2.put("es_hn", "[$-480A]");
        result2.put("es_mx", "[$-80A]");
        result2.put("es_ni", "[$-4C0A]");
        result2.put("es_pa", "[$-180A]");
        result2.put("es_pe", "[$-280A]");
        result2.put("es_pr", "[$-500A]");
        result2.put("es_py", "[$-3C0A]");
        result2.put("es_sv", "[$-440A]");
        result2.put("es_uy", "[$-380A]");
        result2.put("es_ve", "[$-200A]");
        result2.put("et", "[$-0425]");
        result2.put("eu", "[$-42D]");
        result2.put("fa", "[$-0429]");
        result2.put("fi", "[$-40B]");
        result2.put("fo", "[$-0438]");
        result2.put("fr_be", "[$-80C]");
        result2.put("fr_ca", "[$-C0C]");
        result2.put("fr_ch", "[$-100C]");
        result2.put("fr_fr", "[$-40C]");
        result2.put("fr_lu", "[$-140C]");
        result2.put("gd", "[$-43C]");
        result2.put("gd_ie", "[$-83C]");
        result2.put("gn", "[$-0474]");
        result2.put("gu", "[$-0447]");
        result2.put("he", "[$-40D]");
        result2.put("hi", "[$-0439]");
        result2.put("hr", "[$-41A]");
        result2.put("hu", "[$-40E]");
        result2.put("hy", "[$-42B]");
        result2.put("id", "[$-0421]");
        result2.put("is", "[$-40F]");
        result2.put("it_ch", "[$-0810]");
        result2.put("it_it", "[$-0410]");
        result2.put("ja", "[$-0411]");
        result2.put("kk", "[$-43F]");
        result2.put("km", "[$-0453]");
        result2.put("kn", "[$-44B]");
        result2.put("ko", "[$-0412]");
        result2.put("ks", "[$-0460]");
        result2.put("la", "[$-0476]");
        result2.put("lo", "[$-0454]");
        result2.put("lt", "[$-0427]");
        result2.put("lv", "[$-0426]");
        result2.put("mi", "[$-0481]");
        result2.put("mk", "[$-42F]");
        result2.put("ml", "[$-44C]");
        result2.put("mn", "[$-0850]");
        result2.put("mn", "[$-0450]");
        result2.put("mr", "[$-44E]");
        result2.put("ms_bn", "[$-83E]");
        result2.put("ms_my", "[$-43E]");
        result2.put("mt", "[$-43A]");
        result2.put("my", "[$-0455]");
        result2.put("ne", "[$-0461]");
        result2.put("nl_be", "[$-0813]");
        result2.put("nl_nl", "[$-0413]");
        result2.put("no_no", "[$-0814]");
        result2.put("or", "[$-0448]");
        result2.put("pa", "[$-0446]");
        result2.put("pl", "[$-0415]");
        result2.put("pt_br", "[$-0416]");
        result2.put("pt_pt", "[$-0816]");
        result2.put("rm", "[$-0417]");
        result2.put("ro", "[$-0418]");
        result2.put("ro_mo", "[$-0818]");
        result2.put("ru", "[$-0419]");
        result2.put("ru_mo", "[$-0819]");
        result2.put("sa", "[$-44F]");
        result2.put("sb", "[$-42E]");
        result2.put("sd", "[$-0459]");
        result2.put("si", "[$-45B]");
        result2.put("sk", "[$-41B]");
        result2.put("sl", "[$-0424]");
        result2.put("so", "[$-0477]");
        result2.put("sq", "[$-41C]");
        result2.put("sr_sp", "[$-C1A]");
        result2.put("sr_sp", "[$-81A]");
        result2.put("sv_fi", "[$-81D]");
        result2.put("sv_se", "[$-41D]");
        result2.put("sw", "[$-0441]");
        result2.put("ta", "[$-0449]");
        result2.put("te", "[$-44A]");
        result2.put("tg", "[$-0428]");
        result2.put("th", "[$-41E]");
        result2.put("tk", "[$-0442]");
        result2.put("tn", "[$-0432]");
        result2.put("tr", "[$-41F]");
        result2.put("ts", "[$-0431]");
        result2.put("tt", "[$-0444]");
        result2.put("uk", "[$-0422]");
        result2.put("ur", "[$-0420]");
        result2.put("UTF_8", "[$-0000]");
        result2.put("uz_uz", "[$-0843]");
        result2.put("uz_uz", "[$-0443]");
        result2.put("vi", "[$-42A]");
        result2.put("xh", "[$-0434]");
        result2.put("yi", "[$-43D]");
        result2.put("zh_cn", "[$-0804]");
        result2.put("zh_hk", "[$-C04]");
        result2.put("zh_mo", "[$-1404]");
        result2.put("zh_sg", "[$-1004]");
        result2.put("zh_tw", "[$-0404]");
        result2.put("zu", "[$-0435]");
        result2.put("ar", "[$-0401]");
        result2.put("bn", "[$-0845]");
        result2.put("de", "[$-0407]");
        result2.put("en", "[$-0409]");
        result2.put("es", "[$-40A]");
        result2.put("fr", "[$-40C]");
        result2.put("it", "[$-0410]");
        result2.put("ms", "[$-43E]");
        result2.put("nl", "[$-0413]");
        result2.put("nn", "[$-0814]");
        result2.put("no", "[$-0414]");
        result2.put("pt", "[$-0816]");
        result2.put("sr", "[$-C1A]");
        result2.put("sv", "[$-41D]");
        result2.put("uz", "[$-0843]");
        result2.put("zh", "[$-0804]");
        result2.put("ga", "[$-43C]");
        result2.put("ga_ie", "[$-83C]");
        result2.put("in", "[$-0421]");
        result2.put("iw", "[$-40D]");
        result2.put("", "[$-0409]");
        return result2;
    }

    public static String getPrefixForLocale(Locale locale) {
        String localeString = locale.toString().toLowerCase(locale);
        String result2 = localePrefixes.get(localeString);
        if (result2 == null && (result2 = localePrefixes.get(localeString.substring(0, 2))) == null) {
            Locale parentLocale = new Locale(localeString.substring(0, 2));
            logger.log(7, "Unable to find prefix for " + locale + "(" + locale.getDisplayName(Locale.ROOT) + ") or " + localeString.substring(0, 2) + "(" + parentLocale.getDisplayName(Locale.ROOT) + ")");
            return "";
        }
        return result2;
    }

    public static String convert(Locale locale, DateFormat df) {
        String ptrn = ((SimpleDateFormat)df).toPattern();
        return DateFormatConverter.convert(locale, ptrn);
    }

    public static String convert(Locale locale, String format) {
        String token;
        StringBuilder result2 = new StringBuilder();
        result2.append(DateFormatConverter.getPrefixForLocale(locale));
        DateFormatTokenizer tokenizer = new DateFormatTokenizer(format);
        while ((token = tokenizer.getNextToken()) != null) {
            if (token.startsWith("'")) {
                result2.append(token.replaceAll("'", "\""));
                continue;
            }
            if (!Character.isLetter(token.charAt(0))) {
                result2.append(token);
                continue;
            }
            String mappedToken = tokenConversions.get(token);
            result2.append(mappedToken == null ? token : mappedToken);
        }
        result2.append(";@");
        return result2.toString().trim();
    }

    public static String getJavaDatePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getDateInstance(style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "d/MM/yy";
            }
            case 2: {
                return "MMM d, yyyy";
            }
            case 1: {
                return "MMMM d, yyyy";
            }
            case 0: {
                return "dddd, MMMM d, yyyy";
            }
        }
        return "MMM d, yyyy";
    }

    public static String getJavaTimePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "h:mm a";
            }
            case 2: {
                return "h:mm:ss a";
            }
            case 1: {
                return "h:mm:ss a";
            }
            case 0: {
                return "h:mm:ss a";
            }
        }
        return "h:mm:ss a";
    }

    public static String getJavaDateTimePattern(int style, Locale locale) {
        DateFormat df = DateFormat.getDateTimeInstance(style, style, locale);
        if (df instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)df).toPattern();
        }
        switch (style) {
            case 3: {
                return "M/d/yy h:mm a";
            }
            case 2: {
                return "MMM d, yyyy h:mm:ss a";
            }
            case 1: {
                return "MMMM d, yyyy h:mm:ss a";
            }
            case 0: {
                return "dddd, MMMM d, yyyy h:mm:ss a";
            }
        }
        return "MMM d, yyyy h:mm:ss a";
    }

    public static class DateFormatTokenizer {
        String format;
        int pos;

        public DateFormatTokenizer(String format) {
            this.format = format;
        }

        public String getNextToken() {
            if (this.pos >= this.format.length()) {
                return null;
            }
            int subStart = this.pos;
            char curChar = this.format.charAt(this.pos);
            ++this.pos;
            if (curChar == '\'') {
                while (this.pos < this.format.length() && (curChar = this.format.charAt(this.pos)) != '\'') {
                    ++this.pos;
                }
                if (this.pos < this.format.length()) {
                    ++this.pos;
                }
            } else {
                char activeChar = curChar;
                while (this.pos < this.format.length() && (curChar = this.format.charAt(this.pos)) == activeChar) {
                    ++this.pos;
                }
            }
            return this.format.substring(subStart, this.pos);
        }

        public static String[] tokenize(String format) {
            String token;
            ArrayList<String> result2 = new ArrayList<String>();
            DateFormatTokenizer tokenizer = new DateFormatTokenizer(format);
            while ((token = tokenizer.getNextToken()) != null) {
                result2.add(token);
            }
            return result2.toArray(new String[0]);
        }

        public String toString() {
            String token;
            StringBuilder result2 = new StringBuilder();
            DateFormatTokenizer tokenizer = new DateFormatTokenizer(this.format);
            while ((token = tokenizer.getNextToken()) != null) {
                if (result2.length() > 0) {
                    result2.append(", ");
                }
                result2.append("[").append(token).append("]");
            }
            return result2.toString();
        }
    }
}

