/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Calendar;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.util.LocaleUtil;

public final class DateFunc
extends Fixed3ArgFunction {
    public static final Function instance = new DateFunc();

    private DateFunc() {
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        double result2;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            double d2 = NumericFunction.singleOperandEvaluate(arg2, srcRowIndex, srcColumnIndex);
            result2 = DateFunc.evaluate(DateFunc.getYear(d0), (int)(d1 - 1.0), (int)d2);
            NumericFunction.checkValue(result2);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result2);
    }

    private static double evaluate(int year2, int month2, int pDay) throws EvaluationException {
        if (year2 < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        while (month2 < 0) {
            --year2;
            month2 += 12;
        }
        if (year2 == 1900 && month2 == 1 && pDay == 29) {
            return 60.0;
        }
        int day2 = pDay;
        if (year2 == 1900 && (month2 == 0 && day2 >= 60 || month2 == 1 && day2 >= 30)) {
            --day2;
        }
        Calendar c = LocaleUtil.getLocaleCalendar(year2, month2, day2);
        if (pDay < 0 && c.get(1) == 1900 && month2 > 1 && c.get(2) < 2) {
            c.add(5, 1);
        }
        boolean use1904windowing = false;
        return DateUtil.getExcelDate(c.getTime(), use1904windowing);
    }

    private static int getYear(double d) {
        int year2 = (int)d;
        if (year2 < 0) {
            return -1;
        }
        return year2 < 1900 ? 1900 + year2 : year2;
    }
}

