/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.formula.EvaluationConditionalFormatRule;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.WorkbookEvaluatorProvider;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.SheetUtil;

public class ConditionalFormattingEvaluator {
    private final WorkbookEvaluator workbookEvaluator;
    private final Workbook workbook;
    private final Map<String, List<EvaluationConditionalFormatRule>> formats = new HashMap<String, List<EvaluationConditionalFormatRule>>();
    private final Map<CellReference, List<EvaluationConditionalFormatRule>> values = new HashMap<CellReference, List<EvaluationConditionalFormatRule>>();

    public ConditionalFormattingEvaluator(Workbook wb, WorkbookEvaluatorProvider provider) {
        this.workbook = wb;
        this.workbookEvaluator = provider._getWorkbookEvaluator();
    }

    protected WorkbookEvaluator getWorkbookEvaluator() {
        return this.workbookEvaluator;
    }

    public void clearAllCachedFormats() {
        this.formats.clear();
    }

    public void clearAllCachedValues() {
        this.values.clear();
    }

    protected List<EvaluationConditionalFormatRule> getRules(Sheet sheet) {
        String sheetName = sheet.getSheetName();
        List<EvaluationConditionalFormatRule> rules = this.formats.get(sheetName);
        if (rules == null && !this.formats.containsKey(sheetName)) {
            SheetConditionalFormatting scf = sheet.getSheetConditionalFormatting();
            int count2 = scf.getNumConditionalFormattings();
            rules = new ArrayList<EvaluationConditionalFormatRule>(count2);
            this.formats.put(sheetName, rules);
            for (int i = 0; i < count2; ++i) {
                ConditionalFormatting f2 = scf.getConditionalFormattingAt(i);
                CellRangeAddress[] regions = f2.getFormattingRanges();
                for (int r = 0; r < f2.getNumberOfRules(); ++r) {
                    ConditionalFormattingRule rule = f2.getRule(r);
                    rules.add(new EvaluationConditionalFormatRule(this.workbookEvaluator, sheet, f2, i, rule, r, regions));
                }
            }
            Collections.sort(rules);
        }
        return Collections.unmodifiableList(rules);
    }

    public List<EvaluationConditionalFormatRule> getConditionalFormattingForCell(CellReference cellRef) {
        String sheetName = cellRef.getSheetName();
        Sheet sheet = null;
        sheet = sheetName == null ? this.workbook.getSheetAt(this.workbook.getActiveSheetIndex()) : this.workbook.getSheet(sheetName);
        Cell cell = SheetUtil.getCell(sheet, cellRef.getRow(), cellRef.getCol());
        if (cell == null) {
            return Collections.emptyList();
        }
        return this.getConditionalFormattingForCell(cell, cellRef);
    }

    public List<EvaluationConditionalFormatRule> getConditionalFormattingForCell(Cell cell) {
        return this.getConditionalFormattingForCell(cell, ConditionalFormattingEvaluator.getRef(cell));
    }

    private List<EvaluationConditionalFormatRule> getConditionalFormattingForCell(Cell cell, CellReference ref) {
        List<EvaluationConditionalFormatRule> rules = this.values.get(ref);
        if (rules == null) {
            rules = new ArrayList<EvaluationConditionalFormatRule>();
            boolean stopIfTrue = false;
            for (EvaluationConditionalFormatRule rule : this.getRules(cell.getSheet())) {
                if (stopIfTrue || !rule.matches(cell)) continue;
                rules.add(rule);
                stopIfTrue = rule.getRule().getStopIfTrue();
            }
            Collections.sort(rules);
            this.values.put(ref, rules);
        }
        return Collections.unmodifiableList(rules);
    }

    public static CellReference getRef(Cell cell) {
        return new CellReference(cell.getSheet().getSheetName(), cell.getRowIndex(), cell.getColumnIndex(), false, false);
    }

    public List<EvaluationConditionalFormatRule> getFormatRulesForSheet(String sheetName) {
        return this.getFormatRulesForSheet(this.workbook.getSheet(sheetName));
    }

    public List<EvaluationConditionalFormatRule> getFormatRulesForSheet(Sheet sheet) {
        return this.getRules(sheet);
    }

    public List<Cell> getMatchingCells(Sheet sheet, int conditionalFormattingIndex, int ruleIndex) {
        for (EvaluationConditionalFormatRule rule : this.getRules(sheet)) {
            if (!rule.getSheet().equals(sheet) || rule.getFormattingIndex() != conditionalFormattingIndex || rule.getRuleIndex() != ruleIndex) continue;
            return this.getMatchingCells(rule);
        }
        return Collections.emptyList();
    }

    public List<Cell> getMatchingCells(EvaluationConditionalFormatRule rule) {
        ArrayList<Cell> cells = new ArrayList<Cell>();
        Sheet sheet = rule.getSheet();
        for (CellRangeAddress region : rule.getRegions()) {
            for (int r = region.getFirstRow(); r <= region.getLastRow(); ++r) {
                Row row = sheet.getRow(r);
                if (row == null) continue;
                for (int c = region.getFirstColumn(); c <= region.getLastColumn(); ++c) {
                    List<EvaluationConditionalFormatRule> cellRules;
                    Cell cell = row.getCell(c);
                    if (cell == null || !(cellRules = this.getConditionalFormattingForCell(cell)).contains(rule)) continue;
                    cells.add(cell);
                }
            }
        }
        return Collections.unmodifiableList(cells);
    }
}

