/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.usermodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentFactoryHelper;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.util.IOUtils;

public class SlideShowFactory {
    public static SlideShow<?, ?> create(NPOIFSFileSystem fs) throws IOException {
        return SlideShowFactory.create(fs, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SlideShow<?, ?> create(NPOIFSFileSystem fs, String password) throws IOException {
        DirectoryNode root = fs.getRoot();
        if (root.hasEntry("EncryptedPackage")) {
            InputStream stream = null;
            try {
                stream = DocumentFactoryHelper.getDecryptedStream(fs, password);
                SlideShow<?, ?> slideShow = SlideShowFactory.createXSLFSlideShow(stream);
                return slideShow;
            }
            finally {
                IOUtils.closeQuietly(stream);
            }
        }
        if (password != null) {
            Biff8EncryptionKey.setCurrentUserPassword(password);
        }
        try {
            SlideShow<?, ?> slideShow = SlideShowFactory.createHSLFSlideShow(fs);
            return slideShow;
        }
        finally {
            Biff8EncryptionKey.setCurrentUserPassword(null);
        }
    }

    public static SlideShow<?, ?> create(InputStream inp) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(inp, null);
    }

    public static SlideShow<?, ?> create(InputStream inp, String password) throws IOException, EncryptedDocumentException {
        byte[] header8;
        if (!inp.markSupported()) {
            inp = new PushbackInputStream(inp, 8);
        }
        if (NPOIFSFileSystem.hasPOIFSHeader(header8 = IOUtils.peekFirst8Bytes(inp))) {
            NPOIFSFileSystem fs = new NPOIFSFileSystem(inp);
            return SlideShowFactory.create(fs, password);
        }
        if (DocumentFactoryHelper.hasOOXMLHeader(inp)) {
            return SlideShowFactory.createXSLFSlideShow(inp);
        }
        throw new IllegalArgumentException("Your InputStream was neither an OLE2 stream, nor an OOXML stream");
    }

    public static SlideShow<?, ?> create(File file) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, null);
    }

    public static SlideShow<?, ?> create(File file, String password) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.create(file, password, false);
    }

    public static SlideShow<?, ?> create(File file, String password, boolean readOnly) throws IOException, EncryptedDocumentException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        NPOIFSFileSystem fs = null;
        try {
            fs = new NPOIFSFileSystem(file, readOnly);
            return SlideShowFactory.create(fs, password);
        }
        catch (OfficeXmlFileException e) {
            IOUtils.closeQuietly(fs);
            return SlideShowFactory.createXSLFSlideShow(file, readOnly);
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly(fs);
            throw e;
        }
    }

    protected static SlideShow<?, ?> createHSLFSlideShow(Object ... args2) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.hslf.usermodel.HSLFSlideShowFactory", args2);
    }

    protected static SlideShow<?, ?> createXSLFSlideShow(Object ... args2) throws IOException, EncryptedDocumentException {
        return SlideShowFactory.createSlideShow("org.apache.poi.xslf.usermodel.XSLFSlideShowFactory", args2);
    }

    protected static SlideShow<?, ?> createSlideShow(String factoryClass, Object[] args2) throws IOException, EncryptedDocumentException {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClass);
            Class[] argsClz = new Class[args2.length];
            int i = 0;
            for (Object o : args2) {
                Class<Object> c = o.getClass();
                if (Boolean.class.isAssignableFrom(c)) {
                    c = Boolean.TYPE;
                } else if (InputStream.class.isAssignableFrom(c)) {
                    c = InputStream.class;
                }
                argsClz[i++] = c;
            }
            Method m = clazz.getMethod("createSlideShow", argsClz);
            return (SlideShow)m.invoke(null, args2);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof EncryptedDocumentException) {
                throw (EncryptedDocumentException)t;
            }
            if (t instanceof OldFileFormatException) {
                throw (OldFileFormatException)t;
            }
            throw new IOException(t);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

