/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw.geom;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.sl.draw.geom.CustomGeometry;
import org.apache.poi.sl.draw.geom.Formula;
import org.apache.poi.sl.draw.geom.Guide;
import org.apache.poi.sl.draw.geom.IAdjustableShape;

public class Context {
    final Map<String, Double> _ctx = new HashMap<String, Double>();
    final IAdjustableShape _props;
    final Rectangle2D _anchor;

    public Context(CustomGeometry geom, Rectangle2D anchor, IAdjustableShape props) {
        this._props = props;
        this._anchor = anchor;
        for (Guide gd : geom.adjusts) {
            this.evaluate(gd);
        }
        for (Guide gd : geom.guides) {
            this.evaluate(gd);
        }
    }

    public Rectangle2D getShapeAnchor() {
        return this._anchor;
    }

    public Guide getAdjustValue(String name) {
        return this._props.getAdjustValue(name);
    }

    public double getValue(String key) {
        if (key.matches("(\\+|-)?\\d+")) {
            return Double.parseDouble(key);
        }
        Formula builtIn = Formula.builtInFormulas.get(key);
        if (builtIn != null) {
            return builtIn.evaluate(this);
        }
        if (!this._ctx.containsKey(key)) {
            throw new RuntimeException("undefined variable: " + key);
        }
        return this._ctx.get(key);
    }

    public double evaluate(Formula fmla) {
        double result2 = fmla.evaluate(this);
        String key = fmla.getName();
        if (key != null) {
            this._ctx.put(key, result2);
        }
        return result2;
    }
}

