/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.property;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.poi.poifs.property.Parent;
import org.apache.poi.poifs.property.Property;

public class DirectoryProperty
extends Property
implements Parent,
Iterable<Property> {
    private List<Property> _children = new ArrayList<Property>();
    private Set<String> _children_names = new HashSet<String>();

    public DirectoryProperty(String name) {
        this.setName(name);
        this.setSize(0);
        this.setPropertyType((byte)1);
        this.setStartBlock(0);
        this.setNodeColor((byte)1);
    }

    protected DirectoryProperty(int index, byte[] array, int offset) {
        super(index, array, offset);
    }

    public boolean changeName(Property property, String newName) {
        boolean result2;
        String oldName = property.getName();
        property.setName(newName);
        String cleanNewName = property.getName();
        if (this._children_names.contains(cleanNewName)) {
            property.setName(oldName);
            result2 = false;
        } else {
            this._children_names.add(cleanNewName);
            this._children_names.remove(oldName);
            result2 = true;
        }
        return result2;
    }

    public boolean deleteChild(Property property) {
        boolean result2 = this._children.remove(property);
        if (result2) {
            this._children_names.remove(property.getName());
        }
        return result2;
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    protected void preWrite() {
        if (this._children.size() > 0) {
            int j;
            Property[] children2 = this._children.toArray(new Property[0]);
            Arrays.sort(children2, new PropertyComparator());
            int midpoint = children2.length / 2;
            this.setChildProperty(children2[midpoint].getIndex());
            children2[0].setPreviousChild(null);
            children2[0].setNextChild(null);
            for (j = 1; j < midpoint; ++j) {
                children2[j].setPreviousChild(children2[j - 1]);
                children2[j].setNextChild(null);
            }
            if (midpoint != 0) {
                children2[midpoint].setPreviousChild(children2[midpoint - 1]);
            }
            if (midpoint != children2.length - 1) {
                children2[midpoint].setNextChild(children2[midpoint + 1]);
                for (j = midpoint + 1; j < children2.length - 1; ++j) {
                    children2[j].setPreviousChild(null);
                    children2[j].setNextChild(children2[j + 1]);
                }
                children2[children2.length - 1].setPreviousChild(null);
                children2[children2.length - 1].setNextChild(null);
            } else {
                children2[midpoint].setNextChild(null);
            }
        }
    }

    @Override
    public Iterator<Property> getChildren() {
        return this._children.iterator();
    }

    @Override
    public Iterator<Property> iterator() {
        return this.getChildren();
    }

    @Override
    public void addChild(Property property) throws IOException {
        String name = property.getName();
        if (this._children_names.contains(name)) {
            throw new IOException("Duplicate name \"" + name + "\"");
        }
        this._children_names.add(name);
        this._children.add(property);
    }

    public static class PropertyComparator
    implements Comparator<Property>,
    Serializable {
        @Override
        public int compare(Property o1, Property o2) {
            String VBA_PROJECT = "_VBA_PROJECT";
            String name1 = o1.getName();
            String name2 = o2.getName();
            int result2 = name1.length() - name2.length();
            if (result2 == 0) {
                result2 = name1.compareTo(VBA_PROJECT) == 0 ? 1 : (name2.compareTo(VBA_PROJECT) == 0 ? -1 : (name1.startsWith("__") && name2.startsWith("__") ? name1.compareToIgnoreCase(name2) : (name1.startsWith("__") ? 1 : (name2.startsWith("__") ? -1 : name1.compareToIgnoreCase(name2)))));
            }
            return result2;
        }
    }
}

