/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hpsf.ClipboardData;
import org.apache.poi.hpsf.CodePageString;
import org.apache.poi.hpsf.Filetime;
import org.apache.poi.hpsf.ReadingNotSupportedException;
import org.apache.poi.hpsf.TypeWriter;
import org.apache.poi.hpsf.TypedPropertyValue;
import org.apache.poi.hpsf.UnicodeString;
import org.apache.poi.hpsf.UnsupportedVariantTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.Variant;
import org.apache.poi.hpsf.VariantBool;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.util.CodePageUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Removal;

public class VariantSupport
extends Variant {
    public static final int[] SUPPORTED_TYPES = new int[]{0, 2, 3, 20, 5, 64, 30, 31, 71, 11};
    private static final POILogger logger = POILogFactory.getLogger(VariantSupport.class);
    private static boolean logUnsupportedTypes;
    private static List<Long> unsupportedMessage;

    public static void setLogUnsupportedTypes(boolean logUnsupportedTypes) {
        VariantSupport.logUnsupportedTypes = logUnsupportedTypes;
    }

    public static boolean isLogUnsupportedTypes() {
        return logUnsupportedTypes;
    }

    protected static void writeUnsupportedTypeMessage(UnsupportedVariantTypeException ex) {
        if (VariantSupport.isLogUnsupportedTypes()) {
            Long vt;
            if (unsupportedMessage == null) {
                unsupportedMessage = new LinkedList<Long>();
            }
            if (!unsupportedMessage.contains(vt = Long.valueOf(ex.getVariantType()))) {
                logger.log(7, ex.getMessage());
                unsupportedMessage.add(vt);
            }
        }
    }

    public boolean isSupportedType(int variantType) {
        for (int i = 0; i < SUPPORTED_TYPES.length; ++i) {
            if (variantType != SUPPORTED_TYPES[i]) continue;
            return true;
        }
        return false;
    }

    public static Object read(byte[] src, int offset, int length, long type, int codepage) throws ReadingNotSupportedException, UnsupportedEncodingException {
        int unpadded;
        TypedPropertyValue typedPropertyValue = new TypedPropertyValue((int)type, null);
        try {
            unpadded = typedPropertyValue.readValue(src, offset);
        }
        catch (UnsupportedOperationException exc) {
            int propLength = Math.min(length, src.length - offset);
            byte[] v = new byte[propLength];
            System.arraycopy(src, offset, v, 0, propLength);
            throw new ReadingNotSupportedException(type, v);
        }
        switch ((int)type) {
            case 0: 
            case 3: 
            case 5: 
            case 20: {
                return typedPropertyValue.getValue();
            }
            case 2: {
                return ((Short)typedPropertyValue.getValue()).intValue();
            }
            case 64: {
                Filetime filetime = (Filetime)typedPropertyValue.getValue();
                return Util.filetimeToDate((int)filetime.getHigh(), (int)filetime.getLow());
            }
            case 30: {
                CodePageString cpString = (CodePageString)typedPropertyValue.getValue();
                return cpString.getJavaValue(codepage);
            }
            case 31: {
                UnicodeString uniString = (UnicodeString)typedPropertyValue.getValue();
                return uniString.toJavaString();
            }
            case 71: {
                ClipboardData clipboardData = (ClipboardData)typedPropertyValue.getValue();
                return clipboardData.toByteArray();
            }
            case 11: {
                VariantBool bool = (VariantBool)typedPropertyValue.getValue();
                return bool.getValue();
            }
        }
        byte[] v = new byte[unpadded];
        System.arraycopy(src, offset, v, 0, unpadded);
        throw new ReadingNotSupportedException(type, v);
    }

    @Removal(version="3.18")
    public static String codepageToEncoding(int codepage) throws UnsupportedEncodingException {
        return CodePageUtil.codepageToEncoding(codepage);
    }

    public static int write(OutputStream out, long type, Object value, int codepage) throws IOException, WritingNotSupportedException {
        int length = 0;
        switch ((int)type) {
            case 11: {
                if (((Boolean)value).booleanValue()) {
                    out.write(255);
                    out.write(255);
                } else {
                    out.write(0);
                    out.write(0);
                }
                length += 2;
                break;
            }
            case 30: {
                CodePageString codePageString = new CodePageString((String)value, codepage);
                length += codePageString.write(out);
                break;
            }
            case 31: {
                int nrOfChars = ((String)value).length() + 1;
                length += TypeWriter.writeUIntToStream(out, nrOfChars);
                for (char s2 : ((String)value).toCharArray()) {
                    int high = (s2 & 0xFF00) >> 8;
                    int low = s2 & 0xFF;
                    byte highb = (byte)high;
                    byte lowb = (byte)low;
                    out.write(lowb);
                    out.write(highb);
                    length += 2;
                }
                out.write(0);
                out.write(0);
                length += 2;
                break;
            }
            case 71: {
                byte[] cf = (byte[])value;
                out.write(cf);
                length = cf.length;
                break;
            }
            case 0: {
                length += TypeWriter.writeUIntToStream(out, 0L);
                break;
            }
            case 2: {
                length += TypeWriter.writeToStream(out, ((Integer)value).shortValue());
                break;
            }
            case 3: {
                if (!(value instanceof Integer)) {
                    throw new ClassCastException("Could not cast an object to " + Integer.class.toString() + ": " + value.getClass().toString() + ", " + value.toString());
                }
                length += TypeWriter.writeToStream(out, (Integer)value);
                break;
            }
            case 20: {
                length += TypeWriter.writeToStream(out, (Long)value);
                break;
            }
            case 5: {
                length += TypeWriter.writeToStream(out, (Double)value);
                break;
            }
            case 64: {
                long filetime = Util.dateToFileTime((Date)value);
                int high = (int)(filetime >> 32 & 0xFFFFFFFFL);
                int low = (int)(filetime & 0xFFFFFFFFL);
                Filetime filetimeValue = new Filetime(low, high);
                length += filetimeValue.write(out);
                break;
            }
            default: {
                if (value instanceof byte[]) {
                    byte[] b = (byte[])value;
                    out.write(b);
                    length = b.length;
                    VariantSupport.writeUnsupportedTypeMessage(new WritingNotSupportedException(type, value));
                    break;
                }
                throw new WritingNotSupportedException(type, value);
            }
        }
        while ((length & 3) != 0) {
            out.write(0);
            ++length;
        }
        return length;
    }
}

